/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAttributeEditor {
    private Control control;
    private boolean decorationEnabled;
    private Label labelControl;
    private LayoutHint layoutHint;
    private final TaskDataModel manager;
    private final TaskAttribute taskAttribute;
    private boolean readOnly;

    public AbstractAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)taskAttribute);
        this.manager = manager;
        this.taskAttribute = taskAttribute;
        this.setDecorationEnabled(true);
        this.setReadOnly(taskAttribute.getMetaData().isReadOnly());
    }

    protected void attributeChanged() {
        this.getModel().attributeChanged(this.getTaskAttribute());
    }

    public abstract void createControl(Composite var1, FormToolkit var2);

    public void createLabelControl(Composite composite, FormToolkit toolkit) {
        this.labelControl = toolkit.createLabel(composite, this.getLabel());
        this.labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
    }

    public void dispose() {
    }

    public TaskDataModel getModel() {
        return this.manager;
    }

    protected TaskAttributeMapper getAttributeMapper() {
        return this.getModel().getTaskData().getAttributeMapper();
    }

    public Control getControl() {
        return this.control;
    }

    public String getLabel() {
        String label = this.getAttributeMapper().getLabel(this.getTaskAttribute());
        return TasksUiInternal.escapeLabelText(label);
    }

    public Label getLabelControl() {
        return this.labelControl;
    }

    public LayoutHint getLayoutHint() {
        return this.layoutHint;
    }

    public TaskAttribute getTaskAttribute() {
        return this.taskAttribute;
    }

    public boolean hasLabel() {
        return true;
    }

    public boolean isDecorationEnabled() {
        return this.decorationEnabled;
    }

    protected void setControl(Control control) {
        this.control = control;
    }

    public void setDecorationEnabled(boolean decorationEnabled) {
        this.decorationEnabled = decorationEnabled;
    }

    public void setLayoutHint(LayoutHint layoutHint) {
        this.layoutHint = layoutHint;
    }

    public void decorate(Color color) {
        if (this.isDecorationEnabled()) {
            if (this.manager.hasBeenRead() && this.manager.hasIncomingChanges(this.getTaskAttribute())) {
                this.decorateIncoming(color);
            }
            if (this.manager.hasOutgoingChanges(this.getTaskAttribute())) {
                this.decorateOutgoing(color);
            }
        }
    }

    protected void decorateOutgoing(Color color) {
        if (this.labelControl != null) {
            this.labelControl.setText("*" + this.labelControl.getText());
        }
    }

    protected void decorateIncoming(Color color) {
        if (this.getControl() != null) {
            this.getControl().setBackground(color);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }
}

