/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorInputFactory;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class TaskEditorInput
implements IEditorInput,
IPersistableElement {
    private static final int MAX_LABEL_LENGTH = 60;
    private final ITask task;
    private final TaskRepository taskRepository;
    private Object data;

    @Deprecated
    public TaskEditorInput(ITask task, boolean newTask) {
        this(TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl()), task);
    }

    public TaskEditorInput(TaskRepository taskRepository, ITask task) {
        Assert.isNotNull((Object)taskRepository);
        Assert.isNotNull((Object)task);
        this.taskRepository = taskRepository;
        this.task = task;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEditorInput other = (TaskEditorInput)obj;
        return this.task.equals(other.task);
    }

    public boolean exists() {
        return this.task != null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IEditorInput.class) {
            return this;
        }
        return null;
    }

    public String getFactoryId() {
        return "org.eclipse.mylyn.tasks.ui.elementFactories.task.editor";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Deprecated
    public String getLabel() {
        return this.getName();
    }

    public String getName() {
        String taskKey;
        String toolTipText = this.getToolTipText();
        if (toolTipText == null) {
            return null;
        }
        if (this.task != null && (taskKey = this.task.getTaskKey()) != null) {
            return this.truncate(String.valueOf(taskKey) + ": " + toolTipText);
        }
        return this.truncate(toolTipText);
    }

    public IPersistableElement getPersistable() {
        if (this.task != null && TasksUiPlugin.getTaskList().getTask(this.task.getHandleIdentifier()) != null) {
            return this;
        }
        return null;
    }

    public ITask getTask() {
        return this.task;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public String getToolTipText() {
        return this.task.getSummary();
    }

    public int hashCode() {
        return this.task.getTaskId().hashCode();
    }

    @Deprecated
    public boolean isNewTask() {
        return false;
    }

    public void saveState(IMemento memento) {
        TaskEditorInputFactory.saveState(memento, this);
    }

    private String truncate(String description) {
        if (description == null || description.length() <= 60) {
            return description;
        }
        return String.valueOf(description.substring(0, 60)) + "...";
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

