/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLEditorContentOutlinePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SQLEditorOutlineContentProvider
implements ITreeContentProvider {
    private SQLEditorContentOutlinePage fOutlinePage = null;
    private List fContent = null;
    public static final String SQL_SEGMENTS = "__sql_segments__";
    private IPositionUpdater fPositionUpdater = null;

    public SQLEditorOutlineContentProvider(SQLEditorContentOutlinePage outlinePage) {
        this.fOutlinePage = outlinePage;
        this.fContent = new ArrayList();
        this.fPositionUpdater = new DefaultPositionUpdater(SQL_SEGMENTS);
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        Object[] children = new Object[]{};
        if (this.hasChildren(element)) {
            children = this.fContent.toArray();
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        return this.fContent.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean value = false;
        if (element == this.fOutlinePage.getInput()) {
            value = true;
        }
        return value;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput != oldInput) {
            IDocument document;
            IDocumentProvider docProvider = this.fOutlinePage.getDocumentProvider();
            if (oldInput != null && (document = docProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(SQL_SEGMENTS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                document.removePositionUpdater(this.fPositionUpdater);
            }
            this.fContent.clear();
            if (newInput != null) {
                document = docProvider.getDocument(newInput);
                document.addPositionCategory(SQL_SEGMENTS);
                document.addPositionUpdater(this.fPositionUpdater);
                this.parse(document);
            }
        }
        if (newInput == null) {
            this.fContent.clear();
        }
    }

    public void parse(IDocument document) {
        int lines = document.getNumberOfLines();
        int increment = Math.max(Math.round(lines / 10), 10);
        int line = 0;
        while (line < lines) {
            int length = increment;
            if (line + increment > lines) {
                length = lines - line;
            }
            try {
                int offset = document.getLineOffset(line);
                int end = document.getLineOffset(line + length);
                length = end - offset;
                Position p = new Position(offset, length);
                document.addPosition(SQL_SEGMENTS, p);
                String segmentLabel = MessageFormat.format(SQLEditorResources.SQLEditor_outlinePage_sqlSegment_titlePattern, new Integer(offset));
                this.fContent.add(new SQLSegment(segmentLabel, p));
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
            line += increment;
        }
    }

    public List getContent() {
        return this.fContent;
    }

    public void clearContent() {
        this.fContent.clear();
    }

    public IPositionUpdater getPositionUpdater() {
        return this.fPositionUpdater;
    }

    protected static class SQLSegment {
        public String name;
        public Position position;

        public SQLSegment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }
    }
}

