/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.compatibility;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.compatibility.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JavaRuntimeVersionChecker
implements IStartup {
    private static final Float UNKNOWN_VERSION = new Float(0.0f);
    private static final String ID_PLUGIN = "org.eclipse.mylyn.compatibility";
    private static final String PREF_WARN_DISABLED = "org.eclipse.mylyn.internal.compatibility.warn.disabled";
    private static final float JRE_MIN_VERSION = 1.5f;

    public void earlyStartup() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ScopedPreferenceStore preferenceStore;
                    if (JavaRuntimeVersionChecker.isJavaVersionSmallerThan(1.5f) && !(preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), JavaRuntimeVersionChecker.ID_PLUGIN)).getBoolean(JavaRuntimeVersionChecker.PREF_WARN_DISABLED)) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.JavaRuntimeVersionChecker_JDK_Version_Check, (String)Messages.JavaRuntimeVersionChecker_Mylyn_was_installed_but_requires_Java_5_or_later_to_run, (String)Messages.JavaRuntimeVersionChecker_Do_not_warn_again, (boolean)false, (IPreferenceStore)preferenceStore, (String)JavaRuntimeVersionChecker.PREF_WARN_DISABLED);
                        preferenceStore.setValue(JavaRuntimeVersionChecker.PREF_WARN_DISABLED, dialog.getToggleState());
                        preferenceStore.save();
                    }
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public static boolean isJavaVersionSmallerThan(float minVersion) {
        Float result = JavaRuntimeVersionChecker.parseVersion(System.getProperty("java.runtime.version"));
        if (result == UNKNOWN_VERSION) {
            result = JavaRuntimeVersionChecker.parseVersion(System.getProperty("java.version"));
        }
        return result != UNKNOWN_VERSION && result.compareTo(new Float(minVersion)) < 0;
    }

    public static Float parseVersion(String versionString) {
        int minorIndex;
        if (versionString != null && (minorIndex = versionString.indexOf(46)) != -1) {
            try {
                int minorMinorIndex = versionString.indexOf(46, minorIndex + 1);
                if (minorMinorIndex != -1) {
                    return new Float(versionString.substring(0, minorMinorIndex));
                }
                return new Float(versionString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return UNKNOWN_VERSION;
    }
}

