/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.util;

import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObject2;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;

public class ModelUtilExt {
    public static SQLObject findProceduralObject(ProcIdentifier proc, boolean refresh, boolean caseSensitive, boolean ignoreTableName) {
        SQLObject object = null;
        Database db = ProfileUtil.getDatabase((DatabaseIdentifier)proc.getDatabaseIdentifier());
        if (db != null) {
            if (proc.getType() == 2) {
                if (refresh) {
                    if (db instanceof ICatalogObject2) {
                        String context = ((ICatalogObject2)db).getRefreshContext((Object)new Integer(10));
                        ((ICatalogObject2)db).refresh(context);
                    } else {
                        ((ICatalogObject)db).refresh();
                    }
                }
                EList events = db.getEvents();
                for (Event routine : events) {
                    if (!ModelUtil.equals((String)routine.getName(), (String)proc.getProcName(), (boolean)caseSensitive)) continue;
                    object = routine;
                }
            } else {
                EList schemas = ModelUtil.getSchemas((Database)db, (String)proc.getDatabaseName());
                object = ModelUtilExt.findProceduralObjectFromSchema(schemas, proc, caseSensitive, refresh, ignoreTableName);
            }
        }
        return object;
    }

    private static SQLObject findProceduralObjectFromSchema(EList schemas, ProcIdentifier proc, boolean caseSensitive, boolean refresh, boolean ignoreTableName) {
        Routine object = null;
        String owner = proc.getOwnerName();
        if (proc.getType() == 3 && proc.getTableOwnerName() != null) {
            owner = proc.getTableOwnerName();
        }
        for (Schema schema : schemas) {
            if (schema.getName() == null || !ModelUtil.equals((String)schema.getName(), (String)owner, (boolean)caseSensitive)) continue;
            if (proc.getType() == 3) {
                EList tables = schema.getTables();
                for (Table table : tables) {
                    if (!ignoreTableName && !ModelUtil.equals((String)table.getName(), (String)proc.getTableName(), (boolean)caseSensitive)) continue;
                    if (refresh && table instanceof ICatalogObject) {
                        if (table instanceof ICatalogObject2) {
                            String context = ((ICatalogObject2)table).getRefreshContext((Object)new Integer(12));
                            ((ICatalogObject2)table).refresh(context);
                        } else {
                            ((ICatalogObject)table).refresh();
                        }
                    }
                    EList triggers = table.getTriggers();
                    for (Trigger trigger : triggers) {
                        if (!ignoreTableName && !ModelUtil.equals((String)table.getName(), (String)proc.getTableName(), (boolean)caseSensitive) || !ModelUtil.equals((String)trigger.getName(), (String)proc.getProcName(), (boolean)caseSensitive)) continue;
                        object = trigger;
                        return object;
                    }
                }
                continue;
            }
            if (proc.getType() != 1 && proc.getType() != 0) continue;
            if (refresh) {
                if (schema instanceof ICatalogObject2) {
                    ICatalogObject2 catalogObject2 = (ICatalogObject2)schema;
                    String context = catalogObject2.getRefreshContext((Object)new Integer(16));
                    catalogObject2.refresh(context);
                } else if (schema instanceof ICatalogObject) {
                    ((ICatalogObject)schema).refresh();
                }
            }
            EList routines = schema.getRoutines();
            for (Routine routine : routines) {
                if (!ModelUtil.equals((String)routine.getName(), (String)proc.getProcName(), (boolean)caseSensitive)) continue;
                object = routine;
                return object;
            }
        }
        return object;
    }

    private static void refreshObjectBySchema(Schema schema, Object object) {
    }

    public static Schema getDefaultSchema(ConnectionInfo conInfo, Catalog catalog) {
        String schemaName = conInfo.getUserName();
        if (schemaName == null) {
            schemaName = ProfileUtil.getProfileUserName((DatabaseIdentifier)new DatabaseIdentifier(conInfo.getConnectionProfile().getName()), (boolean)false);
        }
        EList schemas = catalog.getSchemas();
        for (Schema sch : schemas) {
            if (!sch.getName().equals(schemaName)) continue;
            return sch;
        }
        return null;
    }
}

