/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class NLSHintHelper {
    private NLSHintHelper() {
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit astRoot, NLSElement nlsElement) {
        Region region = nlsElement.getPosition();
        return NLSHintHelper.getAccessorClassReference(astRoot, (IRegion)region);
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit astRoot, IRegion region) {
        IVariableBinding variableBinding;
        SimpleName name;
        IBinding binding;
        ASTNode nlsStringLiteral = NodeFinder.perform((ASTNode)astRoot, region.getOffset(), region.getLength());
        if (nlsStringLiteral == null) {
            return null;
        }
        ASTNode parent = nlsStringLiteral.getParent();
        ITypeBinding accessorBinding = null;
        if (nlsStringLiteral instanceof SimpleName && (binding = (name = (SimpleName)nlsStringLiteral).resolveBinding()) instanceof IVariableBinding && Modifier.isStatic((int)(variableBinding = (IVariableBinding)binding).getModifiers())) {
            accessorBinding = variableBinding.getDeclaringClass();
        }
        if (accessorBinding == null) {
            if (parent instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                List args = methodInvocation.arguments();
                if (args.indexOf(nlsStringLiteral) != 0) {
                    return null;
                }
                Expression firstArgument = (Expression)args.get(0);
                ITypeBinding argumentBinding = firstArgument.resolveTypeBinding();
                if (argumentBinding == null || !argumentBinding.getQualifiedName().equals("java.lang.String")) {
                    return null;
                }
                ITypeBinding typeBinding = methodInvocation.resolveTypeBinding();
                if (typeBinding == null || !typeBinding.getQualifiedName().equals("java.lang.String")) {
                    return null;
                }
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding == null || !Modifier.isStatic((int)methodBinding.getModifiers())) {
                    return null;
                }
                accessorBinding = methodBinding.getDeclaringClass();
            } else if (parent instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment decl = (VariableDeclarationFragment)parent;
                if (decl.getInitializer() != null) {
                    return null;
                }
                binding = decl.resolveBinding();
                if (!(binding instanceof IVariableBinding)) {
                    return null;
                }
                variableBinding = (IVariableBinding)binding;
                if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                    return null;
                }
                accessorBinding = variableBinding.getDeclaringClass();
            }
        }
        if (accessorBinding == null) {
            return null;
        }
        String resourceBundleName = NLSHintHelper.getResourceBundleName(accessorBinding);
        if (resourceBundleName != null) {
            return new AccessorClassReference(accessorBinding, resourceBundleName, new Region(parent.getStartPosition(), parent.getLength()));
        }
        return null;
    }

    public static IPackageFragment getPackageOfAccessorClass(IJavaProject javaProject, ITypeBinding accessorBinding) throws JavaModelException {
        ICompilationUnit unit;
        if (accessorBinding != null && (unit = Bindings.findCompilationUnit(accessorBinding, javaProject)) != null) {
            return (IPackageFragment)unit.getParent();
        }
        return null;
    }

    public static String getResourceBundleName(ITypeBinding accessorClassBinding) {
        IJavaElement je = accessorClassBinding.getJavaElement();
        if (!(je instanceof IType)) {
            return null;
        }
        ITypeRoot typeRoot = ((IType)je).getTypeRoot();
        CompilationUnit astRoot = SharedASTProvider.getAST(typeRoot, SharedASTProvider.WAIT_YES, null);
        return NLSHintHelper.getResourceBundleName(astRoot);
    }

    public static String getResourceBundleName(ITypeRoot input) {
        return NLSHintHelper.getResourceBundleName(SharedASTProvider.getAST(input, SharedASTProvider.WAIT_YES, null));
    }

    public static String getResourceBundleName(CompilationUnit astRoot) {
        String result;
        Object fieldName;
        if (astRoot == null) {
            return null;
        }
        final HashMap resultCollector = new HashMap(5);
        final Object RESULT_KEY = new Object();
        final Object FIELD_KEY = new Object();
        astRoot.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation node) {
                IBinding fieldNameBinding;
                IMethodBinding method = node.resolveMethodBinding();
                if (method == null) {
                    return true;
                }
                String name = method.getDeclaringClass().getQualifiedName();
                if (!("java.util.ResourceBundle".equals(name) && "getBundle".equals(method.getName()) && node.arguments().size() > 0 || "org.eclipse.osgi.util.NLS".equals(name) && "initializeMessages".equals(method.getName()) && node.arguments().size() == 2)) {
                    return true;
                }
                Expression argument = (Expression)node.arguments().get(0);
                String bundleName = this.getBundleName(argument);
                if (bundleName != null) {
                    resultCollector.put(RESULT_KEY, bundleName);
                }
                if (argument instanceof Name && (fieldNameBinding = ((Name)argument).resolveBinding()) != null) {
                    resultCollector.put(FIELD_KEY, fieldNameBinding);
                }
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                Expression initializer = node.getInitializer();
                String bundleName = this.getBundleName(initializer);
                if (bundleName != null) {
                    IBinding fieldNameBinding = node.getName().resolveBinding();
                    if (fieldNameBinding != null) {
                        resultCollector.put(fieldNameBinding, bundleName);
                    }
                    return false;
                }
                return true;
            }

            public boolean visit(Assignment node) {
                IBinding fieldNameBinding;
                String bundleName;
                if (node.getLeftHandSide() instanceof Name && (bundleName = this.getBundleName(node.getRightHandSide())) != null && (fieldNameBinding = ((Name)node.getLeftHandSide()).resolveBinding()) != null) {
                    resultCollector.put(fieldNameBinding, bundleName);
                    return false;
                }
                return true;
            }

            private String getBundleName(Expression initializer) {
                SimpleType simple;
                ITypeBinding typeBinding;
                MethodInvocation methInvocation;
                Expression exp;
                if (initializer instanceof StringLiteral) {
                    return ((StringLiteral)initializer).getLiteralValue();
                }
                if (initializer instanceof MethodInvocation && (exp = (methInvocation = (MethodInvocation)initializer).getExpression()) != null && exp instanceof TypeLiteral && (typeBinding = (simple = (SimpleType)((TypeLiteral)exp).getType()).resolveBinding()) != null) {
                    return typeBinding.getQualifiedName();
                }
                return null;
            }
        });
        Iterator iter = resultCollector.keySet().iterator();
        while (iter.hasNext()) {
            IBinding binding;
            Object o = iter.next();
            if (!(o instanceof IBinding) || !(fieldName = (binding = (IBinding)o).getName()).equals("BUNDLE_NAME") && !fieldName.equals("RESOURCE_BUNDLE") && !fieldName.equals("bundleName") || (result = (String)resultCollector.get(binding)) == null) continue;
            return result;
        }
        result = (String)resultCollector.get(RESULT_KEY);
        if (result != null) {
            return result;
        }
        fieldName = resultCollector.get(FIELD_KEY);
        if (fieldName != null) {
            return (String)resultCollector.get(fieldName);
        }
        return null;
    }

    public static IPackageFragment getResourceBundlePackage(IJavaProject javaProject, String packageName, String resourceName) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (packageFragment = root.getPackageFragment(packageName)).exists()) {
                Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaResources() : packageFragment.getNonJavaResources();
                int j = 0;
                while (j < resources.length) {
                    IFile file;
                    Object object = resources[j];
                    if (object instanceof IFile && (file = (IFile)object).getName().equals(resourceName)) {
                        return packageFragment;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(ICompilationUnit compilationUnit) throws JavaModelException {
        IJavaProject project = compilationUnit.getJavaProject();
        if (project == null) {
            return null;
        }
        String name = NLSHintHelper.getResourceBundleName((ITypeRoot)compilationUnit);
        if (name == null) {
            return null;
        }
        String packName = Signature.getQualifier((String)name);
        String resourceName = String.valueOf(Signature.getSimpleName((String)name)) + ".properties";
        return NLSHintHelper.getResourceBundle(project, packName, resourceName);
    }

    public static IStorage getResourceBundle(IJavaProject javaProject, String packageName, String resourceName) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IStorage storage;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (storage = NLSHintHelper.getResourceBundle(root, packageName, resourceName)) != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(IPackageFragmentRoot root, String packageName, String resourceName) throws JavaModelException {
        IPackageFragment packageFragment = root.getPackageFragment(packageName);
        if (packageFragment.exists()) {
            Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaResources() : packageFragment.getNonJavaResources();
            int j = 0;
            while (j < resources.length) {
                IStorage storage;
                Object object = resources[j];
                if (JavaModelUtil.isOpenableStorage(object) && (storage = (IStorage)object).getName().equals(resourceName)) {
                    return storage;
                }
                ++j;
            }
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaProject javaProject, AccessorClassReference accessorClassReference) throws JavaModelException {
        String resourceBundle = accessorClassReference.getResourceBundleName();
        if (resourceBundle == null) {
            return null;
        }
        String resourceName = String.valueOf(Signature.getSimpleName((String)resourceBundle)) + ".properties";
        String packName = Signature.getQualifier((String)resourceBundle);
        ITypeBinding accessorClass = accessorClassReference.getBinding();
        if (accessorClass.isFromSource()) {
            return NLSHintHelper.getResourceBundle(javaProject, packName, resourceName);
        }
        if (accessorClass.getJavaElement() != null) {
            return NLSHintHelper.getResourceBundle((IPackageFragmentRoot)accessorClass.getJavaElement().getAncestor(3), packName, resourceName);
        }
        return null;
    }

    public static Properties getProperties(IJavaProject javaProject, AccessorClassReference accessorClassReference) {
        try {
            IStorage storage = NLSHintHelper.getResourceBundle(javaProject, accessorClassReference);
            return NLSHintHelper.getProperties(storage);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static Properties getProperties(IStorage storage) {
        if (storage == null) {
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                ITextFileBuffer buffer;
                if (manager != null && (buffer = manager.getTextFileBuffer(storage.getFullPath(), LocationKind.NORMALIZE)) != null) {
                    IDocument document = buffer.getDocument();
                    is = new ByteArrayInputStream(document.get().getBytes());
                }
                if (is == null) {
                    is = storage.getContents();
                }
                props.load(is);
            }
            catch (IOException iOException) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        JavaPlugin.log(e);
                    }
                }
                return null;
            }
            catch (CoreException coreException) {
                block21: {
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        JavaPlugin.log(e);
                    }
                }
                return null;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return props;
    }
}

