/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GetterSetterCorrectionSubProcessor {
    public static final String SELF_ENCAPSULATE_FIELD_ID = "org.eclipse.jdt.ui.correction.encapsulateField.assist";

    public static boolean addGetterSetterProposal(IInvocationContext context, ASTNode coveringNode, IProblemLocation[] locations, ArrayList resultingCollections) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                int problemId = locations[i].getProblemId();
                if (problemId == 570425421) {
                    return false;
                }
                if (problemId == 570425423) {
                    return false;
                }
                ++i;
            }
        }
        return GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, coveringNode, (Collection)resultingCollections, 7);
    }

    public static void addGetterSetterProposal(IInvocationContext context, IProblemLocation location, Collection proposals, int relevance) {
        GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, location.getCoveringNode(context.getASTRoot()), proposals, relevance);
    }

    private static boolean addGetterSetterProposal(IInvocationContext context, ASTNode coveringNode, Collection proposals, int relevance) {
        if (!(coveringNode instanceof SimpleName)) {
            return false;
        }
        SimpleName sn = (SimpleName)coveringNode;
        IBinding binding = sn.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ChangeCorrectionProposal proposal = GetterSetterCorrectionSubProcessor.getProposal(context.getCompilationUnit(), sn, variableBinding, relevance);
        if (proposal != null) {
            proposals.add(proposal);
        }
        return true;
    }

    private static ChangeCorrectionProposal getProposal(ICompilationUnit cu, SimpleName sn, IVariableBinding variableBinding, int relevance) {
        SimpleName accessNode = sn;
        Name qualifier = null;
        boolean useSuper = false;
        ASTNode parent = sn.getParent();
        switch (parent.getNodeType()) {
            case 40: {
                accessNode = (Expression)parent;
                qualifier = ((QualifiedName)parent).getQualifier();
                break;
            }
            case 47: {
                accessNode = (Expression)parent;
                qualifier = ((SuperFieldAccess)parent).getQualifier();
                useSuper = true;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)sn.getAST());
        ProposalParameter gspc = new ProposalParameter(useSuper, cu, rewrite, (Expression)accessNode, (Expression)qualifier, variableBinding);
        if (ASTResolving.isWriteAccess((Name)sn)) {
            return GetterSetterCorrectionSubProcessor.addSetterProposal(gspc, relevance);
        }
        return GetterSetterCorrectionSubProcessor.addGetterProposal(gspc, relevance);
    }

    private static ChangeCorrectionProposal addGetterProposal(ProposalParameter context, int relevance) {
        IMethodBinding method = GetterSetterCorrectionSubProcessor.findGetter(context);
        if (method != null) {
            Expression mi = GetterSetterCorrectionSubProcessor.createMethodInvocation(context, method, null);
            context.astRewrite.replace((ASTNode)context.accessNode, (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithgetter_description, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)context.accessNode)));
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.compilationUnit, context.astRewrite, relevance, image);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                    return new SelfEncapsulateFieldProposal(relevance, field);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private static IMethodBinding findGetter(ProposalParameter context) {
        ITypeBinding returnType = context.variableBinding.getType();
        String getterName = GetterSetterUtil.getGetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, GetterSetterCorrectionSubProcessor.isBoolean(context));
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        IMethodBinding getter = Bindings.findMethodInHierarchy(declaringType, getterName, new ITypeBinding[0]);
        if (getter != null && getter.getReturnType().isAssignmentCompatible(returnType) && Modifier.isStatic((int)getter.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            return getter;
        }
        return null;
    }

    private static Expression createMethodInvocation(ProposalParameter context, IMethodBinding method, Expression argument) {
        AST ast = context.astRewrite.getAST();
        Expression qualifier = context.qualifier;
        if (context.useSuper) {
            SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
            invocation.setName(ast.newSimpleName(method.getName()));
            if (qualifier != null) {
                invocation.setQualifier((Name)context.astRewrite.createCopyTarget((ASTNode)qualifier));
            }
            if (argument != null) {
                invocation.arguments().add(argument);
            }
            return invocation;
        }
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(method.getName()));
        if (qualifier != null) {
            invocation.setExpression((Expression)context.astRewrite.createCopyTarget((ASTNode)qualifier));
        }
        if (argument != null) {
            invocation.arguments().add(argument);
        }
        return invocation;
    }

    private static ChangeCorrectionProposal addSetterProposal(ProposalParameter context, int relevance) {
        boolean isBoolean = GetterSetterCorrectionSubProcessor.isBoolean(context);
        String setterName = GetterSetterUtil.getSetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, isBoolean);
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        IMethodBinding method = Bindings.findMethodInHierarchy(declaringType, setterName, new ITypeBinding[]{context.variableBinding.getType()});
        if (method != null && Bindings.isVoidType(method.getReturnType()) && Modifier.isStatic((int)method.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            Expression assignedValue = GetterSetterCorrectionSubProcessor.getAssignedValue(context);
            if (assignedValue == null) {
                return null;
            }
            Expression mi = GetterSetterCorrectionSubProcessor.createMethodInvocation(context, method, assignedValue);
            context.astRewrite.replace(context.accessNode.getParent(), (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithsetter_description, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)context.accessNode)));
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.compilationUnit, context.astRewrite, relevance, image);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                    return new SelfEncapsulateFieldProposal(relevance, field);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isBoolean(ProposalParameter context) {
        boolean isBoolean;
        AST ast = context.astRewrite.getAST();
        boolean bl = isBoolean = ast.resolveWellKnownType("boolean") == context.variableBinding.getType();
        if (!isBoolean) {
            isBoolean = ast.resolveWellKnownType("java.lang.Boolean") == context.variableBinding.getType();
        }
        return isBoolean;
    }

    private static Expression getAssignedValue(ProposalParameter context) {
        boolean is50OrHigher;
        ITypeBinding type;
        Expression result;
        ASTNode parent = context.accessNode.getParent();
        ASTRewrite astRewrite = context.astRewrite;
        IJavaProject javaProject = context.compilationUnit.getJavaProject();
        IMethodBinding getter = GetterSetterCorrectionSubProcessor.findGetter(context);
        SimpleName getterExpression = null;
        if (getter != null) {
            getterExpression = astRewrite.getAST().newSimpleName("placeholder");
        }
        if ((result = GetterSetterUtil.getAssignedValue(parent, astRewrite, (Expression)getterExpression, type = context.variableBinding.getType(), is50OrHigher = JavaModelUtil.is50OrHigher(javaProject))) != null && getterExpression != null && getterExpression.getParent() != null) {
            getterExpression.getParent().setStructuralProperty(getterExpression.getLocationInParent(), (Object)GetterSetterCorrectionSubProcessor.createMethodInvocation(context, getter, null));
        }
        return result;
    }

    private static class ProposalParameter {
        public final boolean useSuper;
        public final ICompilationUnit compilationUnit;
        public final ASTRewrite astRewrite;
        public final Expression accessNode;
        public final Expression qualifier;
        public final IVariableBinding variableBinding;

        public ProposalParameter(boolean useSuper, ICompilationUnit compilationUnit, ASTRewrite rewrite, Expression accessNode, Expression qualifier, IVariableBinding variableBinding) {
            this.useSuper = useSuper;
            this.compilationUnit = compilationUnit;
            this.astRewrite = rewrite;
            this.accessNode = accessNode;
            this.qualifier = qualifier;
            this.variableBinding = variableBinding;
        }
    }

    public static class SelfEncapsulateFieldProposal
    extends ChangeCorrectionProposal {
        private IField fField;
        private boolean fNoDialog;

        public SelfEncapsulateFieldProposal(int relevance, IField field) {
            super(SelfEncapsulateFieldProposal.getDescription(field), null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fField = field;
            this.fNoDialog = false;
            this.setCommandId(GetterSetterCorrectionSubProcessor.SELF_ENCAPSULATE_FIELD_ID);
        }

        public IField getField() {
            return this.fField;
        }

        public void setNoDialog(boolean noDialog) {
            this.fNoDialog = noDialog;
        }

        public TextFileChange getChange(IFile file) throws CoreException {
            SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(this.fField);
            refactoring.setVisibility(1);
            refactoring.setConsiderVisibility(false);
            refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
            Change createdChange = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            if (createdChange instanceof CompositeChange) {
                Change[] children = ((CompositeChange)createdChange).getChildren();
                int i = 0;
                while (i < children.length) {
                    Change curr = children[i];
                    if (curr instanceof TextFileChange && ((TextFileChange)curr).getFile().equals((Object)file)) {
                        return (TextFileChange)curr;
                    }
                    ++i;
                }
            }
            return null;
        }

        private static String getDescription(IField field) {
            return Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_creategetterunsingencapsulatefield_description, BasicElementLabels.getJavaElementName(field.getElementName()));
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return CorrectionMessages.GetterSetterCorrectionSubProcessor_additional_info;
        }

        public void apply(IDocument document) {
            try {
                SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(this.fField);
                refactoring.setVisibility(1);
                refactoring.setConsiderVisibility(false);
                if (this.fNoDialog) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    RefactoringExecutionHelper helper = new RefactoringExecutionHelper(refactoring, 3, 4, JavaPlugin.getActiveWorkbenchShell(), (IRunnableContext)window);
                    if (Display.getCurrent() != null) {
                        try {
                            helper.perform(false, false);
                        }
                        catch (InterruptedException e) {
                            JavaPlugin.log(e);
                        }
                        catch (InvocationTargetException e) {
                            JavaPlugin.log(e);
                        }
                    } else {
                        Display.getDefault().syncExec(new Runnable(this, helper){
                            final /* synthetic */ SelfEncapsulateFieldProposal this$1;
                            private final /* synthetic */ RefactoringExecutionHelper val$helper;
                            {
                                this.this$1 = selfEncapsulateFieldProposal;
                                this.val$helper = refactoringExecutionHelper;
                            }

                            public void run() {
                                try {
                                    this.val$helper.perform(false, false);
                                }
                                catch (InterruptedException e) {
                                    JavaPlugin.log(e);
                                }
                                catch (InvocationTargetException e) {
                                    JavaPlugin.log(e);
                                }
                            }
                        });
                    }
                } else {
                    new RefactoringStarter().activate(new SelfEncapsulateFieldWizard(refactoring), JavaPlugin.getActiveWorkbenchShell(), "", 4);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), CorrectionMessages.GetterSetterCorrectionSubProcessor_encapsulate_field_error_title, CorrectionMessages.GetterSetterCorrectionSubProcessor_encapsulate_field_error_message);
            }
        }
    }
}

