/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;

public class SubTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SubTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle) {
        super(parent, (IContentProvider)new SubTypeHierarchyContentProvider(lifeCycle), lifeCycle);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.SubTypeHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.SubTypeHierarchyViewer_title;
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            int expandLevel = 2;
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class SubTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SubTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        protected final void getTypesInHierarchy(IType type, List res) {
            block5: {
                ITypeHierarchy hierarchy = this.getHierarchy();
                if (hierarchy == null) break block5;
                IType[] types = hierarchy.getSubtypes(type);
                if (this.isObject(type)) {
                    int i = 0;
                    while (i < types.length) {
                        IType curr = types[i];
                        if (!this.isAnonymousFromInterface(curr)) {
                            res.add(curr);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < types.length) {
                        res.add(types[i]);
                        ++i;
                    }
                }
            }
        }

        protected IType getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

