/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jpt.ui.CommonImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TableFigure
extends Figure {
    public static Color tableColor = new Color(null, 220, 232, 241);
    public static Font tableFont = new Font(null, "Arial", 8, 0);
    public static Color disabledColor = ColorConstants.white;
    public static Color borderColor = new Color(null, 14, 66, 115);
    public static final int OUTLINE_CORNER_RADIUS = 6;

    public TableFigure(String name) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 10;
        this.setLayoutManager((LayoutManager)gl);
        this.setBorder((Border)new LineBorder(tableColor, 0));
        this.setBackgroundColor(tableColor);
        this.setOpaque(true);
        this.setSize(150, 20);
        Label nameLabel = new Label("", CommonImages.createImage(CommonImages.TABLE_OBJ_IMAGE));
        nameLabel.setFont(tableFont);
        nameLabel.setText(name);
        nameLabel.setForegroundColor(borderColor);
        nameLabel.setLabelAlignment(2);
        this.add((IFigure)nameLabel);
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        graphics.pushState();
        Rectangle r = this.getBounds().getCopy();
        graphics.drawRoundRectangle(r.expand(new Insets(-1, -1, -2, -2)), 6, 6);
        graphics.popState();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackgroundColor(tableColor);
        } else {
            this.setBackgroundColor(disabledColor);
        }
    }
}

