/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class UndoTextFileChange
extends Change {
    private String fName;
    private UndoEdit fUndo;
    private IFile fFile;
    private ContentStamp fContentStampToRestore;
    private int fSaveMode;
    private boolean fDirty;
    private BufferValidationState fValidationState;

    protected UndoTextFileChange(String name, IFile file, UndoEdit undo, ContentStamp stamp, int saveMode) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)undo);
        this.fName = name;
        this.fFile = file;
        this.fUndo = undo;
        this.fContentStampToRestore = stamp;
        this.fSaveMode = saveMode;
    }

    public int getSaveMode() {
        return this.fSaveMode;
    }

    public String getName() {
        return this.fName;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.fSaveMode);
    }

    public Object getModifiedElement() {
        return this.fFile;
    }

    public Object[] getAffectedObjects() {
        Object modifiedElement = this.getModifiedElement();
        if (modifiedElement == null) {
            return null;
        }
        return new Object[]{modifiedElement};
    }

    public void initializeValidationData(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            this.fValidationState = BufferValidationState.create(this.fFile);
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            if (this.fValidationState == null) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "UndoTextFileChange has not been initialialized"));
            }
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            this.fDirty = buffer != null && buffer.isDirty();
            RefactoringStatus refactoringStatus = this.fValidationState.isValid(this.needsSaving(), true);
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        pm.beginTask("", 2);
        ITextFileBuffer buffer = null;
        try {
            manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            LinkedModeModel.closeAllModels((IDocument)document);
            ContentStamp currentStamp = ContentStamps.get(this.fFile, document);
            UndoEdit redo = this.fUndo.apply(document, 1);
            boolean success = ContentStamps.set(document, this.fContentStampToRestore);
            if (this.needsSaving()) {
                buffer.commit(pm, false);
                if (!success) {
                    ContentStamps.set(this.fFile, this.fContentStampToRestore);
                }
            }
            Change change = this.createUndoChange(redo, currentStamp);
            return change;
        }
        catch (BadLocationException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw Changes.asCoreException(e);
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        catch (MalformedTreeException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw Changes.asCoreException(e);
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        catch (CoreException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw e;
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
    }

    public void dispose() {
        if (this.fValidationState != null) {
            this.fValidationState.dispose();
        }
    }

    private boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }
}

