/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.packageview.CustomHashtable;
import org.eclipse.wst.jsdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetAwareContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetAwareJavaElementSorter;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.IPackagesViewPart;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;
import org.eclipse.wst.jsdt.ui.actions.CustomFiltersActionGroup;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.wst.jsdt.ui/perf/explorer/createPartControl";
    private static final String PERF_MAKE_ACTIONS = "org.eclipse.wst.jsdt.ui/perf/explorer/makeActions";
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String VIEW_ID = "org.eclipse.wst.jsdt.ui.PackageExplorer";
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_GROUP_LIBRARIES = "group_libraries";
    private static final String TAG_ROOT_MODE = "rootMode";
    private static final String TAG_LINK_EDITOR = "linkWithEditor";
    private static final String TAG_MEMENTO = "memento";
    private boolean fIsCurrentLayoutFlat = false;
    private boolean fShowLibrariesNode;
    private boolean fLinkingEnabled;
    private int fRootMode;
    private WorkingSetModel fWorkingSetModel;
    private PackageExplorerLabelProvider fLabelProvider;
    private DecoratingJavaLabelProvider fDecoratingLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelection fLastOpenSelection;
    private final ISelectionChangedListener fPostSelectionListener;
    private String fWorkingSetLabel;
    private IDialogSettings fDialogSettings;
    private IPartListener2 fLinkWithEditorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            if (element instanceof IJavaScriptUnit || element instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(element);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public PackageExplorerPart() {
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageExplorerPart.this.handlePostSelectionChanged(event);
            }
        };
        this.fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettingsSection(this.getClass().getName());
        this.fShowLibrariesNode = this.fDialogSettings.get(TAG_GROUP_LIBRARIES) == null || this.fDialogSettings.getBoolean(TAG_GROUP_LIBRARIES);
        this.fLinkingEnabled = this.fDialogSettings.getBoolean(TAG_LINK_EDITOR);
        try {
            this.fIsCurrentLayoutFlat = this.fDialogSettings.getInt(TAG_LAYOUT) == 2;
        }
        catch (NumberFormatException numberFormatException) {
            this.fIsCurrentLayoutFlat = false;
        }
        try {
            this.fRootMode = this.fDialogSettings.getInt(TAG_ROOT_MODE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fRootMode = 1;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String persistedMemento;
        super.init(site, memento);
        if (memento == null && (persistedMemento = this.fDialogSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {}
        }
        this.fMemento = memento;
        if (memento != null) {
            this.restoreLayoutState(memento);
            this.restoreLinkingEnabled(memento);
            this.restoreRootMode(memento);
        }
        if (this.showWorkingSets()) {
            this.createWorkingSetModel();
        }
    }

    private void restoreRootMode(IMemento memento) {
        Integer value = memento.getInteger(TAG_ROOT_MODE);
        int n = this.fRootMode = value == null ? 1 : value;
        if (this.fRootMode != 1 && this.fRootMode != 2) {
            this.fRootMode = 1;
        }
    }

    private void restoreLayoutState(IMemento memento) {
        Integer layoutState = memento.getInteger(TAG_LAYOUT);
        this.fIsCurrentLayoutFlat = layoutState == null || layoutState == 2;
        Integer groupLibraries = memento.getInteger(TAG_GROUP_LIBRARIES);
        this.fShowLibrariesNode = groupLibraries == null || groupLibraries != 0;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaScriptPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof PackageExplorerPart) {
            return (PackageExplorerPart)view;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaScriptPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"packageExplorer");
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this.fDialogSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)this);
        stats.startRun();
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        JavaScriptPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PackageExplorerPart.this.fActionSet.handleOpen(event);
                PackageExplorerPart.this.fLastOpenSelection = event.getSelection();
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.wst.jsdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater(this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        this.setLinkingEnabled(this.isLinkingEnabled());
        stats.endRun();
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fContentProvider.setShowLibrariesNode(this.fShowLibrariesNode);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setComparer(this.createElementComparer());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fDecoratingLabelProvider = new DecoratingJavaLabelProvider(this.fLabelProvider, false, this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fDecoratingLabelProvider);
    }

    public void setShowLibrariesNode(boolean enabled) {
        this.fShowLibrariesNode = enabled;
        this.saveDialogSettings();
        this.fContentProvider.setShowLibrariesNode(enabled);
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    boolean isLibrariesNodeShown() {
        return this.fShowLibrariesNode;
    }

    public void setFlatLayout(boolean enable) {
        this.fIsCurrentLayoutFlat = enable;
        this.saveDialogSettings();
        if (this.fViewer != null) {
            this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
            this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
            this.fDecoratingLabelProvider.setFlatPackageMode(this.isFlatLayout());
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
        if (this.showProjects()) {
            return new PackageExplorerContentProvider(showCUChildren);
        }
        return new WorkingSetAwareContentProvider(showCUChildren, this.fWorkingSetModel);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(this.fContentProvider);
    }

    private IElementComparer createElementComparer() {
        if (this.showProjects()) {
            return null;
        }
        return WorkingSetModel.COMPARER;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        if (this.showWorkingSets()) {
            return this.fWorkingSetModel;
        }
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return JavaScriptCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IJavaScriptElement element = JavaScriptCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaScriptCore.create((IWorkspaceRoot)JavaScriptPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.fViewer;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz4) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.wst.jsdt.ui.package_view_context");
        }
        return super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IJavaScriptModel ? PackagesMessages.PackageExplorerPart_workspace : (element instanceof IJavaScriptElement ? JavaScriptElementLabels.getTextLabel(element, JavaScriptElementLabels.ALL_FULLY_QUALIFIED) : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : (element instanceof WorkingSetModel ? PackagesMessages.PackageExplorerPart_workingSetModel : this.fLabelProvider.getText(element))))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PackagesMessages.PackageExplorer_title : path.makeRelative().toString());
        if (this.fRootMode == 1) {
            if (this.fWorkingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip, new String[]{this.fWorkingSetLabel});
            }
            return Messages.format(PackagesMessages.PackageExplorer_toolTip2, new String[]{result, this.fWorkingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && !(element instanceof WorkingSetModel) && this.fActionSet != null) {
            FrameList frameList = this.fActionSet.getFrameList();
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip3, new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaScriptPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_MAKE_ACTIONS, (Object)this);
        stats.startRun();
        this.fActionSet = new PackageExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        stats.endRun();
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer), new FileTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(ops, transfers, new JdtViewerDragAdapter((StructuredViewer)this.fViewer, dragListeners));
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fViewer), new FileTransferDropAdapter((AbstractTreeViewer)this.fViewer), new WorkingSetDropAdapter(this)};
        this.fViewer.addDropSupport(ops, transfers, new DelegatingDropAdapter(dropListeners));
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = null;
    }

    public void selectReveal(ISelection selection) {
        Control ctrl = this.getTreeViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        this.fContentProvider.runPendingUpdates();
        this.fViewer.setSelection(this.convertSelection(selection), true);
    }

    public ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((IStructuredSelection)s).toArray();
        boolean changed = false;
        int i = 0;
        while (i < elements.length) {
            Object convertedElement = this.convertElement(elements[i]);
            changed = changed || convertedElement != elements[i];
            elements[i] = convertedElement;
            ++i;
        }
        if (changed) {
            return new StructuredSelection(elements);
        }
        return s;
    }

    private Object convertElement(Object original) {
        if (original instanceof IJavaScriptElement) {
            IResource resource;
            IJavaScriptUnit cu;
            IJavaScriptProject javaProject;
            if (original instanceof IJavaScriptUnit && (javaProject = (cu = (IJavaScriptUnit)original).getJavaScriptProject()) != null && javaProject.exists() && !javaProject.isOnIncludepath((IJavaScriptElement)cu) && (resource = cu.getResource()) != null) {
                return resource;
            }
            return original;
        }
        if (original instanceof IResource) {
            IJavaScriptProject javaProject;
            IJavaScriptElement je = JavaScriptCore.create((IResource)((IResource)original));
            if (je != null && je.exists() && (javaProject = je.getJavaScriptProject()) != null && javaProject.exists()) {
                return je;
            }
        } else if (original instanceof IAdaptable) {
            IResource r;
            IJavaScriptElement je;
            IAdaptable adaptable = (IAdaptable)original;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((je = (IJavaScriptElement)adaptable.getAdapter((Class)clazz)) != null && je.exists()) {
                return je;
            }
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)adaptable.getAdapter((Class)clazz2)) != null) {
                je = JavaScriptCore.create((IResource)r);
                if (je != null && je.exists()) {
                    return je;
                }
                return r;
            }
        }
        return original;
    }

    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaScriptElement) {
                EditorUtility.revealInEditor(part, (IJavaScriptElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null && this.fMemento != null) {
            memento.putMemento(this.fMemento);
            return;
        }
        memento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(memento);
        }
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        if (this.fActionSet != null) {
            this.fActionSet.saveFilterAndSorterState(memento);
        }
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(TAG_LINK_EDITOR, this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
            memento.putInteger(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode ? 1 : 0);
        }
    }

    private void saveDialogSettings() {
        this.fDialogSettings.put(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode);
        this.fDialogSettings.put(TAG_LAYOUT, this.getLayoutAsInt());
        this.fDialogSettings.put(TAG_ROOT_MODE, this.fRootMode);
        this.fDialogSettings.put(TAG_LINK_EDITOR, this.fLinkingEnabled);
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    private void restoreFilterAndSorter() {
        this.setComparator();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(TAG_LINK_EDITOR);
        this.fLinkingEnabled = val != null && val != 0;
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    void editorActivated(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        Object input = this.getInputFromEditor(editorInput);
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editorInput)) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private Object getInputFromEditor(IEditorInput editorInput) {
        Object input = JavaScriptUI.getEditorInputJavaElement(editorInput);
        if (input == null) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            input = editorInput.getAdapter((Class)clazz);
        }
        if (input == null && editorInput instanceof IStorageEditorInput) {
            try {
                input = ((IStorageEditorInput)editorInput).getStorage();
            }
            catch (CoreException coreException) {}
        }
        return input;
    }

    private boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = null;
        try {
            selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        return input.equals(selectionAsInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnClassPath((IFile)input)) {
            element = JavaScriptCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element == null) return false;
        StructuredSelection newSelection = new StructuredSelection(element);
        if (this.fViewer.getSelection().equals(newSelection)) {
            this.fViewer.reveal(element);
            return true;
        }
        try {
            this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
            this.fViewer.setSelection((ISelection)newSelection, true);
            while (element != null && this.fViewer.getSelection().isEmpty()) {
                if ((element = this.getParent(element)) == null) continue;
                newSelection = new StructuredSelection(element);
                this.fViewer.setSelection((ISelection)newSelection, true);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        return true;
    }

    private boolean isOnClassPath(IFile file) {
        IJavaScriptProject jproject = JavaScriptCore.create((IProject)file.getProject());
        return jproject.isOnIncludepath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getParent();
        }
        return null;
    }

    void expandMainType(Object element) {
        try {
            IType type = null;
            if (element instanceof IJavaScriptUnit) {
                IJavaScriptUnit cu = (IJavaScriptUnit)element;
                IType[] types = cu.getTypes();
                if (types.length > 0) {
                    type = types[0];
                }
            } else if (element instanceof IClassFile) {
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
            }
            if (type != null) {
                final IType type2 = type;
                Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Control ctrl2 = PackageExplorerPart.this.fViewer.getControl();
                            if (ctrl2 != null && !ctrl2.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetLabel(String workingSetName) {
        this.fWorkingSetLabel = workingSetName;
        this.setTitleToolTip(this.getTitleToolTip());
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof IJavaScriptModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = JavaScriptElementLabels.getTextLabel(input, 36283885813802L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.wst.jsdt.ui.packages.cuchildren".equals(event.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
            ((StandardJavaScriptElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        } else if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public boolean show(ShowInContext context) {
        Object input;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                int res = this.tryToReveal(structuredSelection.getFirstElement());
                if (res == 0) {
                    return true;
                }
                if (res == 8) {
                    return false;
                }
            } else if (structuredSelection.size() > 1) {
                this.selectReveal((ISelection)structuredSelection);
                return true;
            }
        }
        if ((input = context.getInput()) instanceof IEditorInput) {
            Object elementOfInput = this.getInputFromEditor((IEditorInput)input);
            return elementOfInput != null && this.tryToReveal(elementOfInput) == 0;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getTreeViewer().getInput(), PackageExplorerPart.this.getTreeViewer().getSelection());
            }
        };
    }

    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        this.saveDialogSettings();
        IWorkbenchPage page = this.getSite().getPage();
        if (enabled) {
            page.addPartListener(this.fLinkWithEditorListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePartListener(this.fLinkWithEditorListener);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getElementName();
        }
        if (element instanceof WorkingSetModel) {
            return "";
        }
        return this.fLabelProvider.getText(element);
    }

    public int tryToReveal(Object element) {
        String[] newFilters;
        CustomFiltersActionGroup filterGroup;
        String[] currentFilters;
        if (this.revealElementOrParent(element)) {
            return 0;
        }
        WorkingSetFilterActionGroup workingSetGroup = this.fActionSet.getWorkingSetActionGroup().getFilterGroup();
        if (workingSetGroup != null) {
            IWorkingSet workingSet = workingSetGroup.getWorkingSet();
            if (workingSetGroup.isFiltered(this.getVisibleParent(element), element)) {
                String message;
                if (element instanceof IJavaScriptElement) {
                    String elementLabel = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)element, JavaScriptElementLabels.ALL_DEFAULT);
                    message = Messages.format(PackagesMessages.PackageExplorerPart_notFoundSepcific, new String[]{elementLabel, workingSet.getLabel()});
                } else {
                    message = Messages.format(PackagesMessages.PackageExplorer_notFound, workingSet.getLabel());
                }
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                    workingSetGroup.setWorkingSet(null, true);
                    if (this.revealElementOrParent(element)) {
                        return 0;
                    }
                } else {
                    return 8;
                }
            }
        }
        if ((currentFilters = (filterGroup = this.fActionSet.getCustomFilterActionGroup()).internalGetEnabledFilterIds()).length > (newFilters = filterGroup.removeFiltersFor(this.getVisibleParent(element), element, this.getTreeViewer().getContentProvider())).length) {
            String message;
            if (element instanceof IJavaScriptElement) {
                String elementLabel = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)element, JavaScriptElementLabels.ALL_DEFAULT);
                message = Messages.format(PackagesMessages.PackageExplorerPart_removeFiltersSpecific, elementLabel);
            } else {
                message = PackagesMessages.PackageExplorer_removeFilters;
            }
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                filterGroup.setFilters(newFilters);
                if (this.revealElementOrParent(element)) {
                    return 0;
                }
            } else {
                return 8;
            }
        }
        FrameAction action = this.fActionSet.getUpAction();
        while (action.getFrameList().getCurrentIndex() > 0) {
            if (action.getFrameList().getSource().getFrame(3, 0) == null) break;
            action.run();
            if (!this.revealElementOrParent(element)) continue;
            return 0;
        }
        return 4;
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        if ((element = this.getVisibleParent(element)) != null) {
            IResource resource;
            if (this.revealAndVerify(element)) {
                return true;
            }
            if (element instanceof IJavaScriptElement && (resource = ((IJavaScriptElement)element).getResource()) != null && this.revealAndVerify(resource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IJavaScriptElement)) {
            return object;
        }
        IJavaScriptElement element2 = (IJavaScriptElement)object;
        switch (element2.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                element2 = (IJavaScriptElement)element2.getOpenable();
                break;
            }
            case 1: {
                element2 = null;
            }
        }
        return element2;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        this.saveDialogSettings();
        if (this.showWorkingSets() && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        StructuredSelection selection = new StructuredSelection(((IStructuredSelection)this.fViewer.getSelection()).toArray());
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = JavaScriptCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setComparator();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection((ISelection)selection, true);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.fViewer.getControl().setRedraw(true);
        if (isRootInputChange && this.showWorkingSets() && this.fWorkingSetModel.needsConfiguration()) {
            ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.getSite());
            action.setWorkingSetModel(this.fWorkingSetModel);
            action.run();
            this.fWorkingSetModel.configured();
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    private void createWorkingSetModel() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(PackageExplorerPart.this.fMemento);
            }

            public void handleException(Throwable exception) {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(null);
            }
        });
    }

    public IWorkingSet getFilterWorkingSet() {
        if (!this.showProjects()) {
            return null;
        }
        if (this.fActionSet == null) {
            return null;
        }
        return this.fActionSet.getWorkingSetActionGroup().getFilterGroup().getWorkingSet();
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    private void setComparator() {
        if (this.showWorkingSets()) {
            this.fViewer.setComparator(new WorkingSetAwareJavaElementSorter());
        } else {
            this.fViewer.setComparator(new JavaScriptElementComparator());
        }
    }

    public void internalTestShowWorkingSets(IWorkingSet[] workingSets) {
        if (this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
        }
        this.fWorkingSetModel.setActiveWorkingSets(workingSets);
        this.fWorkingSetModel.configured();
        this.rootModeChanged(2);
    }

    private class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        private List fPendingRefreshes = Collections.synchronizedList(new ArrayList());
        private boolean fInPreserveSelection;

        public PackageExplorerProblemTreeViewer(Composite parent, int style) {
            super(parent, style);
            ColoredViewersManager.install((StructuredViewer)this);
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingRefreshes.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void internalRefresh(Object element, boolean updateLabels) {
            try {
                this.fPendingRefreshes.add(element);
                super.internalRefresh(element, updateLabels);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fPendingRefreshes.remove(element);
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.fPendingRefreshes.remove(element);
            }
        }

        protected boolean evaluateExpandableWithFilters(Object parent) {
            if (parent instanceof IJavaScriptProject || parent instanceof IJavaScriptUnit || parent instanceof IClassFile || parent instanceof JsGlobalScopeContainer) {
                return false;
            }
            return !(parent instanceof IPackageFragmentRoot) || !((IPackageFragmentRoot)parent).isArchive();
        }

        protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
            if (object instanceof PackageFragmentRootContainer) {
                return !this.hasFilteredChildren(object);
            }
            boolean res = super.isFiltered(object, parent, filters);
            if (res && this.isEssential(object)) {
                return false;
            }
            return res;
        }

        private boolean isEssential(Object object) {
            try {
                IPackageFragment fragment;
                if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment && !(fragment = (IPackageFragment)object).isDefaultPackage() && fragment.hasSubpackages()) {
                    return this.hasFilteredChildren(fragment);
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
            boolean changed = false;
            Iterator iter = is.iterator();
            while (iter.hasNext()) {
                IProject project;
                Object element = iter.next();
                if (element instanceof IJavaScriptProject) {
                    project = ((IJavaScriptProject)element).getProject();
                    if (project.isOpen() || !project.exists()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                IJavaScriptProject jProject = JavaScriptCore.create((IProject)project);
                if (jProject != null && jProject.exists()) {
                    ns.add(jProject);
                }
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }

        protected Object[] addAditionalProblemParents(Object[] elements) {
            if (PackageExplorerPart.this.showWorkingSets() && elements != null) {
                return PackageExplorerPart.this.fWorkingSetModel.addWorkingSets(elements);
            }
            return elements;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void preservingSelection(Runnable updateCode) {
            try {
                this.fInPreserveSelection = true;
                super.preservingSelection(updateCode);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fInPreserveSelection = false;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fInPreserveSelection = false;
                return;
            }
        }

        protected void setSelectionToWidget(ISelection selection, boolean reveal) {
            super.setSelectionToWidget(selection, reveal);
        }

        private Widget internalFindChild(Widget parent, Object element) {
            Item[] items = this.getChildren(parent);
            int i = 0;
            while (i < items.length) {
                Item item = items[i];
                Object data = item.getData();
                if (data != null && this.equals(data, element)) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        private CustomHashtable createRootAccessedMap(TreePath[] paths) {
            CustomHashtable result = new CustomHashtable(this.getComparer());
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                Object root = path.getFirstSegment();
                if (root != null) {
                    result.put(root, path);
                }
                ++i;
            }
            return result;
        }
    }
}

