/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.osgi.util.NLS;

public class LocalUpdateSiteAction
implements IPublisherAction {
    protected String source;
    private UpdateSite updateSite;
    private String categoryQualifier;
    static /* synthetic */ Class class$0;

    protected LocalUpdateSiteAction() {
    }

    public LocalUpdateSiteAction(String source, String categoryQualifier) {
        this.source = source;
        this.categoryQualifier = categoryQualifier;
    }

    public LocalUpdateSiteAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        IPublisherAction[] actions = this.createActions();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.updatesite.LocalUpdateSiteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MultiStatus finalStatus = new MultiStatus(clazz.getName(), 0, NLS.bind((String)Messages.Error_Generation, (Object)(this.source != null ? this.source : (this.updateSite != null ? this.updateSite.getLocation().toString() : "Unknown"))), null);
        int i = 0;
        while (i < actions.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            finalStatus.merge(actions[i].perform(info, results, monitor));
            ++i;
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        return Status.OK_STATUS;
    }

    protected IPublisherAction[] createActions() {
        this.createAdvice();
        ArrayList<Object> result = new ArrayList<Object>();
        MergeResultsAction action = new MergeResultsAction(new IPublisherAction[]{this.createFeaturesAction(), this.createBundlesAction()}, 2);
        result.add(action);
        result.add(this.createSiteXMLAction());
        return result.toArray(new IPublisherAction[result.size()]);
    }

    private IPublisherAction createSiteXMLAction() {
        if (this.updateSite != null) {
            return new SiteXMLAction(this.updateSite, this.categoryQualifier);
        }
        if (this.source != null) {
            SiteXMLAction siteXmlAction = new SiteXMLAction(new File(this.source, "site.xml").toURI(), this.categoryQualifier);
            return siteXmlAction;
        }
        return null;
    }

    private void createAdvice() {
    }

    protected IPublisherAction createFeaturesAction() {
        return new FeaturesAction(new File[]{new File(this.source, "features")});
    }

    protected IPublisherAction createBundlesAction() {
        return new BundlesAction(new File[]{new File(this.source, "plugins")});
    }
}

