/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class DataModelWizardExtensionReader
extends RegistryReader {
    private static final String EXTENSION = "DataModelWizardExtension";
    private static final String ELEMENT = "DataModelWizard";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private HashMap extensions;

    public DataModelWizardExtensionReader() {
        super("org.eclipse.wst.common.frameworks.ui", EXTENSION);
    }

    public boolean readElement(IConfigurationElement element) {
        String className;
        if (!element.getName().equals(ELEMENT)) {
            return false;
        }
        String id = element.getAttribute(ATTRIBUTE_ID);
        if (id == null || id.trim().length() == 0) {
            WTPUIPlugin.logError(new RuntimeException("Extension:DataModelWizardExtension Element:DataModelWizard is missing id"));
        }
        if ((className = element.getAttribute(ATTRIBUTE_CLASS)) == null || className.trim().length() == 0) {
            WTPUIPlugin.logError(new RuntimeException("Extension:DataModelWizardExtension Element:DataModelWizard is missing class"));
        }
        this.addExtension(id, element);
        return true;
    }

    private void addExtension(String id, IConfigurationElement element) {
        if (this.extensions.containsKey(id)) {
            WTPUIPlugin.logError(new RuntimeException("Duplicate DataModelWizard id " + id));
        }
        this.extensions.put(id, element);
    }

    protected IConfigurationElement getExtension(String id) {
        IConfigurationElement element;
        if (this.extensions == null) {
            this.extensions = new HashMap();
            this.readRegistry();
        }
        if ((element = (IConfigurationElement)this.extensions.get(id)) == null) {
            throw new RuntimeException("Extension:DataModelWizardExtension Element:DataModelWizard not found for id: " + id);
        }
        return element;
    }

    public DataModelWizard getWizard(IDataModel dataModel) {
        DataModelWizard wizard = null;
        IConfigurationElement element = this.getExtension(dataModel.getID());
        try {
            wizard = (DataModelWizard)element.createExecutableExtension(ATTRIBUTE_CLASS);
            wizard.setDataModel(dataModel);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return wizard;
    }
}

