/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.internal.JDBCType;
import org.eclipse.jpt.utility.internal.SimpleJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCTools {
    private static HashMap<String, JDBCToJavaTypeMapping> JDBC_TO_JAVA_TYPE_MAPPINGS;
    private static final JavaType DEFAULT_JAVA_TYPE;
    private static HashMap<String, JavaToJDBCTypeMapping> JAVA_TO_JDBC_TYPE_MAPPINGS;
    private static final JDBCType DEFAULT_JDBC_TYPE;

    static {
        DEFAULT_JAVA_TYPE = new SimpleJavaType(Object.class);
        DEFAULT_JDBC_TYPE = JDBCType.type(12);
    }

    public static JDBCType jdbcTypeForClassNamed(String className) {
        JavaToJDBCTypeMapping mapping = JDBCTools.javaToJDBCTypeMapping(className);
        return mapping == null ? DEFAULT_JDBC_TYPE : mapping.getJDBCType();
    }

    public static JDBCType jdbcTypeFor(Class<?> javaClass) {
        return JDBCTools.jdbcTypeForClassNamed(javaClass.getName());
    }

    public static JDBCType jdbcTypeFor(JavaType javaType) {
        return JDBCTools.jdbcTypeForClassNamed(javaType.getJavaClassName());
    }

    public static JavaType javaTypeForJDBCTypeNamed(String jdbcTypeName) {
        JDBCToJavaTypeMapping mapping = JDBCTools.jdbcToJavaTypeMapping(jdbcTypeName);
        return mapping == null ? DEFAULT_JAVA_TYPE : mapping.getJavaType();
    }

    public static JavaType javaTypeFor(JDBCType jdbcType) {
        return JDBCTools.javaTypeForJDBCTypeNamed(jdbcType.name());
    }

    public static JavaType javaTypeForJDBCTypeCode(int jdbcTypeCode) {
        return JDBCTools.javaTypeFor(JDBCType.type(jdbcTypeCode));
    }

    private static JDBCToJavaTypeMapping jdbcToJavaTypeMapping(String jdbcTypeName) {
        return JDBCTools.jdbcToJavaTypeMappings().get(jdbcTypeName);
    }

    private static synchronized HashMap<String, JDBCToJavaTypeMapping> jdbcToJavaTypeMappings() {
        if (JDBC_TO_JAVA_TYPE_MAPPINGS == null) {
            JDBC_TO_JAVA_TYPE_MAPPINGS = JDBCTools.buildJDBCToJavaTypeMappings();
        }
        return JDBC_TO_JAVA_TYPE_MAPPINGS;
    }

    private static HashMap<String, JDBCToJavaTypeMapping> buildJDBCToJavaTypeMappings() {
        HashMap<String, JDBCToJavaTypeMapping> mappings = new HashMap<String, JDBCToJavaTypeMapping>();
        JDBCTools.addJDBCToJavaTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addJDBCToJavaTypeMappingsTo(HashMap<String, JDBCToJavaTypeMapping> mappings) {
        JDBCTools.addJDBCToJavaTypeMappingTo(2003, Array.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-5, Long.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-2, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-7, Boolean.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2004, Blob.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(16, Boolean.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(1, String.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2005, Clob.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(70, URL.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(91, Date.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(3, BigDecimal.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2001, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(8, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(6, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(4, Integer.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2000, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-4, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-1, String.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2, BigDecimal.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(1111, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(7, Float.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2006, Ref.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(5, Short.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(2002, Struct.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(92, Time.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(93, Timestamp.class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-6, Byte.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-3, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(12, String.class, mappings);
    }

    private static void addJDBCToJavaTypeMappingTo(int jdbcTypeCode, Class<?> javaClass, HashMap<String, JDBCToJavaTypeMapping> mappings) {
        JDBCType jdbcType = JDBCType.type(jdbcTypeCode);
        JDBCToJavaTypeMapping prev = mappings.put(jdbcType.name(), JDBCTools.buildJDBCToJavaTypeMapping(jdbcType, javaClass));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate JDBC type: " + jdbcType.name());
        }
    }

    private static JDBCToJavaTypeMapping buildJDBCToJavaTypeMapping(JDBCType jdbcType, Class<?> javaClass) {
        return new JDBCToJavaTypeMapping(jdbcType, new SimpleJavaType(javaClass));
    }

    private static JavaToJDBCTypeMapping javaToJDBCTypeMapping(String className) {
        return JDBCTools.javaToJDBCTypeMappings().get(className);
    }

    private static synchronized HashMap<String, JavaToJDBCTypeMapping> javaToJDBCTypeMappings() {
        if (JAVA_TO_JDBC_TYPE_MAPPINGS == null) {
            JAVA_TO_JDBC_TYPE_MAPPINGS = JDBCTools.buildJavaToJDBCTypeMappings();
        }
        return JAVA_TO_JDBC_TYPE_MAPPINGS;
    }

    private static HashMap<String, JavaToJDBCTypeMapping> buildJavaToJDBCTypeMappings() {
        HashMap<String, JavaToJDBCTypeMapping> mappings = new HashMap<String, JavaToJDBCTypeMapping>();
        JDBCTools.addJavaToJDBCTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addJavaToJDBCTypeMappingsTo(HashMap<String, JavaToJDBCTypeMapping> mappings) {
        JDBCTools.addJavaToJDBCTypeMappingTo(Boolean.TYPE, -7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Byte.TYPE, -6, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Double.TYPE, 8, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Float.TYPE, 7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Integer.TYPE, 4, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Long.TYPE, -5, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Short.TYPE, 5, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Boolean.class, -7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Byte.class, -6, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Double.class, 8, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Float.class, 7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Integer.class, 4, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Long.class, -5, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Short.class, 5, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(String.class, 12, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(BigDecimal.class, 2, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(URL.class, 70, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Array.class, 2003, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Blob.class, 2004, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Clob.class, 2005, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Date.class, 91, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Ref.class, 2006, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Struct.class, 2002, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Time.class, 92, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Timestamp.class, 93, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(byte[].class, -3, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Byte[].class, -3, mappings);
    }

    private static void addJavaToJDBCTypeMappingTo(Class<?> javaClass, int jdbcTypeCode, HashMap<String, JavaToJDBCTypeMapping> mappings) {
        JavaToJDBCTypeMapping prev = mappings.put(javaClass.getName(), JDBCTools.buildJavaToJDBCTypeMapping(javaClass, jdbcTypeCode));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate Java class: " + prev.getJavaType().declaration());
        }
    }

    private static JavaToJDBCTypeMapping buildJavaToJDBCTypeMapping(Class<?> javaClass, int jdbcTypeCode) {
        return new JavaToJDBCTypeMapping(new SimpleJavaType(javaClass), JDBCType.type(jdbcTypeCode));
    }

    private JDBCTools() {
        throw new UnsupportedOperationException();
    }

    private static class JDBCToJavaTypeMapping {
        private final JDBCType jdbcType;
        private final JavaType javaType;

        JDBCToJavaTypeMapping(JDBCType jdbcType, JavaType javaType) {
            this.jdbcType = jdbcType;
            this.javaType = javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public boolean maps(int jdbcTypeCode) {
            return this.jdbcType.code() == jdbcTypeCode;
        }

        public boolean maps(String jdbcTypeName) {
            return this.jdbcType.name().equals(jdbcTypeName);
        }

        public boolean maps(JDBCType type) {
            return this.jdbcType == type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuilder sb) {
            this.jdbcType.appendTo(sb);
            sb.append(" => ");
            this.javaType.appendDeclarationTo(sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaToJDBCTypeMapping {
        private final JavaType javaType;
        private final JDBCType jdbcType;

        JavaToJDBCTypeMapping(JavaType javaType, JDBCType jdbcType) {
            this.javaType = javaType;
            this.jdbcType = jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public boolean maps(JavaType jt) {
            return this.javaType.equals(jt);
        }

        public boolean maps(String elementTypeName, int arrayDepth) {
            return this.javaType.equals(elementTypeName, arrayDepth);
        }

        public boolean maps(String javaClassName) {
            return this.javaType.describes(javaClassName);
        }

        public boolean maps(Class<?> javaClass) {
            return this.javaType.describes(javaClass);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuilder sb) {
            this.javaType.appendDeclarationTo(sb);
            sb.append(" => ");
            this.jdbcType.appendTo(sb);
        }
    }
}

