/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import java.io.InputStream;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;

public class CopyThread
extends SecuredThread
implements ICancellableHandler {
    protected DataElement targetFolder;
    protected DataElement theElement;
    protected DataElement status;
    protected UniversalFileSystemMiner miner;
    protected boolean isWindows;
    protected boolean _isCancelled = false;
    protected boolean _isDone = false;
    protected SystemOperationMonitor systemOperationMonitor = null;
    public static final String CLASSNAME = "CopyThread";

    public CopyThread(DataElement targetFolder, DataElement theElement, UniversalFileSystemMiner miner, boolean isWindows, DataElement status) {
        super(theElement.getDataStore());
        this.targetFolder = targetFolder;
        this.theElement = theElement;
        this.miner = miner;
        this.status = status;
        this.isWindows = isWindows;
    }

    protected File getFileFor(DataElement element) {
        File result = null;
        String type = element.getType();
        if (type.equals("universal.FilterObject")) {
            result = new File(element.getName());
        } else if (type.equals("universal.FileObject") || type.equals("universal.FolderObject") || type.equals("universal.ArchiveFileObject")) {
            StringBuffer buf = new StringBuffer(element.getAttribute(3));
            buf.append(File.separatorChar);
            buf.append(element.getName());
            result = new File(buf.toString());
        }
        return result;
    }

    protected String enQuote(String s) {
        if (this.isWindows) {
            return String.valueOf('\"') + s + '\"';
        }
        return PathUtility.enQuoteUnix((String)s);
    }

    protected void doCopyCommand(String source, String tgt, boolean folderCopy, DataElement status) {
        String command = null;
        if (this.isWindows) {
            if (folderCopy) {
                command = "xcopy " + source + " " + tgt + " /S /E /K /Q /H /I /Y";
            } else {
                String unquotedTgt = tgt.substring(1, tgt.length() - 1);
                File targetFile = new File(unquotedTgt);
                if (!targetFile.exists()) {
                    try {
                        targetFile.createNewFile();
                    }
                    catch (Exception e) {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, e.getMessage());
                        return;
                    }
                }
                command = "xcopy " + source + " " + tgt + " /Y /K /Q /H";
            }
        } else {
            command = folderCopy ? "cp  -Rp " + source + " " + tgt : "cp -p " + source + " " + tgt;
        }
        try {
            String theShell;
            Runtime runtime = Runtime.getRuntime();
            Process p = null;
            if (this.isWindows) {
                theShell = "cmd /C ";
                p = runtime.exec(String.valueOf(theShell) + command);
            } else {
                theShell = "sh";
                String[] args = new String[]{theShell, "-c", command};
                p = runtime.exec(args);
            }
            if (p != null) {
                p.waitFor();
                int result = p.exitValue();
                if (result != 0) {
                    InputStream errStream = p.getErrorStream();
                    StringBuffer errBuf = new StringBuffer();
                    byte[] bytes = null;
                    int numOfBytesRead = 0;
                    int available = errStream.available();
                    while (available > 0) {
                        bytes = new byte[available];
                        numOfBytesRead = errStream.read(bytes);
                        if (numOfBytesRead <= -1) break;
                        errBuf.append(new String(bytes, 0, numOfBytesRead));
                        available = errStream.available();
                    }
                    String err = errBuf.toString();
                    String newLine = System.getProperty("line.separator");
                    if (newLine != null && err.endsWith(newLine)) {
                        err = err.substring(0, err.length() - newLine.length());
                    }
                    if (err.length() > 0) {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, err);
                    } else {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, "unexpectedError");
                    }
                } else {
                    status.setAttribute(4, "success");
                }
            } else {
                status.setAttribute(4, "failed");
                status.setAttribute(3, "unexpectedError");
            }
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(CLASSNAME, "Exception is handleCopy", e, this._dataStore);
            status.setAttribute(4, "failed");
            status.setAttribute(3, e.getMessage());
        }
    }

    public void cancel() {
        this._isCancelled = true;
        if (this.systemOperationMonitor != null) {
            this.systemOperationMonitor.setCancelled(true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }
}

