/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAnnotationPlugin;

public class AntLauncherUtility {
    private static final int MAX_TARGET_APPEND_LENGTH = 30;
    public static final String ID_ANT_LAUNCH_CONFIGURATION_TYPE = "org.eclipse.ant.AntLaunchConfigurationType";
    public static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    public static final String ATTR_ANT_TARGETS = "org.eclipse.ui.externaltools.ATTR_ANT_TARGETS";
    public static final String REMOTE_ANT_PROCESS_FACTORY_ID = "org.eclipse.ant.ui.remoteAntProcessFactory";
    private URL url;
    private Properties properties;
    private Map templates;
    private boolean useLauncher = false;

    public AntLauncherUtility(URL templateUrl, IPath outputFolder, Properties properties, Map templates) {
        this.url = templateUrl;
        this.properties = properties;
        this.templates = templates;
    }

    public String getBuildFile() throws Exception {
        int c;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
        StringBuffer buildFile = new StringBuffer(512);
        do {
            if ((c = reader.read()) == -1) continue;
            buildFile.append((char)c);
        } while (c != -1);
        String build = buildFile.toString();
        for (String key : this.templates.keySet()) {
            build = build.replaceAll(key, (String)this.templates.get(key));
        }
        return build;
    }

    public IStatus[] launch(String target, IProgressMonitor monitor) throws Exception {
        String build = this.getBuildFile();
        if (build == null || build.length() < 1) {
            return new IStatus[]{new Status(4, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "AntBuildFileDoesNotExist", null)};
        }
        IPath file = XDocletAnnotationPlugin.getDefault().getStateLocation().append("tempAnt.xml");
        try {
            this.createNewFile(file.toFile(), build.getBytes());
        }
        catch (IOException iOException) {}
        this.runAnt(file, new String[]{target}, this.properties, monitor);
        return new IStatus[]{new Status(0, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "Finished", null)};
    }

    private void runAnt(IPath buildFile, String[] targets, Properties properties, IProgressMonitor monitor) throws Exception {
        IPath propfile = XDocletAnnotationPlugin.getDefault().getStateLocation().append("build.properties");
        File buildProp = propfile.toFile();
        if (buildProp.exists()) {
            buildProp.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(propfile.toFile());
        properties.store(fileOutputStream, "WTP BUILD FILE PROPERTIES- UPDATED:" + new Date());
        fileOutputStream.close();
        if (this.useLauncher) {
            this.runUsingLauncher(buildFile, targets, monitor);
        } else {
            AntRunner antRunner = new AntRunner();
            antRunner.setBuildFileLocation(buildFile.toString());
            antRunner.setExecutionTargets(targets);
            antRunner.run(monitor);
        }
    }

    private void runUsingLauncher(IPath buildFile, String[] targets, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration configuration = this.createDefaultLaunchConfiguration(buildFile, null, targets[0]);
        DebugUITools.buildAndLaunch((ILaunchConfiguration)configuration, (String)"run", (IProgressMonitor)monitor);
    }

    public ILaunchConfiguration createDefaultLaunchConfiguration(IPath filePath, IProject project, String targetAttribute) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_ANT_LAUNCH_CONFIGURATION_TYPE);
        String projectName = project != null ? project.getName() : null;
        String name = this.getNewLaunchConfigurationName(filePath, projectName, targetAttribute);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute(ATTR_LOCATION, filePath.toString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        workingCopy.setAttribute(ATTR_ANT_TARGETS, targetAttribute);
        CommonTab tab = new CommonTab();
        tab.setDefaults(workingCopy);
        tab.dispose();
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        IVMInstall vmInstall = this.getDefaultVMInstall((ILaunchConfiguration)workingCopy);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstall.getVMInstallType().getId());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner");
        workingCopy.setAttribute("process_factory_id", REMOTE_ANT_PROCESS_FACTORY_ID);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        return workingCopy;
    }

    private IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        IVMInstall defaultVMInstall;
        try {
            defaultVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return defaultVMInstall;
    }

    public String getNewLaunchConfigurationName(IPath filePath, String projectName, String targetAttribute) {
        StringBuffer buffer = new StringBuffer();
        if (projectName != null) {
            buffer.append(projectName);
            buffer.append(' ');
            buffer.append(filePath.lastSegment());
        } else {
            buffer.append(filePath.toOSString());
        }
        if (targetAttribute != null) {
            buffer.append(" [");
            if (targetAttribute.length() > 33) {
                buffer.append(targetAttribute.substring(0, 30));
                buffer.append("...");
            } else {
                buffer.append(targetAttribute);
            }
            buffer.append(']');
        }
        String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(buffer.toString());
        return name;
    }

    public boolean createNewFile(File f, byte[] content) throws IOException {
        if (f != null) {
            if (f.exists()) {
                f.delete();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(content);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            return true;
        }
        return false;
    }

    public void setUseLauncher(boolean useLauncher) {
        this.useLauncher = useLauncher;
    }
}

