/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.impl.HelperProvider;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.helper.ListWrapper;

public class XPathEngine {
    private static final int SET = 1;
    private static final int ISSET = 2;
    private static final int UNSET = 3;
    protected static XPathEngine defaultXPathEngine;

    private XPathEngine() {
    }

    public static XPathEngine getInstance() {
        if (defaultXPathEngine == null) {
            defaultXPathEngine = new XPathEngine();
        }
        return defaultXPathEngine;
    }

    public boolean isSet(String path, DataObject caller) {
        try {
            return this.processPath(path, null, caller, false, 2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unset(String path, DataObject caller) {
        this.processPath(path, null, caller, false, 3);
    }

    public void set(String path, Object value, DataObject caller, boolean convertValue) {
        this.processPath(path, value, caller, convertValue, 1);
    }

    public Object get(String path, DataObject caller) {
        if (path == null || path.equals("")) {
            return null;
        }
        if (path.equals("..")) {
            return caller.getContainer();
        }
        if (path.equals("/")) {
            return caller.getRootObject();
        }
        int index = (path = this.getLocalName(path)).indexOf(47);
        if (index > -1) {
            if (index == path.length() - 1) {
                return this.getValueForFragment(path.substring(0, index), caller);
            }
            Object value = this.getValueForFragment(path.substring(0, index), caller);
            DataObject currentDataObject = (DataObject)value;
            return this.get(path.substring(index + 1, path.length()), currentDataObject);
        }
        return this.getValueForFragment(path, caller);
    }

    private boolean processPath(String path, Object value, DataObject caller, boolean convertValue, int _case) {
        int lastSlashIndex = (path = this.getLocalName(path)).lastIndexOf(47);
        if (-1 < lastSlashIndex) {
            String frag = path.substring(lastSlashIndex + 1);
            return this.setIsSetUnSet(frag, path, caller, value, lastSlashIndex, convertValue, _case);
        }
        String frag = path;
        return this.setIsSetUnSet(frag, path, caller, value, lastSlashIndex, convertValue, _case);
    }

    private boolean setIsSetUnSet(String frag, String path, DataObject caller, Object value, int lastSlashIndex, boolean convertValue, int _case) {
        DataObject lastDataObject;
        int indexOfDot = frag.lastIndexOf(46);
        int indexOfOpenBracket = frag.lastIndexOf(91);
        int indexOfCloseBracket = frag.lastIndexOf(93);
        int numInLastProperty = this.getNumberInFrag(frag, indexOfDot, indexOfOpenBracket, indexOfCloseBracket);
        String lastPropertyName = this.getPropertyNameInFrag(frag, numInLastProperty, indexOfDot, indexOfOpenBracket);
        if (-1 < lastSlashIndex) {
            Object lastObject = this.get(path.substring(0, lastSlashIndex), caller);
            if (lastObject == null || lastObject instanceof ListWrapper) {
                throw SDOException.cannotPerformOperationOnProperty((String)lastPropertyName, (String)path);
            }
            lastDataObject = (SDODataObject)lastObject;
        } else {
            lastDataObject = caller;
        }
        Property lastProperty = lastDataObject.getInstanceProperty(lastPropertyName);
        switch (_case) {
            case 1: {
                if (lastProperty == null) {
                    lastProperty = ((SDODataObject)lastDataObject).defineOpenContentProperty(lastPropertyName, value);
                }
                if (lastProperty != null) {
                    this.set(lastProperty, lastDataObject, numInLastProperty, value, convertValue);
                }
                return false;
            }
            case 2: {
                if (lastProperty == null) {
                    return false;
                }
                return this.isSet(lastProperty, lastDataObject);
            }
            case 3: {
                if (lastProperty == null) {
                    return false;
                }
                this.unSet(lastProperty, lastDataObject, numInLastProperty);
                return false;
            }
        }
        return false;
    }

    private boolean isSet(Property lastProperty, DataObject lastDataObject) {
        return lastDataObject.isSet(lastProperty);
    }

    private void unSet(Property lastProperty, DataObject lastDataObject, int numInLastProperty) {
        if (numInLastProperty == -1) {
            lastDataObject.unset(lastProperty);
        } else {
            List objects = lastDataObject.getList(lastProperty);
            if (numInLastProperty <= objects.size()) {
                objects.remove(numInLastProperty);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Property lastProperty, DataObject lastDataObject, int numInLastProperty, Object value, boolean convertValue) {
        if (numInLastProperty == -1) {
            if (lastDataObject == null) throw new IllegalArgumentException("lastDataObject is null");
            if (convertValue) {
                value = DataHelper.INSTANCE.convert(lastProperty, value);
            }
            lastDataObject.set(lastProperty, value);
            return;
        } else {
            Sequence seq;
            List objects = lastDataObject.getList(lastProperty);
            if (convertValue) {
                value = DataHelper.INSTANCE.convert(lastProperty.getType(), value);
            }
            if ((seq = lastDataObject.getSequence()) != null) {
                seq.setValue(numInLastProperty, value);
                return;
            } else {
                objects.set(numInLastProperty, value);
            }
        }
    }

    private String getLocalName(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index > -1) {
            String local = qualifiedName.substring(index + 1, qualifiedName.length());
            return local;
        }
        return qualifiedName;
    }

    private Object getValueForFragment(String frag, DataObject caller) {
        int indexOfDot = frag.lastIndexOf(46);
        int indexOfOpenBracket = frag.lastIndexOf(91);
        int indexOfCloseBracket = frag.lastIndexOf(93);
        int position = this.getNumberInFrag(frag, indexOfDot, indexOfOpenBracket, indexOfCloseBracket);
        String propertyName = this.getPropertyNameInFrag(frag, position, indexOfDot, indexOfOpenBracket);
        int equalSignIndex = this.isQueryPath(frag, indexOfOpenBracket, indexOfCloseBracket);
        if (equalSignIndex == -1) {
            return this.getObjectByFragment(propertyName, position, caller);
        }
        return this.getDataObjectFromQuery(frag, indexOfOpenBracket, indexOfCloseBracket, equalSignIndex, caller, propertyName);
    }

    private String getPropertyNameInFrag(String frag, int position, int indexOfDot, int indexOfOpenBracket) {
        int startIndex = 0;
        if (frag.indexOf(64) != -1) {
            ++startIndex;
        }
        if (indexOfOpenBracket != -1) {
            return frag.substring(startIndex, indexOfOpenBracket);
        }
        if (indexOfDot != -1 && position != -1) {
            return frag.substring(startIndex, indexOfDot);
        }
        return frag.substring(startIndex);
    }

    private int getNumberInFrag(String frag, int indexOfDot, int indexOfOpenBracket, int indexOfCloseBracket) {
        if (indexOfOpenBracket != -1 && indexOfCloseBracket != -1 && indexOfOpenBracket < indexOfCloseBracket) {
            return this.acquireNumberInBrackets(frag, indexOfOpenBracket, indexOfCloseBracket);
        }
        if (indexOfDot != -1) {
            return this.acquireNumberAtDot(frag, indexOfDot);
        }
        return -1;
    }

    private int isQueryPath(String frag, int openBracketIndex, int closeBracketIndex) {
        if (openBracketIndex != -1 && closeBracketIndex != -1 && openBracketIndex < closeBracketIndex) {
            return frag.substring(openBracketIndex, closeBracketIndex).indexOf(61);
        }
        return -1;
    }

    private DataObject getDataObjectFromQuery(String frag, int openBracketIndex, int closeBracketIndex, int equalsignIndex, DataObject caller, String callerProperty) {
        try {
            String propertyNameOfQryDataObject = frag.substring(openBracketIndex + 1, equalsignIndex + openBracketIndex).trim();
            List objects = caller.getList(caller.getInstanceProperty(callerProperty));
            String query = frag.substring(equalsignIndex + openBracketIndex + 1, closeBracketIndex);
            String value = null;
            int firstQuoteIndex = query.indexOf(39);
            int lastQuoteIndex = query.lastIndexOf(39);
            if (firstQuoteIndex == -1 && lastQuoteIndex == -1) {
                firstQuoteIndex = query.indexOf("\"");
                lastQuoteIndex = query.lastIndexOf("\"");
            }
            value = firstQuoteIndex != -1 && lastQuoteIndex != -1 && firstQuoteIndex < lastQuoteIndex ? query.substring(firstQuoteIndex + 1, lastQuoteIndex) : query.trim();
            Iterator iterObjects = objects.iterator();
            Object queryValue = value;
            Object actualValue2 = null;
            while (iterObjects.hasNext()) {
                DataObject cur = (DataObject)iterObjects.next();
                Property p = cur.getInstanceProperty(propertyNameOfQryDataObject);
                if (p == null) continue;
                try {
                    queryValue = XMLConversionManager.getDefaultXMLManager().convertObject(queryValue, p.getType().getInstanceClass());
                }
                catch (ConversionException e) {
                    // empty catch block
                }
                if (!p.isMany()) {
                    actualValue2 = cur.get(p);
                    if (!actualValue2.equals(queryValue)) continue;
                    return cur;
                }
                List values = cur.getList(p);
                for (Object actualValue2 : values) {
                    if (!actualValue2.equals(queryValue)) continue;
                    return cur;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Object getObjectByFragment(String propertyName, int position, DataObject caller) {
        Property prop = caller.getInstanceProperty(propertyName);
        if (prop == null) {
            return null;
        }
        if (prop.isMany() && position > -1) {
            return caller.getList(prop).get(position);
        }
        return caller.get(prop);
    }

    private int acquireNumberInBrackets(String frag, int openBracketIndex, int closeBracketIndex) {
        String number = frag.substring(openBracketIndex + 1, closeBracketIndex);
        if (number.matches("[1-9][0-9]*")) {
            return Integer.parseInt(number) - 1;
        }
        return -1;
    }

    private int acquireNumberAtDot(String frag, int dotIndex) {
        int value = -1;
        String position = frag.substring(dotIndex + 1);
        if (position.matches("[0-9]+")) {
            value = Integer.parseInt(position);
        }
        return value;
    }

    public Object convertObjectToValueByPath(String path, Class cls, DataObject caller) throws ClassCastException {
        if (null == path || path == "") {
            throw new ClassCastException("Attempting null value conversion.");
        }
        try {
            Property lastProperty;
            SDODataObject lastDataObject;
            int indexOfDot;
            String frag;
            int lastSlashIndex = path.lastIndexOf(47);
            int numInLastProperty = -1;
            if (-1 < lastSlashIndex) {
                frag = path.substring(lastSlashIndex + 1);
                indexOfDot = frag.lastIndexOf(46);
                int indexOfOpenBracket = frag.lastIndexOf(91);
                int indexOfCloseBracket = frag.lastIndexOf(93);
                numInLastProperty = this.getNumberInFrag(frag, indexOfDot, indexOfOpenBracket, indexOfCloseBracket);
                String lastPropertyName = this.getPropertyNameInFrag(frag, numInLastProperty, indexOfDot, indexOfOpenBracket);
                lastDataObject = (SDODataObject)caller.getDataObject(path.substring(0, lastSlashIndex));
                if (lastDataObject == null) {
                    return null;
                }
                lastProperty = lastDataObject.getInstanceProperty(lastPropertyName);
            } else {
                frag = path;
                indexOfDot = frag.lastIndexOf(46);
                int indexOfOpenBracket = frag.lastIndexOf(91);
                int indexOfCloseBracket = frag.lastIndexOf(93);
                numInLastProperty = this.getNumberInFrag(frag, indexOfDot, indexOfOpenBracket, indexOfCloseBracket);
                String lastPropertyName = this.getPropertyNameInFrag(frag, numInLastProperty, indexOfDot, indexOfOpenBracket);
                lastDataObject = (SDODataObject)caller;
                if (lastDataObject == null) {
                    return null;
                }
                lastProperty = caller.getInstanceProperty(lastPropertyName);
            }
            if (lastProperty != null && cls == Date.class && lastProperty.getType().equals(SDOConstants.SDO_STRING)) {
                DataHelper dHelper = HelperProvider.getDefaultContext().getDataHelper();
                String dateString = numInLastProperty == -1 ? (String)lastDataObject.get(lastProperty) : (String)lastDataObject.getList(lastProperty).get(numInLastProperty);
                return dHelper.toDate(dateString);
            }
            return lastDataObject.convertObjectToValue(lastProperty, numInLastProperty, cls);
        }
        catch (IllegalArgumentException e) {
            throw new ClassCastException("Conversion is not supported.");
        }
    }
}

