/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;

public class FileChecksum3 {
    static final int BUFFER_SIZE = 65536;
    static final String COPYRIGHT_NOTICE = "Copyright (c) 2008 by Keith Fenske.  Released under GNU Public License.";
    static final int DEFAULT_HEIGHT = -1;
    static final int DEFAULT_LEFT = 50;
    static final int DEFAULT_TOP = 50;
    static final int DEFAULT_WIDTH = -1;
    static final int EXIT_FAILURE = -1;
    static final int EXIT_SUCCESS = 1;
    static final int EXIT_UNKNOWN = 0;
    static final String HELLO_TEXT = "Open a file to compute checksums, or compare against known checksum.";
    static final int MIN_FRAME = 200;
    static final String PROGRAM_TITLE = "Compute CRC32, MD5, and SHA1 File Checksums - by: Keith Fenske";
    static final String SYSTEM_FONT = "Dialog";
    static final int TIMER_DELAY = 400;
    static final String WAIT_TEXT = "Calculating checksums.  Please wait or click the Cancel button.";
    static JButton cancelButton;
    static boolean cancelFlag;
    static JLabel compareLabel;
    static JTextField compareText;
    static boolean consoleFlag;
    static JButton copyCrc32Button;
    static JButton copyMd5Button;
    static JButton copySha1Button;
    static JLabel crc32Label;
    static String crc32String;
    static JTextField crc32Text;
    static JButton exitButton;
    static JFileChooser fileChooser;
    static JButton filenameButton;
    static JTextField filenameText;
    static JLabel filesizeLabel;
    static String filesizeString;
    static JTextField filesizeText;
    static NumberFormat formatComma;
    static NumberFormat formatPointOne;
    static JLabel legalNotice;
    static JFrame mainFrame;
    static JLabel md5Label;
    static String md5String;
    static JTextField md5Text;
    static boolean mswinFlag;
    static File openFileObject;
    static Thread openFileThread;
    static JButton pasteCompareButton;
    static JProgressBar progressBar;
    static Timer progressTimer;
    static JLabel sha1Label;
    static String sha1String;
    static JTextField sha1Text;
    static long sizeDone;
    static String sizeSuffix;
    static long sizeTotal;
    static AudioClip soundsBad;
    static JButton startButton;
    static JLabel statusText;

    public static void main(String[] stringArray) {
        Object object;
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        Font font = null;
        Font font2 = null;
        Font font3 = null;
        Font font4 = null;
        cancelFlag = false;
        consoleFlag = false;
        crc32String = "";
        int n = 1;
        filesizeString = "";
        boolean bl = false;
        md5String = "";
        mswinFlag = System.getProperty("os.name").startsWith("Windows");
        sha1String = "";
        int n2 = -1;
        int n3 = 50;
        int n4 = 50;
        int n5 = -1;
        formatComma = NumberFormat.getInstance();
        formatComma.setGroupingUsed(true);
        formatPointOne = NumberFormat.getInstance();
        formatPointOne.setGroupingUsed(true);
        formatPointOne.setMaximumFractionDigits(1);
        formatPointOne.setMinimumFractionDigits(1);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase();
            if (string.length() == 0) continue;
            if (string.equals("?") || string.equals("-?") || string.equals("/?") || string.equals("-h") || mswinFlag && string.equals("/h") || string.equals("-help") || mswinFlag && string.equals("/help")) {
                FileChecksum3.showHelp();
                System.exit(0);
                continue;
            }
            if (string.startsWith("-u") || mswinFlag && string.startsWith("/u")) {
                int n6 = -1;
                try {
                    n6 = Integer.parseInt(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = -1;
                }
                if (n6 < 10 || n6 > 99) {
                    System.err.println("Dialog font size must be from 10 to 99: " + stringArray[i]);
                    FileChecksum3.showHelp();
                    System.exit(-1);
                }
                color4 = Color.BLACK;
                font4 = new Font(SYSTEM_FONT, 0, n6);
                color3 = new Color(102, 102, 102);
                font3 = font4;
                color2 = new Color(51, 51, 51);
                font2 = new Font(SYSTEM_FONT, 1, n6);
                color = color4;
                font = font4;
                continue;
            }
            if (string.startsWith("-w") || mswinFlag && string.startsWith("/w")) {
                Pattern pattern = Pattern.compile("\\s*\\(\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*\\)\\s*");
                object = pattern.matcher(string.substring(2));
                if (((Matcher)object).matches()) {
                    n3 = Integer.parseInt(((Matcher)object).group(1));
                    n4 = Integer.parseInt(((Matcher)object).group(2));
                    n5 = Integer.parseInt(((Matcher)object).group(3));
                    n2 = Integer.parseInt(((Matcher)object).group(4));
                    continue;
                }
                System.err.println("Invalid window position or size: " + stringArray[i]);
                FileChecksum3.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.equals("-x") || mswinFlag && string.equals("/x")) {
                bl = true;
                continue;
            }
            if (string.startsWith("-") || mswinFlag && string.startsWith("/")) {
                System.err.println("Option not recognized: " + stringArray[i]);
                FileChecksum3.showHelp();
                System.exit(-1);
                continue;
            }
            if (!consoleFlag) {
                consoleFlag = true;
                File file = new File(stringArray[i]);
                if (!file.isFile()) {
                    System.err.println("File not found: " + stringArray[i]);
                    FileChecksum3.showHelp();
                    System.exit(-1);
                }
                System.out.println("     file name: " + file.getName());
                System.out.println("    file bytes: " + formatComma.format(file.length()));
                FileChecksum3.calcFileChecksum(file);
                if (cancelFlag) {
                    System.exit(-1);
                }
                System.out.println("CRC32 checksum: " + crc32String);
                System.out.println("  MD5 checksum: " + md5String);
                System.out.println(" SHA1 checksum: " + sha1String);
                continue;
            }
            if (FileChecksum3.compareChecksum(FileChecksum3.cleanChecksum(stringArray[i])) == 1) continue;
            n = -1;
        }
        if (consoleFlag) {
            System.exit(n);
        }
        FileChecksum3User fileChecksum3User = new FileChecksum3User();
        fileChooser = new JFileChooser();
        progressTimer = new Timer(400, fileChecksum3User);
        Insets insets = new Insets(3, 5, 3, 5);
        try {
            soundsBad = Applet.newAudioClip(new URL("file:FileChecksum3.au"));
        }
        catch (MalformedURLException malformedURLException) {
            soundsBad = null;
        }
        int n7 = font4 != null ? font4.getSize() : 12;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        statusText = new JLabel(HELLO_TEXT, 0);
        if (font2 != null) {
            statusText.setFont(font2);
        }
        if (color2 != null) {
            statusText.setForeground(color2);
        }
        jPanel.add((Component)statusText, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(1.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        filenameButton = new JButton("File Name...");
        filenameButton.addActionListener(fileChecksum3User);
        filenameButton.setEnabled(true);
        if (font4 != null) {
            filenameButton.setFont(font4);
        }
        if (color4 != null) {
            filenameButton.setForeground(color4);
        }
        filenameButton.setMnemonic(70);
        filenameButton.setToolTipText("Find a file for checksumming.");
        jPanel.add((Component)filenameButton, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        filenameText = new JTextField("", 20);
        filenameText.addActionListener(fileChecksum3User);
        filenameText.setEditable(true);
        filenameText.setEnabled(true);
        if (font != null) {
            filenameText.setFont(font);
        }
        if (color != null) {
            filenameText.setForeground(color);
        }
        filenameText.setMargin(insets);
        jPanel.add((Component)filenameText, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        startButton = new JButton("Start");
        startButton.addActionListener(fileChecksum3User);
        startButton.setEnabled(true);
        if (font4 != null) {
            startButton.setFont(font4);
        }
        if (color4 != null) {
            startButton.setForeground(color4);
        }
        startButton.setMnemonic(83);
        startButton.setToolTipText("Open named file for checksumming.");
        jPanel.add((Component)startButton, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(2.0 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        filesizeLabel = new JLabel("File size (bytes):");
        if (font3 != null) {
            filesizeLabel.setFont(font3);
        }
        if (color3 != null) {
            filesizeLabel.setForeground(color3);
        }
        jPanel.add((Component)filesizeLabel, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        object = new JPanel(new FlowLayout(0, 0, 0));
        filesizeText = new JTextField("", 11);
        filesizeText.setEditable(false);
        if (font != null) {
            filesizeText.setFont(font);
        }
        if (color != null) {
            filesizeText.setForeground(color);
        }
        filesizeText.setMargin(insets);
        filesizeText.setText(filesizeString);
        ((Container)object).add(filesizeText);
        ((Container)object).add(Box.createHorizontalStrut((int)(2.0 * (double)n7)));
        crc32Label = new JLabel("CRC32:");
        if (font3 != null) {
            crc32Label.setFont(font3);
        }
        if (color3 != null) {
            crc32Label.setForeground(color3);
        }
        ((Container)object).add(crc32Label);
        ((Container)object).add(Box.createHorizontalStrut((int)(0.5 * (double)n7)));
        crc32Text = new JTextField("", 7);
        crc32Text.setEditable(false);
        if (font != null) {
            crc32Text.setFont(font);
        }
        if (color != null) {
            crc32Text.setForeground(color);
        }
        crc32Text.setMargin(insets);
        crc32Text.setText(crc32String);
        ((Container)object).add(crc32Text);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)object, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        copyCrc32Button = new JButton("Copy CRC32");
        copyCrc32Button.addActionListener(fileChecksum3User);
        if (font4 != null) {
            copyCrc32Button.setFont(font4);
        }
        if (color4 != null) {
            copyCrc32Button.setForeground(color4);
        }
        copyCrc32Button.setMnemonic(82);
        copyCrc32Button.setToolTipText("Copy CRC32 checksum to clipboard.");
        jPanel.add((Component)copyCrc32Button, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(1.0 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        md5Label = new JLabel("MD5 checksum:");
        if (font3 != null) {
            md5Label.setFont(font3);
        }
        if (color3 != null) {
            md5Label.setForeground(color3);
        }
        jPanel.add((Component)md5Label, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        md5Text = new JTextField("", 24);
        md5Text.setEditable(false);
        if (font != null) {
            md5Text.setFont(font);
        }
        if (color != null) {
            md5Text.setForeground(color);
        }
        md5Text.setMargin(insets);
        md5Text.setText(md5String);
        jPanel.add((Component)md5Text, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        copyMd5Button = new JButton("Copy MD5");
        copyMd5Button.addActionListener(fileChecksum3User);
        if (font4 != null) {
            copyMd5Button.setFont(font4);
        }
        if (color4 != null) {
            copyMd5Button.setForeground(color4);
        }
        copyMd5Button.setMnemonic(77);
        copyMd5Button.setToolTipText("Copy MD5 checksum to clipboard.");
        jPanel.add((Component)copyMd5Button, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(1.0 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        sha1Label = new JLabel("SHA1 checksum:");
        if (font3 != null) {
            sha1Label.setFont(font3);
        }
        if (color3 != null) {
            sha1Label.setForeground(color3);
        }
        jPanel.add((Component)sha1Label, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        sha1Text = new JTextField("", 29);
        sha1Text.setEditable(false);
        if (font != null) {
            sha1Text.setFont(font);
        }
        if (color != null) {
            sha1Text.setForeground(color);
        }
        sha1Text.setMargin(insets);
        sha1Text.setText(sha1String);
        jPanel.add((Component)sha1Text, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        copySha1Button = new JButton("Copy SHA1");
        copySha1Button.addActionListener(fileChecksum3User);
        if (font4 != null) {
            copySha1Button.setFont(font4);
        }
        if (color4 != null) {
            copySha1Button.setForeground(color4);
        }
        copySha1Button.setMnemonic(72);
        copySha1Button.setToolTipText("Copy SHA1 checksum to clipboard.");
        jPanel.add((Component)copySha1Button, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(1.0 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        compareLabel = new JLabel("Compare against:");
        if (font3 != null) {
            compareLabel.setFont(font3);
        }
        if (color3 != null) {
            compareLabel.setForeground(color3);
        }
        jPanel.add((Component)compareLabel, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        compareText = new JTextField("", 20);
        compareText.addActionListener(fileChecksum3User);
        compareText.setEditable(true);
        if (font != null) {
            compareText.setFont(font);
        }
        if (color != null) {
            compareText.setForeground(color);
        }
        compareText.setMargin(insets);
        jPanel.add((Component)compareText, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        pasteCompareButton = new JButton("Paste");
        pasteCompareButton.addActionListener(fileChecksum3User);
        if (font4 != null) {
            pasteCompareButton.setFont(font4);
        }
        if (color4 != null) {
            pasteCompareButton.setForeground(color4);
        }
        pasteCompareButton.setMnemonic(80);
        pasteCompareButton.setToolTipText("Paste checksum for comparison.");
        jPanel.add((Component)pasteCompareButton, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(2.0 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(fileChecksum3User);
        cancelButton.setEnabled(false);
        if (font4 != null) {
            cancelButton.setFont(font4);
        }
        if (color4 != null) {
            cancelButton.setForeground(color4);
        }
        cancelButton.setMnemonic(67);
        cancelButton.setToolTipText("Stop checking/opening files.");
        jPanel.add((Component)cancelButton, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        progressBar = new JProgressBar(0, 100);
        if (font != null) {
            progressBar.setFont(font);
        }
        progressBar.setString("");
        progressBar.setStringPainted(true);
        progressBar.setValue(0);
        jPanel.add((Component)progressBar, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)(0.8 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        exitButton = new JButton("Exit");
        exitButton.addActionListener(fileChecksum3User);
        if (font4 != null) {
            exitButton.setFont(font4);
        }
        if (color4 != null) {
            exitButton.setForeground(color4);
        }
        exitButton.setMnemonic(88);
        exitButton.setToolTipText("Close this program.");
        jPanel.add((Component)exitButton, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut((int)(1.5 * (double)n7)), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        legalNotice = new JLabel(COPYRIGHT_NOTICE, 0);
        if (font3 != null) {
            legalNotice.setFont(font3);
        }
        if (color3 != null) {
            legalNotice.setForeground(color3);
        }
        jPanel.add((Component)legalNotice, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 30, 0));
        jPanel2.add(jPanel);
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        box.add(Box.createVerticalStrut(30));
        box.add(jPanel2);
        box.add(Box.createVerticalStrut(30));
        mainFrame = new JFrame(PROGRAM_TITLE);
        Container container = mainFrame.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)box, "Center");
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocation(n3, n4);
        if (n2 < 200 || n5 < 200) {
            mainFrame.pack();
        } else {
            mainFrame.setSize(n5, n2);
        }
        if (bl) {
            mainFrame.setExtendedState(6);
        }
        mainFrame.validate();
        mainFrame.setVisible(true);
    }

    static void calcFileChecksum(File file) {
        FileChecksum3.clearChecksums();
        sizeDone = 0L;
        sizeSuffix = null;
        sizeTotal = file.length();
        filesizeString = formatComma.format(sizeTotal);
        if (!consoleFlag) {
            filesizeText.setText(filesizeString);
            progressTimer.start();
        }
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[65536];
            CRC32 cRC32 = new CRC32();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            MessageDigest messageDigest2 = MessageDigest.getInstance("SHA1");
            while ((n = fileInputStream.read(byArray, 0, 65536)) > 0 && !cancelFlag) {
                cRC32.update(byArray, 0, n);
                messageDigest.update(byArray, 0, n);
                messageDigest2.update(byArray, 0, n);
                sizeDone += (long)n;
            }
            fileInputStream.close();
            if (!cancelFlag) {
                String string = "00000000" + Long.toHexString(cRC32.getValue());
                crc32String = string.substring(string.length() - 8);
                md5String = FileChecksum3.formatHexBytes(messageDigest.digest());
                sha1String = FileChecksum3.formatHexBytes(messageDigest2.digest());
                if (!consoleFlag) {
                    progressTimer.stop();
                    progressBar.setString("100 %");
                    progressBar.setValue(100);
                }
            }
        }
        catch (IOException iOException) {
            if (consoleFlag) {
                System.err.println("Can't read from file: " + iOException.getMessage());
            } else {
                statusText.setText("Unable to open or read from selected file.");
            }
            cancelFlag = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (consoleFlag) {
                System.err.println("Bad checksum algorithm: " + noSuchAlgorithmException.getMessage());
            } else {
                statusText.setText("Internal error: unsupported checksum algorithm.");
            }
            cancelFlag = true;
        }
        if (!consoleFlag) {
            crc32Text.setText(crc32String);
            md5Text.setText(md5String);
            progressTimer.stop();
            sha1Text.setText(sha1String);
        }
    }

    static String cleanChecksum(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == ',' || c == '.' || c == ':') continue;
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                stringBuffer.append((char)(c - 65 + 97));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static void clearChecksums() {
        crc32String = "";
        filesizeString = "";
        md5String = "";
        sha1String = "";
        if (!consoleFlag) {
            crc32Text.setText(crc32String);
            filesizeText.setText(filesizeString);
            md5Text.setText(md5String);
            progressBar.setString("");
            progressBar.setValue(0);
            sha1Text.setText(sha1String);
        }
    }

    static int compareChecksum(String string) {
        int n = 0;
        if (string.length() > 0 && crc32String.length() > 0) {
            if (string.equals(crc32String)) {
                n = 1;
                if (consoleFlag) {
                    System.out.println("Successfully matched the CRC32 checksum.");
                } else {
                    statusText.setText("Successfully matched the CRC32 checksum.");
                }
            } else if (string.equals(md5String)) {
                n = 1;
                if (consoleFlag) {
                    System.out.println("Successfully matched the MD5 checksum.");
                } else {
                    statusText.setText("Successfully matched the MD5 checksum.");
                }
            } else if (string.equals(sha1String)) {
                n = 1;
                if (consoleFlag) {
                    System.out.println("Successfully matched the SHA1 checksum.");
                } else {
                    statusText.setText("Successfully matched the SHA1 checksum.");
                }
            } else if (!consoleFlag && !startButton.isEnabled()) {
                statusText.setText(WAIT_TEXT);
            } else {
                n = -1;
                if (consoleFlag) {
                    System.out.println("Supplied checksum <" + string + "> does not match calculated checksums.");
                } else {
                    statusText.setText("Supplied checksum does not match calculated checksums.");
                    if (soundsBad != null) {
                        soundsBad.play();
                    }
                }
            }
        } else if (!consoleFlag) {
            if (startButton.isEnabled()) {
                statusText.setText(HELLO_TEXT);
            } else {
                statusText.setText(WAIT_TEXT);
            }
        }
        return n;
    }

    static void doCancelButton() {
        cancelFlag = true;
        statusText.setText("Checksum calculation cancelled by user.");
    }

    static void doFilenameButton() {
        fileChooser.resetChoosableFileFilters();
        fileChooser.setDialogTitle("Browse or Open File...");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showOpenDialog(mainFrame) == 0) {
            File file = fileChooser.getSelectedFile();
            filenameText.setText(file.getPath());
            FileChecksum3.openFile(file);
        }
    }

    static void doFilenameEnter() {
        String string = filenameText.getText().trim();
        if (string.length() == 0) {
            FileChecksum3.clearChecksums();
            filenameText.setText("");
            statusText.setText(HELLO_TEXT);
        } else {
            filenameText.setText(string);
            FileChecksum3.openFile(new File(string));
        }
    }

    static void doStartButton() {
        FileChecksum3.doFilenameEnter();
    }

    static void doTimer() {
        if (sizeTotal > 0L) {
            int n = (int)((double)sizeDone * 100.0 / (double)sizeTotal);
            progressBar.setValue(n);
            if (sizeTotal > 99999999L) {
                if (sizeSuffix == null) {
                    sizeSuffix = " of " + FileChecksum3.formatMegabytes(sizeTotal) + " MB";
                }
                progressBar.setString(FileChecksum3.formatMegabytes(sizeDone) + sizeSuffix);
            } else if (sizeTotal > 999999L) {
                progressBar.setString(n + " %");
            }
        }
    }

    static String formatHexBytes(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(cArray[by >> 4 & 0xF]);
            stringBuffer.append(cArray[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String formatMegabytes(long l) {
        return formatPointOne.format((double)l / 1048576.0);
    }

    static void openFile(File file) {
        openFileObject = file;
        cancelButton.setEnabled(true);
        cancelFlag = false;
        filenameButton.setEnabled(false);
        filenameText.setEnabled(false);
        startButton.setEnabled(false);
        statusText.setText(WAIT_TEXT);
        openFileThread = new Thread((Runnable)new FileChecksum3User(), "openFileRunner");
        openFileThread.setPriority(1);
        openFileThread.start();
    }

    static void openFileRunner() {
        FileChecksum3.calcFileChecksum(openFileObject);
        cancelButton.setEnabled(false);
        filenameButton.setEnabled(true);
        filenameText.setEnabled(true);
        startButton.setEnabled(true);
        if (!cancelFlag) {
            FileChecksum3.compareChecksum(compareText.getText());
        }
    }

    static void showHelp() {
        System.err.println();
        System.err.println(PROGRAM_TITLE);
        System.err.println();
        System.err.println("To run as a console application, first parameter must be a file name.  Second");
        System.err.println("and following parameters are optional checksums to be tested against calculated");
        System.err.println("checksums for the given file.  Output may be redirected with the \">\" operator.");
        System.err.println();
        System.err.println("    java  FileChecksum3  filename  [checksums]");
        System.err.println();
        System.err.println("To run as a graphical application, don't put a file name on the command line:");
        System.err.println();
        System.err.println("    java  FileChecksum3  [options]");
        System.err.println();
        System.err.println("Options:");
        System.err.println("  -? or -help = show summary of command-line syntax");
        System.err.println("  -u# = font size for buttons, dialogs, etc; default is local system;");
        System.err.println("      example: -u16");
        System.err.println("  -w(#,#,#,#) = normal window position: left, top, width, height;");
        System.err.println("      example: -w(50,50,700,500)");
        System.err.println("  -x = maximize application window; default is normal window");
        System.err.println();
        System.err.println(COPYRIGHT_NOTICE);
    }

    static void userButton(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == cancelButton) {
            FileChecksum3.doCancelButton();
        } else if (object == compareText) {
            compareText.setText(FileChecksum3.cleanChecksum(compareText.getText()));
            FileChecksum3.compareChecksum(compareText.getText());
        } else if (object == copyCrc32Button) {
            crc32Text.selectAll();
            crc32Text.copy();
        } else if (object == copyMd5Button) {
            md5Text.selectAll();
            md5Text.copy();
        } else if (object == copySha1Button) {
            sha1Text.selectAll();
            sha1Text.copy();
        } else if (object == exitButton) {
            System.exit(0);
        } else if (object == filenameButton) {
            FileChecksum3.doFilenameButton();
        } else if (object == filenameText) {
            FileChecksum3.doFilenameEnter();
        } else if (object == pasteCompareButton) {
            compareText.setText("");
            compareText.paste();
            compareText.setText(FileChecksum3.cleanChecksum(compareText.getText()));
            FileChecksum3.compareChecksum(compareText.getText());
        } else if (object == progressTimer) {
            FileChecksum3.doTimer();
        } else if (object == startButton) {
            FileChecksum3.doStartButton();
        } else {
            System.err.println("Error in userButton(): unknown ActionEvent: " + actionEvent);
        }
    }
}

