/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CharMap4J14Grid
extends JPanel
implements ChangeListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final Color GRID_COLOR = Color.LIGHT_GRAY;
    static final int GRID_WIDTH = 2;
    static final int MOUSE_DRIFT = 10;
    static final int NO_MOUSE = -1;
    static final Color PANEL_COLOR = Color.WHITE;
    static final int PANEL_MARGIN = 5;
    static final Color TEXT_COLOR = Color.BLACK;
    static final int TEXT_MARGIN = 4;
    int clickIndex = -1;
    int clickStartX = -1;
    int clickStartY = -1;
    int cornerIndex = 0;
    FontMetrics fontData = null;
    int horizStep = 100;
    int hoverIndex = -1;
    int lineAscent = 100;
    int lineHeight = 100;
    int maxWidth = 100;
    int panelColumns = 10;
    int panelCount = -1;
    Font panelFont = null;
    int panelHeight = -1;
    int panelWidth = -1;
    int panelRows = 10;
    int vertiStep = 100;
    int[] cellChar;
    int cellCount = 0;
    int[] cellGlyph;
    int[] charChar;
    int charCount = 0;
    int[] charGlyph;
    int[] glyphChar;
    int glyphCount = 0;
    int[] glyphGlyph;

    public CharMap4J14Grid() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    void clear() {
        this.panelFont = null;
        this.repaint();
    }

    int convertMouse(MouseEvent mouseEvent) {
        if (this.panelFont == null) {
            return -1;
        }
        int n = mouseEvent.getX() - 2 - 5;
        int n2 = n / this.horizStep;
        int n3 = n % this.horizStep;
        if (n2 >= this.panelColumns || n3 < 4 || n3 > this.horizStep - 2 - 4) {
            return -1;
        }
        int n4 = mouseEvent.getY() - 2 - 5;
        int n5 = n4 / this.vertiStep;
        int n6 = n4 % this.vertiStep;
        if (n6 < 4 || n6 > this.vertiStep - 2 - 4) {
            return -1;
        }
        int n7 = this.cornerIndex + n5 * this.panelColumns + n2;
        if (n7 >= this.cellCount) {
            return -1;
        }
        return n7;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.convertMouse(mouseEvent);
        boolean bl = false;
        String string = null;
        if (n < 0) {
            bl |= this.hoverIndex >= 0;
            this.hoverIndex = -1;
            string = " ";
        } else if (this.hoverIndex != n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.cellChar[n];
            this.hoverIndex = n;
            bl = true;
            if (CharMap4J14.glyphFlag) {
                stringBuffer.append("Glyph ");
                stringBuffer.append(CharMap4J14.formatComma.format(this.cellGlyph[n]));
                stringBuffer.append(" = ");
                if (n2 < 0) {
                    stringBuffer.append("no Unicode character mapping");
                }
            }
            if (n2 >= 61472 && n2 <= 61695 && this.charCount <= 256) {
                stringBuffer.append(CharMap4J14.unicodeNotation(n2));
                stringBuffer.append(" =? ");
                if (n2 < 61567) {
                    n2 -= 61440;
                } else if (CharMap4J14.mswinFlag) {
                    stringBuffer.append(CharMap4J14.unicodeNotation(n2 - 61440));
                    stringBuffer.append(" = ");
                    stringBuffer.append(CharMap4J14.winaltNotation(n2 - 61440));
                    n2 = -1;
                } else {
                    stringBuffer.append(CharMap4J14.unicodeNotation(n2 - 61440));
                    stringBuffer.append(" = ");
                    stringBuffer.append("decimal ");
                    stringBuffer.append(CharMap4J14.formatComma.format(n2 - 61440));
                    n2 = -1;
                }
            }
            if (n2 >= 0) {
                stringBuffer.append(CharMap4J14.captionGet(n2));
            }
            string = stringBuffer.toString();
        }
        if (string != null && !CharMap4J14.statusDialog.getText().equals(string)) {
            CharMap4J14.statusDialog.setText(string);
        }
        if (this.clickIndex >= 0 && this.clickIndex != n) {
            this.clickIndex = -1;
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.clickStartY = -1;
        this.clickStartX = -1;
        int n = this.convertMouse(mouseEvent);
        boolean bl = false;
        if (n >= 0) {
            this.clickIndex = this.hoverIndex = n;
            this.clickStartX = mouseEvent.getX();
            this.clickStartY = mouseEvent.getY();
            bl = true;
        } else if (this.clickIndex >= 0 || this.hoverIndex >= 0) {
            this.hoverIndex = -1;
            this.clickIndex = -1;
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.convertMouse(mouseEvent);
        boolean bl = false;
        if (n >= 0 && this.clickIndex == n && Math.abs(this.clickStartX - mouseEvent.getX()) <= 10 && Math.abs(this.clickStartY - mouseEvent.getY()) <= 10) {
            if (mouseEvent.getButton() != 1 || mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                CharMap4J14.rightSaveCaption = CharMap4J14.statusDialog.getText();
                CharMap4J14.rightSaveChar = this.cellChar[n];
                CharMap4J14.rightSaveGlyph = this.cellGlyph[n];
                CharMap4J14.rightCopyCaption.setEnabled(CharMap4J14.rightSaveCaption != null && CharMap4J14.rightSaveCaption.length() > 0);
                CharMap4J14.rightCopyGlyph.setEnabled(CharMap4J14.rightSaveGlyph >= 0);
                CharMap4J14.rightCopyNotation.setEnabled(CharMap4J14.rightSaveChar >= 0);
                CharMap4J14.rightCopyNumber.setEnabled(CharMap4J14.rightSaveChar >= 0);
                CharMap4J14.rightCopyText.setEnabled(CharMap4J14.rightSaveChar >= 0);
                CharMap4J14.rightPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.cellChar[n] >= 0) {
                this.mouseReplaceText(CharMap4J14.charToString(this.cellChar[n]));
            }
        }
        if (this.clickIndex >= 0) {
            this.clickIndex = -1;
            bl = true;
        }
        this.clickStartY = -1;
        this.clickStartX = -1;
        if (this.hoverIndex != n) {
            this.hoverIndex = n;
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    void mouseReplaceText(String string) {
        if (CharMap4J14.clickReplace) {
            CharMap4J14.sampleDialog.setText(string);
        } else {
            CharMap4J14.sampleDialog.replaceSelection(string);
        }
        CharMap4J14.copyText();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        switch (mouseWheelEvent.getScrollType()) {
            case 1: {
                CharMap4J14.gridScroll.setValue(CharMap4J14.gridScroll.getValue() + mouseWheelEvent.getWheelRotation() * CharMap4J14.gridScroll.getBlockIncrement());
                break;
            }
            case 0: {
                int n = CharMap4J14.gridScroll.getBlockIncrement();
                n = Math.max(-n, Math.min(n, mouseWheelEvent.getUnitsToScroll()));
                CharMap4J14.gridScroll.setValue(CharMap4J14.gridScroll.getValue() + n);
                break;
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.setColor(PANEL_COLOR);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        boolean bl = false;
        boolean bl2 = false;
        if (CharMap4J14.displayFont == null) {
            return;
        }
        if (!CharMap4J14.displayFont.equals(this.panelFont)) {
            int n2;
            this.hoverIndex = -1;
            this.clickIndex = -1;
            this.cornerIndex = 0;
            this.panelFont = CharMap4J14.displayFont;
            bl2 = true;
            bl = true;
            this.fontData = graphics2D.getFontMetrics(this.panelFont);
            this.lineAscent = this.fontData.getAscent();
            this.lineHeight = this.fontData.getHeight();
            this.maxWidth = Math.max(10, this.fontData.getMaxAdvance());
            this.horizStep = this.maxWidth + 8 + 2;
            this.vertiStep = this.lineHeight + 8 + 2;
            this.charCount = 0;
            int[] nArray = new int[65536];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = -1;
            }
            this.glyphCount = Math.max(0, this.panelFont.getNumGlyphs());
            int n3 = this.panelFont.getMissingGlyphCode();
            this.glyphChar = new int[this.glyphCount];
            this.glyphGlyph = new int[this.glyphCount];
            for (n = 0; n < this.glyphCount; ++n) {
                this.glyphChar[n] = -1;
                this.glyphGlyph[n] = n;
            }
            for (n = 0; n <= 65535; ++n) {
                if (!this.panelFont.canDisplay((char)n)) continue;
                GlyphVector glyphVector = this.panelFont.createGlyphVector(fontRenderContext, CharMap4J14.charToString(n));
                int n4 = glyphVector.getNumGlyphs();
                for (n2 = 0; n2 < n4; ++n2) {
                    int n5 = glyphVector.getGlyphCode(n2);
                    if (n5 < 0 || n5 >= this.glyphCount || n5 == n3) continue;
                    if (nArray[n] < 0) {
                        nArray[n] = n5;
                    }
                    if (this.glyphChar[n5] >= 0) continue;
                    this.glyphChar[n5] = n;
                }
                if (nArray[n] < 0) continue;
                ++this.charCount;
            }
            this.charChar = new int[this.charCount];
            this.charGlyph = new int[this.charCount];
            n2 = 0;
            for (n = 0; n <= 65535; ++n) {
                int n6 = nArray[n];
                if (n6 < 0) continue;
                this.charChar[n2] = n;
                this.charGlyph[n2] = n6;
                ++n2;
            }
            nArray = null;
            CharMap4J14.statusDialog.setText(CharMap4J14.formatComma.format(this.charCount) + " characters with " + CharMap4J14.formatComma.format(this.glyphCount) + " glyphs");
            if (this.charCount <= 0 || this.glyphCount <= 0) {
                this.panelFont = null;
                return;
            }
        }
        if (CharMap4J14.glyphFlag) {
            this.cellChar = this.glyphChar;
            this.cellCount = this.glyphCount;
            this.cellGlyph = this.glyphGlyph;
        } else {
            this.cellChar = this.charChar;
            this.cellCount = this.charCount;
            this.cellGlyph = this.charGlyph;
        }
        if (bl2 || this.getWidth() != this.panelWidth) {
            this.panelWidth = this.getWidth();
            bl2 = true;
            this.panelColumns = Math.max(1, (this.panelWidth - 10 - 2) / this.horizStep);
        }
        if (bl || this.getHeight() != this.panelHeight) {
            this.panelHeight = this.getHeight();
            bl = true;
            this.panelRows = Math.max(1, (this.panelHeight - 10 - 2) / this.vertiStep);
        }
        if (this.cellCount != this.panelCount || bl || bl2) {
            this.panelCount = this.cellCount;
            int n7 = this.cornerIndex / this.panelColumns;
            n7 = Math.max(0, Math.min(n7, this.cellCount / this.panelColumns - this.panelRows + 1));
            CharMap4J14.gridScroll.setValues(n7, this.panelRows, 0, (this.cellCount + this.panelColumns - 1) / this.panelColumns);
            this.cornerIndex = CharMap4J14.gridScroll.getValue() * this.panelColumns;
            CharMap4J14.gridScroll.setBlockIncrement(Math.max(1, this.panelRows - 1));
            CharMap4J14.gridScroll.setUnitIncrement(1);
        }
        int n8 = this.cornerIndex + this.panelColumns * (this.panelRows + 1) - 1;
        for (n = this.cornerIndex; n <= n8; ++n) {
            this.paintGridCell(graphics2D, fontRenderContext, n);
        }
    }

    void paintGridCell(Graphics2D graphics2D, FontRenderContext fontRenderContext, int n) {
        if (n >= this.cellCount) {
            return;
        }
        int n2 = (n - this.cornerIndex) % this.panelColumns * this.horizStep + 5;
        int n3 = (n - this.cornerIndex) / this.panelColumns * this.vertiStep + 5;
        graphics2D.setColor(GRID_COLOR);
        graphics2D.fillRect(n2, n3, this.horizStep + 2, this.vertiStep + 2);
        if (n == this.clickIndex) {
            graphics2D.setColor(TEXT_COLOR);
        } else if (n != this.hoverIndex) {
            graphics2D.setColor(PANEL_COLOR);
        }
        graphics2D.fillRect(n2 + 2, n3 + 2, this.horizStep - 2, this.vertiStep - 2);
        graphics2D.setColor(n == this.clickIndex ? PANEL_COLOR : TEXT_COLOR);
        if (CharMap4J14.glyphFlag) {
            int[] nArray = new int[]{this.cellGlyph[n]};
            GlyphVector glyphVector = this.panelFont.createGlyphVector(fontRenderContext, nArray);
            graphics2D.drawGlyphVector(glyphVector, n2 + 2 + 4 + (this.maxWidth - (int)glyphVector.getGlyphMetrics(0).getAdvanceX()) / 2, n3 + 2 + 4 + this.lineAscent);
        } else {
            int n4 = this.cellChar[n];
            graphics2D.setFont(this.panelFont);
            graphics2D.drawString(CharMap4J14.charToString(n4), n2 + 2 + 4 + (this.maxWidth - this.fontData.charWidth(n4)) / 2, n3 + 2 + 4 + this.lineAscent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        int n2;
        if (this.panelFont != null && (n2 = (n = CharMap4J14.gridScroll.getValue()) * this.panelColumns) != this.cornerIndex) {
            this.cornerIndex = n2;
            this.repaint();
        }
    }
}

