package org.drools.tutorials.banking;

import java.text.SimpleDateFormat;
import java.util.Date;

public class AllocatedCashflow extends TypedCashflow {
    private Account account;

    public AllocatedCashflow() {
    }

    public AllocatedCashflow(Account account,
                             Date date,
                             int type,
                             double amount) {
        super( date,
               type,
               amount );
        this.account = account;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'N'MM''dd''");

        return "܂LbVt[[" + "=" + account + ",t=" + sdf.format(getDate()) + 
                                  ",^Cv=" + (getType() == CREDIT ? "ݕ" : "ؕ") + 
                                  ",z=" + getAmount() + "]";
    }
}