/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

This code is a part of the Visual Studio Library.

***************************************************************************/

#ifndef IDEBUGSOURCESERVERMODULE_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
#define IDEBUGSOURCESERVERMODULE_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5

#if _MSC_VER > 1000
#pragma once
#endif

#include "msdbg.h"

#pragma warning(push)
#pragma warning(disable : 4510) // default constructor could not be generated
#pragma warning(disable : 4610) // can never be instantiated - user defined constructor required
#pragma warning(disable : 4512) // assignment operator could not be generated
#pragma warning(disable : 6011) // Dereferencing NULL pointer (a NULL derference is just another kind of failure for a unit test

namespace VSL
{

class IDebugSourceServerModuleNotImpl :
	public IDebugSourceServerModule
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IDebugSourceServerModuleNotImpl)

public:

	typedef IDebugSourceServerModule Interface;

	STDMETHOD(GetSourceServerData)(
		/*[out]*/ ULONG* /*pDataByteCount*/,
		/*[out,size_is(,*pDataByteCount)]*/ BYTE** /*ppData*/)VSL_STDMETHOD_NOTIMPL
};

class IDebugSourceServerModuleMockImpl :
	public IDebugSourceServerModule,
	public MockBase
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IDebugSourceServerModuleMockImpl)

public:

VSL_DEFINE_MOCK_CLASS_TYPDEFS(IDebugSourceServerModuleMockImpl)

	typedef IDebugSourceServerModule Interface;
	struct GetSourceServerDataValidValues
	{
		/*[out]*/ ULONG* pDataByteCount;
		/*[out,size_is(,*pDataByteCount)]*/ BYTE** ppData;
		HRESULT retValue;
	};

	STDMETHOD(GetSourceServerData)(
		/*[out]*/ ULONG* pDataByteCount,
		/*[out,size_is(,*pDataByteCount)]*/ BYTE** ppData)
	{
		VSL_DEFINE_MOCK_METHOD(GetSourceServerData)

		VSL_SET_VALIDVALUE(pDataByteCount);

		VSL_SET_VALIDVALUE_MEMCPY(ppData, *pDataByteCount*sizeof(ppData[0]), *(validValues.pDataByteCount)*sizeof(validValues.ppData[0]));

		VSL_RETURN_VALIDVALUES();
	}
};


} // namespace VSL

#pragma warning(pop)

#endif // IDEBUGSOURCESERVERMODULE_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
