/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.preferences;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.AbstractConsoleConfigurationPreferences;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StandAloneConsoleConfigurationPreferences
extends AbstractConsoleConfigurationPreferences {
    private File cfgFile;
    private File propertyFilename;
    private File[] mappings;
    private File[] customClasspath;

    public StandAloneConsoleConfigurationPreferences(String name, File xmlconfig, File propertiesFile, File[] mappingFiles, File[] customClasspath) {
        super(name, ConsoleConfigurationPreferences.ConfigurationMode.CORE, null, false, null, null, null, null, null);
        this.cfgFile = xmlconfig;
        this.propertyFilename = propertiesFile;
        this.mappings = mappingFiles;
        this.customClasspath = customClasspath;
    }

    protected StandAloneConsoleConfigurationPreferences() {
    }

    protected StandAloneConsoleConfigurationPreferences(String name) {
        this(name, null, null, new File[0], new File[0]);
    }

    public URL[] getCustomClassPathURLS() {
        URL[] result = new URL[this.customClasspath.length];
        int i = 0;
        while (i < this.customClasspath.length) {
            File file = this.customClasspath[i];
            try {
                result[i] = file.toURL();
            }
            catch (MalformedURLException mue) {
                throw new HibernateConsoleRuntimeException(ConsoleMessages.StandAloneConsoleConfigurationPreferences_could_not_resolve_classpaths, mue);
            }
            ++i;
        }
        return result;
    }

    public File[] getMappingFiles() {
        return this.mappings;
    }

    public File getConfigXMLFile() {
        return this.cfgFile;
    }

    public void writeStateTo(Element node) {
        StandAloneConsoleConfigurationPreferences.writeStateTo(node, this.getName(), this.getEntityResolverName(), this.getConfigurationMode(), null, false, this.cfgFile, this.propertyFilename, this.mappings, this.customClasspath);
    }

    public File getPropertyFile() {
        return this.propertyFilename;
    }

    protected void setConfigFile(String cfgFile) {
        this.cfgFile = cfgFile == null ? null : new File(cfgFile);
    }

    protected void setPropertyFile(String cfgFile) {
        this.propertyFilename = cfgFile == null ? null : new File(cfgFile);
    }

    protected void setMappings(String[] mappings) {
        this.mappings = new File[mappings.length];
        int i = 0;
        while (i < mappings.length) {
            String str = mappings[i];
            this.mappings[i] = new File(str);
            ++i;
        }
    }

    protected void setCustomClassPath(String[] mappings) {
        this.customClasspath = new File[mappings.length];
        int i = 0;
        while (i < mappings.length) {
            String str = mappings[i];
            this.customClasspath[i] = new File(str);
            ++i;
        }
    }

    public static StandAloneConsoleConfigurationPreferences[] readStateFrom(File f) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(f);
            Element root = doc.getDocumentElement();
            NodeList elementsByTagName = root.getElementsByTagName("configuration");
            StandAloneConsoleConfigurationPreferences[] result = new StandAloneConsoleConfigurationPreferences[elementsByTagName.getLength()];
            int i = 0;
            while (i < elementsByTagName.getLength()) {
                result[i] = new StandAloneConsoleConfigurationPreferences();
                result[i].readStateFrom((Element)elementsByTagName.item(i));
                ++i;
            }
            return result;
        }
        catch (SAXException sa) {
            throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.StandAloneConsoleConfigurationPreferences_errors_while_parsing) + f, sa);
        }
        catch (ParserConfigurationException e) {
            throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.StandAloneConsoleConfigurationPreferences_errors_while_parsing) + f, e);
        }
        catch (IOException e) {
            throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.StandAloneConsoleConfigurationPreferences_errors_while_parsing) + f, e);
        }
    }
}

