/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;

public class JPAPostInstallFasetListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.POST_INSTALL) {
            IProject project = event.getProject().getProject();
            IProjectFacetActionEvent pEvent = (IProjectFacetActionEvent)event;
            if (pEvent.getProjectFacet().getId().equals("jpt.jpa") && "hibernate".equals(JptCorePlugin.getJpaPlatformId((IProject)project)) && this.checkPreConditions(project)) {
                this.buildConsoleConfiguration(project);
            }
        }
    }

    protected boolean checkPreConditions(IProject project) {
        try {
            ILaunchConfiguration lc = this.getLaunchConfiguration(project);
            if (lc != null && lc.exists()) {
                ProjectUtils.toggleHibernateOnProject((IProject)project, (boolean)true, (String)lc.getName());
                return false;
            }
        }
        catch (CoreException e) {
            HibernateJptPlugin.logException(e);
        }
        return true;
    }

    private ILaunchConfiguration getLaunchConfiguration(IProject project) throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] lcs = LaunchHelper.findHibernateLaunchConfigs();
        int i = 0;
        while (i < lcs.length) {
            ILaunchConfiguration lc = lcs[i];
            if (project.getName().equals(lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null))) {
                if (project.getName().equals(lc.getName())) {
                    return lc;
                }
                configs.add(lc);
            }
            ++i;
        }
        Pattern p = Pattern.compile(String.valueOf(project.getName()) + " \\(\\d+\\)");
        int i2 = 0;
        while (i2 < configs.size()) {
            ILaunchConfiguration lc = (ILaunchConfiguration)configs.get(i2);
            if (p.matcher(lc.getName()).matches()) {
                return lc;
            }
            ++i2;
        }
        return configs.size() > 0 ? (ILaunchConfiguration)configs.get(0) : null;
    }

    protected void buildConsoleConfiguration(IProject project) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType lct = LaunchHelper.getHibernateLaunchConfigsType();
        String launchName = lm.generateUniqueLaunchConfigurationNameFrom(project.getName());
        try {
            ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, launchName);
            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Collections.singletonList(new Path(project.getName()).makeAbsolute().toString()));
            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Collections.singletonList(Integer.toString(4)));
            wc.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.JPA.toString());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            wc.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", null);
            wc.setAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.toString(true));
            wc.doSave();
            ProjectUtils.toggleHibernateOnProject((IProject)project, (boolean)true, (String)launchName);
        }
        catch (CoreException e) {
            HibernateJptPlugin.logException(e);
        }
    }
}

