/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.GenericPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateJpaProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistenceUnit
extends GenericPersistenceUnit
implements Messages,
Hibernate {
    private HibernateJpaProperties hibernateProperties = new HibernateJpaProperties((PersistenceUnit)this);

    public HibernatePersistenceUnit(Persistence parent, XmlPersistenceUnit persistenceUnit) {
        super(parent, persistenceUnit);
    }

    public BasicHibernateProperties getBasicProperties() {
        return this.hibernateProperties.getBasicHibernate();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateHibernateConfigurationFileExists(messages, reporter);
    }

    protected void validateHibernateConfigurationFileExists(List<IMessage> messages, IReporter reporter) {
        String configFile = this.getBasicProperties().getConfigurationFile();
        if (configFile != null && configFile.length() > 0) {
            Path path = new Path(configFile);
            if (new File(path.toOSString()).exists()) {
                return;
            }
            try {
                IJavaProject jp = this.getJpaProject().getJavaProject();
                IPackageFragmentRoot[] pfrs = jp.getPackageFragmentRoots();
                int i = 0;
                while (i < pfrs.length) {
                    if (!pfrs[i].isArchive() && ((IContainer)pfrs[i].getResource()).findMember((IPath)path) != null) {
                        return;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                HibernateJptPlugin.logException(e);
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                int resType = res.getType();
                if (resType != 1) {
                    PersistenceUnit.Property prop = this.getProperty("hibernate.ejb.cfgfile");
                    LocalMessage message = new LocalMessage(1, "NOT_A_FILE", new String[]{configFile}, this.getResource());
                    message.setLineNo(prop.getValidationTextRange().getLineNumber());
                    messages.add((IMessage)message);
                }
            } else {
                PersistenceUnit.Property prop = this.getProperty("hibernate.ejb.cfgfile");
                LocalMessage message = new LocalMessage(1, "CONFIG_FILE_NOT_FOUND", new String[]{configFile}, this.getResource());
                message.setLineNo(prop.getValidationTextRange().getLineNumber());
                messages.add((IMessage)message);
            }
        }
    }

    public static class LocalMessage
    extends Message {
        public LocalMessage(int severity, String message, String[] strings, Object resource) {
            super(Messages.class.getName(), severity, message, strings, resource);
        }
    }
}

