/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.jboss.tools.hibernate.jpt.core.internal.context.Index;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;

public class IndexImpl
extends AbstractJavaJpaContextNode
implements Index {
    private IndexAnnotation indexResource;
    private String name;
    private String[] columnNames = new String[0];

    public IndexImpl(JavaJpaContextNode parent) {
        super((JpaContextNode)parent);
    }

    public void initialize(IndexAnnotation indexResource) {
        this.indexResource = indexResource;
        this.name = indexResource.getName();
        this.columnNames = indexResource.getColumnNames();
    }

    public void update(IndexAnnotation indexResource) {
        this.indexResource = indexResource;
        this.setName_(indexResource.getName());
        this.setColumnNames_(indexResource.getColumnNames());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getResourceIndex().setName(name);
        this.firePropertyChanged("name", old, name);
    }

    public void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames == null) {
            columnNames = new String[]{};
        }
        String[] old = this.columnNames;
        this.columnNames = columnNames;
        this.getResourceIndex().setColumnNames(columnNames);
        this.firePropertyChanged("ColumnNames", old, columnNames);
    }

    public void setColumnNames_(String[] columnNames) {
        String[] old = this.columnNames;
        this.columnNames = columnNames;
        this.firePropertyChanged("ColumnNames", old, columnNames);
    }

    private IndexAnnotation getResourceIndex() {
        return this.indexResource;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.indexResource.getTextRange(astRoot);
    }

    public void addColumn(String columnName) {
        String[] old = this.columnNames;
        String[] newColumns = new String[old.length + 1];
        System.arraycopy(old, 0, newColumns, 0, old.length);
        newColumns[newColumns.length - 1] = columnName;
        this.setColumnNames(newColumns);
    }

    public void removeColumn(String columnName) {
        String[] old = this.columnNames;
        ArrayList<String> newColumns = new ArrayList<String>();
        String[] stringArray = old;
        int n = old.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            if (!column.equals(columnName)) {
                newColumns.add(column);
            }
            ++n2;
        }
        this.setColumnNames(newColumns.toArray(new String[newColumns.size()]));
    }
}

