/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaEntity;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKey;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedNativeQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaEntity;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaDiscriminatorFormula;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaGenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.DiscriminatorFormulaAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateNamedNativeQueryAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateNamedQueryAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaEntityImpl
extends AbstractJavaEntity
implements HibernateJavaEntity {
    protected JavaDiscriminatorFormula discriminatorFormula;
    protected final List<JavaGenericGenerator> genericGenerators = new ArrayList<JavaGenericGenerator>();
    protected final List<HibernateNamedQuery> hibernateNamedQueries = new ArrayList<HibernateNamedQuery>();
    protected final List<HibernateNamedNativeQuery> hibernateNamedNativeQueries = new ArrayList<HibernateNamedNativeQuery>();
    protected ForeignKey foreignKey;

    public HibernateJavaEntityImpl(JavaPersistentType parent) {
        super(parent);
    }

    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        super.initialize(resourcePersistentType);
        this.initializeDiscriminatorFormula();
        this.initializeGenericGenerators();
        this.initializeHibernateNamedQueries();
        this.initializeHibernateNamedNativeQueries();
        this.initializeForeignKey();
    }

    public void update(JavaResourcePersistentType resourcePersistentType) {
        super.update(resourcePersistentType);
        this.updateDiscriminatorFormula();
        this.updateGenericGenerators();
        this.updateHibernateNamedQueries();
        this.updateHibernateNamedNativeQueries();
        this.updateForeignKey();
    }

    protected HibernateJpaFactory getJpaFactory() {
        return (HibernateJpaFactory)this.getJpaPlatform().getJpaFactory();
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Iterator<JavaQuery> queries() {
        return new CompositeIterator(new Iterator[]{super.queries(), this.hibernateNamedQueries(), this.hibernateNamedNativeQueries()});
    }

    public Iterator<String> correspondingAnnotationNames() {
        return new CompositeIterator(new Iterator[]{new ArrayIterator((Object[])new String[]{"org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries", "org.hibernate.annotations.DiscriminatorFormula", "org.hibernate.annotations.ForeignKey"}), super.correspondingAnnotationNames()});
    }

    @Override
    public HibernateJavaTable getTable() {
        return (HibernateJavaTable)super.getTable();
    }

    @Override
    public JavaDiscriminatorFormula getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    protected void setDiscriminatorFormula(JavaDiscriminatorFormula newDiscriminatorFormula) {
        JavaDiscriminatorFormula oldDiscriminatorFormula = this.discriminatorFormula;
        this.discriminatorFormula = newDiscriminatorFormula;
        this.firePropertyChanged("discriminatorFormula", oldDiscriminatorFormula, newDiscriminatorFormula);
    }

    @Override
    public JavaDiscriminatorFormula addDiscriminatorFormula() {
        if (this.getDiscriminatorFormula() != null) {
            throw new IllegalStateException("discriminatorFormula already exists");
        }
        this.discriminatorFormula = this.getJpaFactory().buildJavaDiscriminatorFormula(this);
        DiscriminatorFormulaAnnotation discriminatorFormulaResource = (DiscriminatorFormulaAnnotation)this.javaResourcePersistentType.addSupportingAnnotation("org.hibernate.annotations.DiscriminatorFormula");
        this.discriminatorFormula.initialize(discriminatorFormulaResource);
        this.firePropertyChanged("discriminatorFormula", null, this.discriminatorFormula);
        return this.discriminatorFormula;
    }

    @Override
    public void removeDiscriminatorFormula() {
        if (this.getDiscriminatorFormula() == null) {
            throw new IllegalStateException("discriminatorFormula does not exist, cannot be removed");
        }
        JavaDiscriminatorFormula oldDiscriminatorFormula = this.discriminatorFormula;
        this.discriminatorFormula = null;
        this.javaResourcePersistentType.removeSupportingAnnotation("org.hibernate.annotations.DiscriminatorFormula");
        this.firePropertyChanged("discriminatorFormula", oldDiscriminatorFormula, null);
    }

    protected void initializeDiscriminatorFormula() {
        DiscriminatorFormulaAnnotation discriminatorFormulaResource = this.getDiscriminatorFormulaResource();
        if (discriminatorFormulaResource != null) {
            this.discriminatorFormula = this.buildDiscriminatorFormula(discriminatorFormulaResource);
        }
    }

    protected void updateDiscriminatorFormula() {
        DiscriminatorFormulaAnnotation discriminatorFormulaResource = this.getDiscriminatorFormulaResource();
        if (discriminatorFormulaResource == null) {
            if (this.getDiscriminatorFormula() != null) {
                this.setDiscriminatorFormula(null);
            }
        } else if (this.getDiscriminatorFormula() == null) {
            this.setDiscriminatorFormula(this.buildDiscriminatorFormula(discriminatorFormulaResource));
        } else {
            this.getDiscriminatorFormula().update(discriminatorFormulaResource);
        }
    }

    public DiscriminatorFormulaAnnotation getDiscriminatorFormulaResource() {
        return (DiscriminatorFormulaAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("org.hibernate.annotations.DiscriminatorFormula");
    }

    protected JavaDiscriminatorFormula buildDiscriminatorFormula(DiscriminatorFormulaAnnotation discriminatorFormulaResource) {
        JavaDiscriminatorFormula discriminatorFormula = this.getJpaFactory().buildJavaDiscriminatorFormula(this);
        discriminatorFormula.initialize(discriminatorFormulaResource);
        return discriminatorFormula;
    }

    @Override
    public GenericGenerator addGenericGenerator(int index) {
        JavaGenericGenerator newGenericGenerator = this.getJpaFactory().buildJavaGenericGenerator((JavaJpaContextNode)this);
        this.genericGenerators.add(newGenericGenerator);
        GenericGeneratorAnnotation genericGeneratorAnnotation = (GenericGeneratorAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators");
        newGenericGenerator.initialize(genericGeneratorAnnotation);
        this.fireItemAdded("genericGenerators", index, newGenericGenerator);
        return newGenericGenerator;
    }

    protected void addGenericGenerator(JavaGenericGenerator genericGenerator) {
        this.addGenericGenerator(this.genericGeneratorsSize(), genericGenerator);
    }

    protected void addGenericGenerator(int index, JavaGenericGenerator genericGenerator) {
        this.addItemToList(index, genericGenerator, this.genericGenerators, "genericGenerators");
    }

    public ListIterator<JavaGenericGenerator> genericGenerators() {
        return new CloneListIterator(this.genericGenerators);
    }

    @Override
    public int genericGeneratorsSize() {
        return this.genericGenerators.size();
    }

    @Override
    public void moveGenericGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.genericGenerators, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "org.hibernate.annotations.GenericGenerator");
        this.fireItemMoved("genericGenerators", targetIndex, sourceIndex);
    }

    @Override
    public void removeGenericGenerator(int index) {
        JavaGenericGenerator removedGenericGenerator = this.genericGenerators.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators");
        this.fireItemRemoved("genericGenerators", index, removedGenericGenerator);
    }

    @Override
    public void removeGenericGenerator(GenericGenerator generator) {
        this.removeGenericGenerator(this.genericGenerators.indexOf(generator));
    }

    protected void removeGenericGenerator_(JavaGenericGenerator generator) {
        this.removeItemFromList(generator, this.genericGenerators, "genericGenerators");
    }

    protected void initializeGenericGenerators() {
        ListIterator stream = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators");
        while (stream.hasNext()) {
            this.genericGenerators.add(this.buildGenericGenerator((GenericGeneratorAnnotation)stream.next()));
        }
    }

    protected JavaGenericGenerator buildGenericGenerator(GenericGeneratorAnnotation genericGeneratorResource) {
        JavaGenericGenerator generator = this.getJpaFactory().buildJavaGenericGenerator((JavaJpaContextNode)this);
        generator.initialize(genericGeneratorResource);
        return generator;
    }

    protected void addGeneratorsTo(ArrayList<JavaGenerator> generators) {
        super.addGeneratorsTo(generators);
        for (JavaGenericGenerator genericGenerator : this.genericGenerators) {
            generators.add(genericGenerator);
        }
    }

    protected void updateGenericGenerators() {
        ListIterator<JavaGenericGenerator> genericGenerators = this.genericGenerators();
        ListIterator resourceGenericGenerators = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators");
        while (genericGenerators.hasNext()) {
            JavaGenericGenerator genericGenerator = genericGenerators.next();
            if (resourceGenericGenerators.hasNext()) {
                genericGenerator.update((GenericGeneratorAnnotation)resourceGenericGenerators.next());
                continue;
            }
            this.removeGenericGenerator_(genericGenerator);
        }
        while (resourceGenericGenerators.hasNext()) {
            this.addGenericGenerator(this.buildGenericGenerator((GenericGeneratorAnnotation)resourceGenericGenerators.next()));
        }
    }

    public ListIterator<HibernateNamedQuery> hibernateNamedQueries() {
        return new CloneListIterator(this.hibernateNamedQueries);
    }

    @Override
    public int hibernateNamedQueriesSize() {
        return this.hibernateNamedQueries.size();
    }

    protected void initializeHibernateNamedQueries() {
        ListIterator stream = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries");
        while (stream.hasNext()) {
            this.hibernateNamedQueries.add(this.buildHibernateNamedQuery((HibernateNamedQueryAnnotation)stream.next()));
        }
    }

    protected HibernateNamedQuery buildHibernateNamedQuery(HibernateNamedQueryAnnotation namedQueryResource) {
        HibernateNamedQuery hibernateNamedQuery = this.getJpaFactory().buildHibernateNamedQuery((JavaJpaContextNode)this);
        hibernateNamedQuery.initialize(namedQueryResource);
        return hibernateNamedQuery;
    }

    protected void updateHibernateNamedQueries() {
        ListIterator<HibernateNamedQuery> queries = this.hibernateNamedQueries();
        ListIterator resourceNamedQueries = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries");
        while (queries.hasNext()) {
            HibernateNamedQuery hibernateNamedQuery = queries.next();
            if (resourceNamedQueries.hasNext()) {
                hibernateNamedQuery.update((HibernateNamedQueryAnnotation)resourceNamedQueries.next());
                continue;
            }
            this.removeHibernateNamedQuery_(hibernateNamedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addHibernateNamedQuery(this.buildHibernateNamedQuery((HibernateNamedQueryAnnotation)resourceNamedQueries.next()));
        }
    }

    @Override
    public HibernateNamedQuery addHibernateNamedQuery(int index) {
        HibernateNamedQuery hibernateNamedQuery = this.getJpaFactory().buildHibernateNamedQuery((JavaJpaContextNode)this);
        this.hibernateNamedQueries.add(index, hibernateNamedQuery);
        HibernateNamedQueryAnnotation hibernateNamedQueryAnnotation = (HibernateNamedQueryAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries");
        hibernateNamedQuery.initialize(hibernateNamedQueryAnnotation);
        this.fireItemAdded("hibernateNamedQueries", index, hibernateNamedQuery);
        return hibernateNamedQuery;
    }

    protected void addHibernateNamedQuery(int index, HibernateNamedQuery hibernateNamedQuery) {
        this.addItemToList(index, hibernateNamedQuery, this.hibernateNamedQueries, "hibernateNamedQueries");
    }

    protected void addHibernateNamedQuery(HibernateNamedQuery hibernateNamedQuery) {
        this.addHibernateNamedQuery(this.hibernateNamedQueries.size(), hibernateNamedQuery);
    }

    @Override
    public void removeHibernateNamedQuery(HibernateNamedQuery hibernateNamedQuery) {
        this.removeHibernateNamedQuery(this.hibernateNamedQueries.indexOf(hibernateNamedQuery));
    }

    @Override
    public void removeHibernateNamedQuery(int index) {
        HibernateNamedQuery removedHibernateNamedQuery = this.hibernateNamedQueries.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries");
        this.fireItemRemoved("hibernateNamedQueries", index, removedHibernateNamedQuery);
    }

    protected void removeHibernateNamedQuery_(HibernateNamedQuery hibernateNamedQuery) {
        this.removeItemFromList(hibernateNamedQuery, this.hibernateNamedQueries, "hibernateNamedQueries");
    }

    @Override
    public void moveHibernateNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.hibernateNamedQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "org.hibernate.annotations.NamedQueries");
        this.fireItemMoved("hibernateNamedQueries", targetIndex, sourceIndex);
    }

    public ListIterator<HibernateNamedNativeQuery> hibernateNamedNativeQueries() {
        return new CloneListIterator(this.hibernateNamedNativeQueries);
    }

    @Override
    public int hibernateNamedNativeQueriesSize() {
        return this.hibernateNamedNativeQueries.size();
    }

    protected void initializeHibernateNamedNativeQueries() {
        ListIterator stream = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries");
        while (stream.hasNext()) {
            this.hibernateNamedNativeQueries.add(this.buildHibernateNamedNativeQuery((HibernateNamedNativeQueryAnnotation)stream.next()));
        }
    }

    protected HibernateNamedNativeQuery buildHibernateNamedNativeQuery(HibernateNamedNativeQueryAnnotation namedQueryResource) {
        HibernateNamedNativeQuery hibernateNamedNativeQuery = this.getJpaFactory().buildHibernateNamedNativeQuery((JavaJpaContextNode)this);
        hibernateNamedNativeQuery.initialize(namedQueryResource);
        return hibernateNamedNativeQuery;
    }

    protected void updateHibernateNamedNativeQueries() {
        ListIterator<HibernateNamedNativeQuery> queries = this.hibernateNamedNativeQueries();
        ListIterator resourceNamedNativeQueries = this.javaResourcePersistentType.supportingAnnotations("org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries");
        while (queries.hasNext()) {
            HibernateNamedNativeQuery hibernateNamedNativeQuery = queries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                hibernateNamedNativeQuery.update((HibernateNamedNativeQueryAnnotation)resourceNamedNativeQueries.next());
                continue;
            }
            this.removeHibernateNamedNativeQuery_(hibernateNamedNativeQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            Object test = resourceNamedNativeQueries.next();
            if (!(test instanceof HibernateNamedNativeQueryAnnotation)) {
                System.out.println("error!");
            }
            this.addHibernateNamedNativeQuery(this.buildHibernateNamedNativeQuery((HibernateNamedNativeQueryAnnotation)test));
        }
    }

    @Override
    public HibernateNamedNativeQuery addHibernateNamedNativeQuery(int index) {
        HibernateNamedNativeQuery hibernateNamedNativeQuery = this.getJpaFactory().buildHibernateNamedNativeQuery((JavaJpaContextNode)this);
        this.hibernateNamedNativeQueries.add(index, hibernateNamedNativeQuery);
        HibernateNamedNativeQueryAnnotation hibernateNamedNativeQueryAnnotation = (HibernateNamedNativeQueryAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries");
        hibernateNamedNativeQuery.initialize(hibernateNamedNativeQueryAnnotation);
        this.fireItemAdded("hibernateNamedNativeQueries", index, hibernateNamedNativeQuery);
        return hibernateNamedNativeQuery;
    }

    protected void addHibernateNamedNativeQuery(int index, HibernateNamedNativeQuery hibernateNamedNativeQuery) {
        this.addItemToList(index, hibernateNamedNativeQuery, this.hibernateNamedNativeQueries, "hibernateNamedNativeQueries");
    }

    protected void addHibernateNamedNativeQuery(HibernateNamedNativeQuery hibernateNamedNativeQuery) {
        this.addHibernateNamedNativeQuery(this.hibernateNamedNativeQueries.size(), hibernateNamedNativeQuery);
    }

    @Override
    public void removeHibernateNamedNativeQuery(HibernateNamedNativeQuery hibernateNamedNativeQuery) {
        this.removeHibernateNamedNativeQuery(this.hibernateNamedNativeQueries.indexOf(hibernateNamedNativeQuery));
    }

    @Override
    public void removeHibernateNamedNativeQuery(int index) {
        HibernateNamedNativeQuery removedHibernateNamedNativeQuery = this.hibernateNamedNativeQueries.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries");
        this.fireItemRemoved("hibernateNamedNativeQueries", index, removedHibernateNamedNativeQuery);
    }

    protected void removeHibernateNamedNativeQuery_(HibernateNamedNativeQuery hibernateNamedNativeQuery) {
        this.removeItemFromList(hibernateNamedNativeQuery, this.hibernateNamedNativeQueries, "hibernateNamedNativeQueries");
    }

    @Override
    public void moveHibernateNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.hibernateNamedNativeQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "org.hibernate.annotations.NamedNativeQueries");
        this.fireItemMoved("hibernateNamedNativeQueries", targetIndex, sourceIndex);
    }

    protected void initializeForeignKey() {
        ForeignKeyAnnotation foreignKeyResource = this.getResourceForeignKey();
        if (foreignKeyResource != null) {
            this.foreignKey = this.buildForeignKey(foreignKeyResource);
        }
    }

    protected void updateForeignKey() {
        ForeignKeyAnnotation foreignKeyResource = this.getResourceForeignKey();
        if (foreignKeyResource == null) {
            if (this.getForeignKey() != null) {
                this.setForeignKey(null);
            }
        } else if (this.getForeignKey() == null) {
            this.setForeignKey(this.buildForeignKey(foreignKeyResource));
        } else {
            this.getForeignKey().update(foreignKeyResource);
        }
    }

    @Override
    public ForeignKey addForeignKey() {
        if (this.getForeignKey() != null) {
            throw new IllegalStateException("foreignKey already exists");
        }
        this.foreignKey = this.getJpaFactory().buildForeignKey((JavaJpaContextNode)this);
        ForeignKeyAnnotation foreignKeyResource = (ForeignKeyAnnotation)this.javaResourcePersistentType.addSupportingAnnotation("org.hibernate.annotations.ForeignKey");
        this.foreignKey.initialize(foreignKeyResource);
        this.firePropertyChanged("foreignKey", null, this.foreignKey);
        return this.foreignKey;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    protected void setForeignKey(ForeignKey newForeignKey) {
        ForeignKey oldForeignKey = this.foreignKey;
        this.foreignKey = newForeignKey;
        this.firePropertyChanged("foreignKey", oldForeignKey, newForeignKey);
    }

    @Override
    public void removeForeignKey() {
        if (this.getForeignKey() == null) {
            throw new IllegalStateException("foreignKey does not exist, cannot be removed");
        }
        ForeignKey oldForeignKey = this.foreignKey;
        this.foreignKey = null;
        this.javaResourcePersistentType.removeSupportingAnnotation("org.hibernate.annotations.ForeignKey");
        this.firePropertyChanged("foreignKey", oldForeignKey, null);
    }

    protected ForeignKey buildForeignKey(ForeignKeyAnnotation foreignKeyResource) {
        ForeignKey foreignKey = this.getJpaFactory().buildForeignKey((JavaJpaContextNode)this);
        foreignKey.initialize(foreignKeyResource);
        return foreignKey;
    }

    protected ForeignKeyAnnotation getResourceForeignKey() {
        return (ForeignKeyAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("org.hibernate.annotations.ForeignKey");
    }

    @Override
    public org.eclipse.jpt.db.Table getForeignKeyDbTable() {
        return this.getPrimaryDbTable();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateGenericGenerator(messages, reporter, astRoot);
        this.validateForeignKey(messages, astRoot);
    }

    protected void validateGenericGenerator(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        for (JavaGenericGenerator genericGenerator : this.genericGenerators) {
            genericGenerator.validate(messages, reporter, astRoot);
        }
    }

    protected void validateForeignKey(List<IMessage> messages, CompilationUnit astRoot) {
        org.eclipse.jpt.db.Table table = this.getForeignKeyDbTable();
        if (!this.shouldValidateAgainstDatabase() || this.foreignKey == null || table == null) {
            return;
        }
        Iterator fks = table.foreignKeys();
        while (fks.hasNext()) {
            org.eclipse.jpt.db.ForeignKey fk = (org.eclipse.jpt.db.ForeignKey)fks.next();
            if (!this.foreignKey.getName().equals(fk.getIdentifier())) continue;
            return;
        }
        TextRange textRange = this.getResourceForeignKey().getNameTextRange(astRoot);
        HibernatePersistenceUnit.LocalMessage message = new HibernatePersistenceUnit.LocalMessage(1, "UNRESOLVED_FOREIGN_KEY_NAME", new String[]{this.foreignKey.getName(), this.getPrimaryTableName()}, this.foreignKey);
        message.setLineNo(textRange.getLineNumber());
        message.setOffset(textRange.getOffset());
        message.setLength(textRange.getLength());
        messages.add((IMessage)message);
    }

    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaGenericGenerator genericGenerator : this.genericGenerators) {
            result = genericGenerator.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected JavaBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new HibernatePrimaryKeyJoinColumnOwner();
    }

    public String getPrimaryTableName() {
        return this.getTable().getDBTableName();
    }

    public String getDefaultTableName() {
        return super.getDefaultTableName();
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                if (t instanceof HibernateTable) {
                    return ((HibernateTable)t).getDBTableName();
                }
                return t.getName();
            }
        };
    }

    class HibernatePrimaryKeyJoinColumnOwner
    implements JavaBaseJoinColumn.Owner {
        HibernatePrimaryKeyJoinColumnOwner() {
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return HibernateJavaEntityImpl.this.getValidationTextRange(astRoot);
        }

        public TypeMapping getTypeMapping() {
            return HibernateJavaEntityImpl.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return HibernateJavaEntityImpl.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = HibernateJavaEntityImpl.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return HibernateJavaEntityImpl.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return HibernateJavaEntityImpl.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = HibernateJavaEntityImpl.this.getParentEntity();
            return parentEntity.getPrimaryKeyColumnName();
        }
    }
}

