/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.core.context.java.JavaManyToOneRelationshipReference;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.GenericJavaManyToOneMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKey;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKeyHolder;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.NamingStrategyMappingTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaManyToOneRelationshipReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaManyToOneMapping
extends GenericJavaManyToOneMapping
implements ForeignKeyHolder {
    protected ForeignKey foreignKey;

    public HibernateJavaManyToOneMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    public String getJoinTableDefaultName() {
        return NamingStrategyMappingTools.buildJoinTableDefaultName((RelationshipMapping)this);
    }

    protected JavaManyToOneRelationshipReference buildRelationshipReference() {
        return new HibernateJavaManyToOneRelationshipReference((JavaManyToOneMapping)this);
    }

    public Iterator<String> supportingAnnotationNames() {
        return new CompositeIterator(super.supportingAnnotationNames(), (Object)"org.hibernate.annotations.ForeignKey");
    }

    protected HibernateJpaFactory getJpaFactory() {
        return (HibernateJpaFactory)super.getJpaFactory();
    }

    protected void initialize() {
        super.initialize();
        this.initializeForeignKey();
    }

    protected void update() {
        super.update();
        this.updateForeignKey();
    }

    protected void initializeForeignKey() {
        ForeignKeyAnnotation foreignKeyResource = this.getResourceForeignKey();
        if (foreignKeyResource != null) {
            this.foreignKey = this.buildForeignKey(foreignKeyResource);
        }
    }

    protected void updateForeignKey() {
        ForeignKeyAnnotation foreignKeyResource = this.getResourceForeignKey();
        if (foreignKeyResource == null) {
            if (this.getForeignKey() != null) {
                this.setForeignKey(null);
            }
        } else if (this.getForeignKey() == null) {
            this.setForeignKey(this.buildForeignKey(foreignKeyResource));
        } else {
            this.getForeignKey().update(foreignKeyResource);
        }
    }

    @Override
    public ForeignKey addForeignKey() {
        if (this.getForeignKey() != null) {
            throw new IllegalStateException("foreignKey already exists");
        }
        this.foreignKey = this.getJpaFactory().buildForeignKey((JavaJpaContextNode)this);
        ForeignKeyAnnotation foreignKeyResource = (ForeignKeyAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("org.hibernate.annotations.ForeignKey");
        this.foreignKey.initialize(foreignKeyResource);
        this.firePropertyChanged("foreignKey", null, this.foreignKey);
        return this.foreignKey;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    protected void setForeignKey(ForeignKey newForeignKey) {
        ForeignKey oldForeignKey = this.foreignKey;
        this.foreignKey = newForeignKey;
        this.firePropertyChanged("foreignKey", oldForeignKey, newForeignKey);
    }

    @Override
    public void removeForeignKey() {
        if (this.getForeignKey() == null) {
            throw new IllegalStateException("foreignKey does not exist, cannot be removed");
        }
        ForeignKey oldForeignKey = this.foreignKey;
        this.foreignKey = null;
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.ForeignKey");
        this.firePropertyChanged("foreignKey", oldForeignKey, null);
    }

    protected ForeignKey buildForeignKey(ForeignKeyAnnotation foreignKeyResource) {
        ForeignKey foreignKey = this.getJpaFactory().buildForeignKey((JavaJpaContextNode)this);
        foreignKey.initialize(foreignKeyResource);
        return foreignKey;
    }

    protected ForeignKeyAnnotation getResourceForeignKey() {
        return (ForeignKeyAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("org.hibernate.annotations.ForeignKey");
    }

    @Override
    public Table getForeignKeyDbTable() {
        return this.getTypeMapping().getPrimaryDbTable();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateForeignKey(messages, astRoot);
    }

    protected void validateForeignKey(List<IMessage> messages, CompilationUnit astRoot) {
        Table table = this.getTypeMapping().getPrimaryDbTable();
        if (!this.shouldValidateAgainstDatabase() || this.foreignKey == null || table == null) {
            return;
        }
        Iterator fks = table.foreignKeys();
        while (fks.hasNext()) {
            org.eclipse.jpt.db.ForeignKey fk = (org.eclipse.jpt.db.ForeignKey)fks.next();
            if (!this.foreignKey.getName().equals(fk.getIdentifier())) continue;
            return;
        }
        TextRange textRange = this.getResourceForeignKey().getNameTextRange(astRoot);
        HibernatePersistenceUnit.LocalMessage message = new HibernatePersistenceUnit.LocalMessage(1, "UNRESOLVED_FOREIGN_KEY_NAME", new String[]{this.foreignKey.getName(), this.getTypeMapping().getPrimaryTableName()}, this.foreignKey);
        message.setLineNo(textRange.getLineNumber());
        message.setOffset(textRange.getOffset());
        message.setLength(textRange.getLength());
        messages.add((IMessage)message);
    }
}

