/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.internal.context.java.GenericJavaSecondaryTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaSecondaryTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaSecondaryTableImpl
extends GenericJavaSecondaryTable
implements HibernateJavaSecondaryTable {
    public HibernateJavaSecondaryTableImpl(JavaEntity parent) {
        super(parent);
    }

    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName();
    }

    @Override
    public String getDefaultDBTableName() {
        return null;
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    protected void validateAgainstDatabase(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"SECONDARY_TABLE_UNRESOLVED_CATALOG", (String[])new String[]{this.getCatalog(), this.getDBTableName()}, (Object)this, (TextRange)this.getCatalogTextRange(astRoot)));
            return;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"SECONDARY_TABLE_UNRESOLVED_SCHEMA", (String[])new String[]{this.getSchema(), this.getDBTableName()}, (Object)this, (TextRange)this.getSchemaTextRange(astRoot)));
            return;
        }
        if (!this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"SECONDARY_TABLE_UNRESOLVED_NAME", (String[])new String[]{this.getDBTableName()}, (Object)this, (TextRange)this.getNameTextRange(astRoot)));
            return;
        }
    }
}

