/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.Parameter;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaGenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaParameter;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenericGeneratorImpl
extends AbstractJavaGenerator
implements JavaGenericGenerator,
Messages {
    private String strategy;
    protected final List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    protected GenericGeneratorAnnotation generatorResource;
    public static List<String> generatorClasses = new ArrayList<String>();

    static {
        generatorClasses.add("uuid");
        generatorClasses.add("hilo");
        generatorClasses.add("assigned");
        generatorClasses.add("identity");
        generatorClasses.add("select");
        generatorClasses.add("sequence");
        generatorClasses.add("seqhilo");
        generatorClasses.add("increment");
        generatorClasses.add("foreign");
        generatorClasses.add("guid");
        generatorClasses.add("uuid.hex");
        generatorClasses.add("sequence-identity");
    }

    public JavaGenericGeneratorImpl(JavaJpaContextNode parent) {
        super(parent);
    }

    protected GenericGeneratorAnnotation getResourceGenerator() {
        return this.generatorResource;
    }

    @Override
    public void initialize(GenericGeneratorAnnotation generator) {
        this.generatorResource = generator;
        this.name = generator.getName();
        this.strategy = generator.getStrategy();
        this.initializeParameters();
    }

    @Override
    public void update(GenericGeneratorAnnotation generator) {
        this.generatorResource = generator;
        this.setName_(generator.getName());
        this.setSpecifiedStrategy_(generator.getStrategy());
        this.updateParameters();
        this.getPersistenceUnit().addGenerator((Generator)this);
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.generatorResource.setName(name);
        this.firePropertyChanged("name", old, name);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.generatorResource.getTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.generatorResource.getNameTextRange(astRoot);
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(String strategy) {
        String oldStrategy = this.strategy;
        this.strategy = strategy;
        this.getResourceGenerator().setStrategy(strategy);
        this.firePropertyChanged("genericStrategyProperty", oldStrategy, strategy);
    }

    protected void setSpecifiedStrategy_(String strategy) {
        String oldStrategy = this.strategy;
        this.strategy = strategy;
        this.firePropertyChanged("genericStrategyProperty", oldStrategy, strategy);
    }

    protected String getCatalog() {
        return null;
    }

    protected String getSchema() {
        return null;
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateStrategy(messages, reporter, astRoot);
    }

    protected void validateStrategy(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.strategy != null) {
            int lineNum;
            int n = lineNum = this.getValidationTextRange(astRoot) == null ? 0 : this.getValidationTextRange(astRoot).getLineNumber();
            if (this.strategy.trim().length() == 0) {
                messages.add(this.creatErrorMessage("STRATEGY_CANT_BE_EMPTY", new String[0], lineNum));
            } else if (!generatorClasses.contains(this.strategy)) {
                IType lwType = null;
                try {
                    lwType = this.getJpaProject().getJavaProject().findType(this.strategy);
                    if (lwType == null || !lwType.isClass()) {
                        messages.add(this.creatErrorMessage("STRATEGY_CLASS_NOT_FOUND", new String[]{this.strategy}, lineNum));
                    } else if (!this.isImplementsIdentifierInterface(lwType)) {
                        messages.add(this.creatErrorMessage("STRATEGY_INTERFACE", new String[]{this.strategy}, lineNum));
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    protected boolean isImplementsIdentifierInterface(IType type) throws JavaModelException {
        IType parentType;
        if (type == null) {
            return false;
        }
        Object[] interfaces = type.getSuperInterfaceNames();
        if (Arrays.binarySearch(interfaces, "org.hibernate.id.IdentifierGenerator") >= 0) {
            return true;
        }
        if (type.getSuperclassName() != null && (parentType = this.getJpaProject().getJavaProject().findType(type.getSuperclassName())) != null) {
            return this.isImplementsIdentifierInterface(parentType);
        }
        return false;
    }

    protected IMessage creatErrorMessage(String strmessage, String[] params, int lineNum) {
        HibernatePersistenceUnit.LocalMessage message = new HibernatePersistenceUnit.LocalMessage(1, strmessage, params, this.getResource());
        message.setLineNo(lineNum);
        return message;
    }

    protected HibernateJpaFactory getJpaFactory() {
        return (HibernateJpaFactory)super.getJpaFactory();
    }

    @Override
    public JavaParameter addParameter(int index) {
        JavaParameter parameter = this.getJpaFactory().buildJavaParameter(this);
        this.parameters.add(index, parameter);
        this.getResourceGenerator().addParameter(index);
        this.fireItemAdded("parameters", index, parameter);
        return parameter;
    }

    protected void addParameter(int index, JavaParameter parameter) {
        this.addItemToList(index, parameter, this.parameters, "parameters");
    }

    protected void addParameter(JavaParameter parameter) {
        this.addParameter(this.parameters.size(), parameter);
    }

    @Override
    public void removeParameter(Parameter parameter) {
        this.removeParameter(this.parameters.indexOf(parameter));
    }

    @Override
    public void removeParameter(int index) {
        JavaParameter removedParameter = this.parameters.remove(index);
        this.getResourceGenerator().removeParameter(index);
        this.fireItemRemoved("parameters", index, removedParameter);
    }

    protected void removeParameter_(JavaParameter parameter) {
        this.removeItemFromList(parameter, this.parameters, "parameters");
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.parameters, (int)targetIndex, (int)sourceIndex);
        this.getResourceGenerator().moveParameter(targetIndex, sourceIndex);
        this.fireItemMoved("parameters", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaParameter> parameters() {
        return new CloneListIterator(this.parameters);
    }

    @Override
    public int parametersSize() {
        return this.parameters.size();
    }

    protected void initializeParameters() {
        ListIterator<ParameterAnnotation> resourceParameters = this.generatorResource.parameters();
        while (resourceParameters.hasNext()) {
            this.parameters.add(this.createParameter(resourceParameters.next()));
        }
    }

    protected void updateParameters() {
        ListIterator<JavaParameter> contextParameters = this.parameters();
        ListIterator<ParameterAnnotation> resourceParameters = this.generatorResource.parameters();
        while (contextParameters.hasNext()) {
            JavaParameter parameter = contextParameters.next();
            if (resourceParameters.hasNext()) {
                parameter.update(resourceParameters.next());
                continue;
            }
            this.removeParameter_(parameter);
        }
        while (resourceParameters.hasNext()) {
            this.addParameter(this.createParameter(resourceParameters.next()));
        }
    }

    protected JavaParameter createParameter(ParameterAnnotation resourceParameter) {
        JavaParameter parameter = this.getJpaFactory().buildJavaParameter(this);
        parameter.initialize(resourceParameter);
        return parameter;
    }

    public int getDefaultInitialValue() {
        return GenericGenerator.DEFAULT_INITIAL_VALUE;
    }
}

