/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmIdMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateOrmIdMappingImpl
extends GenericOrmIdMapping<XmlId>
implements HibernateOrmIdMapping {
    public HibernateOrmIdMappingImpl(OrmPersistentAttribute parent, XmlId resourceMapping) {
        super(parent, resourceMapping);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public String getDefaultColumnName() {
        NamingStrategy namingStrategy = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && namingStrategy != null && this.getName() != null) {
            try {
                return namingStrategy.propertyToColumnName(this.getName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return super.getDefaultColumnName();
    }

    public HibernateOrmColumn getColumn() {
        return (HibernateOrmColumn)this.column;
    }

    public String getPrimaryKeyColumnName() {
        return this.getColumn().getDBColumnName();
    }

    protected void validateColumn(List<IMessage> messages) {
        OrmPersistentAttribute pa = this.getPersistentAttribute();
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", (String[])new String[]{pa.getName(), tableName, this.getColumn().getDBColumnName()}, (Object)this.column, (TextRange)this.column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"COLUMN_UNRESOLVED_TABLE", (String[])new String[]{tableName, this.getColumn().getDBColumnName()}, (Object)this.column, (TextRange)this.column.getTableTextRange()));
            }
            return;
        }
        if (!this.column.isResolved() && this.column.getDbTable() != null) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", (String[])new String[]{pa.getName(), this.getColumn().getDBColumnName()}, (Object)this.column, (TextRange)this.column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getColumn().getDBColumnName()}, (Object)this.column, (TextRange)this.column.getNameTextRange()));
            }
        }
    }
}

