/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.NamingStrategyMappingTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmJoinColumn;

public class HibernateOrmJoinColumnImpl
extends GenericOrmJoinColumn
implements HibernateOrmJoinColumn {
    public HibernateOrmJoinColumnImpl(XmlContextNode parent, OrmJoinColumn.Owner owner, XmlJoinColumn resourceJoinColumn) {
        super(parent, owner, resourceJoinColumn);
    }

    protected String getOwnerDefaultColumnName() {
        return NamingStrategyMappingTools.buildJoinColumnDefaultName(this);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getDBColumnName());
    }

    public String getDBColumnName() {
        return this.getSpecifiedDBColumnName() != null ? this.getSpecifiedDBColumnName() : this.getDefaultDBColumnName();
    }

    public String getDefaultDBColumnName() {
        return this.getDefaultName();
    }

    public String getSpecifiedDBColumnName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedName();
    }

    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedDBColumnName());
    }

    public String getReferencedDBColumnName() {
        return this.getReferencedSpecifiedDBColumnName() != null ? this.getReferencedSpecifiedDBColumnName() : this.getReferencedDefaultDBColumnName();
    }

    public String getReferencedDefaultDBColumnName() {
        return this.defaultReferencedColumnName;
    }

    public String getReferencedSpecifiedDBColumnName() {
        if (this.specifiedReferencedColumnName == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.specifiedReferencedColumnName);
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.specifiedReferencedColumnName;
    }

    public PersistentAttribute getReferencedPersistentAttribute() {
        Iterator attributes;
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (this.getOwner().joinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = this.getOwner().getTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        PersistentAttribute pAttr = null;
        Iterator stream = attributes = targetEntity.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            PersistentAttribute attribute = (PersistentAttribute)stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (name == null) continue;
            if (pAttr == null) {
                pAttr = attribute;
                continue;
            }
            return null;
        }
        return pAttr;
    }
}

