/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenerationTime;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GeneratedAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedAnnotationImpl
extends SourceAnnotation<Attribute>
implements GeneratedAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.Generated");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = GeneratedAnnotationImpl.buildValueAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private final AnnotationElementAdapter<String> valueAdapter = this.buildAdapter(VALUE_ADAPTER);
    private GenerationTime value;

    protected GeneratedAnnotationImpl(JavaResourceNode parent, Attribute attribute) {
        super(parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
    }

    @Override
    public GenerationTime getValue() {
        return this.value;
    }

    @Override
    public void setValue(GenerationTime value) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)value)) {
            return;
        }
        GenerationTime old = this.value;
        this.value = value;
        this.valueAdapter.setValue((Object)GenerationTime.toJavaAnnotationValue(value));
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private GenerationTime buildValue(CompilationUnit astRoot) {
        return GenerationTime.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Generated";
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return new EnumDeclarationAnnotationElementAdapter(adapter, "value");
    }

    public static class GeneratedAnnotationDefinition
    implements AnnotationDefinition {
        private static final GeneratedAnnotationDefinition INSTANCE = new GeneratedAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private GeneratedAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member attribute) {
            return new GeneratedAnnotationImpl((JavaResourceNode)parent, (Attribute)attribute);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.Generated";
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent) {
            throw new UnsupportedOperationException();
        }
    }
}

