/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateNamedNativeQueryAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSourceNamedNativeQueryAnnotation
extends SourceAnnotation<Member>
implements HibernateNamedNativeQueryAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.NamedNativeQuery");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    private final AnnotationElementAdapter<String> queryAdapter;
    private String query;
    private final DeclarationAnnotationElementAdapter<String> flushModeDeclarationAdapter;
    private final AnnotationElementAdapter<String> flushModeAdapter;
    private FlushModeType flushMode;
    private final DeclarationAnnotationElementAdapter<String> cacheModeDeclarationAdapter;
    private final AnnotationElementAdapter<String> cacheModeAdapter;
    private CacheModeType cacheMode;
    private final DeclarationAnnotationElementAdapter<Boolean> cacheableDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> cacheableAdapter;
    private Boolean cacheable;
    private final DeclarationAnnotationElementAdapter<String> cacheRegionDeclarationAdapter;
    private final AnnotationElementAdapter<String> cacheRegionAdapter;
    private String cacheRegion;
    private final DeclarationAnnotationElementAdapter<Integer> fetchSizeDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> fetchSizeAdapter;
    private Integer fetchSize;
    private final DeclarationAnnotationElementAdapter<Integer> timeoutDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> timeoutAdapter;
    private Integer timeout;
    private final DeclarationAnnotationElementAdapter<String> commentDeclarationAdapter;
    private final AnnotationElementAdapter<String> commentAdapter;
    private String comment;
    private final DeclarationAnnotationElementAdapter<Boolean> readOnlyDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> readOnlyAdapter;
    private Boolean readOnly;
    private final DeclarationAnnotationElementAdapter<Boolean> callableDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> callableAdapter;
    private Boolean callable;
    private final DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter;
    private final AnnotationElementAdapter<String> resultClassAdapter;
    private String resultClass;
    private String fullyQualifiedResultClassName;
    private final DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private final AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;

    HibernateSourceNamedNativeQueryAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryDeclarationAdapter = this.buildQueryAdapter(daa);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
        this.flushModeDeclarationAdapter = this.buildFlushModeAdapter(daa);
        this.flushModeAdapter = new ShortCircuitAnnotationElementAdapter(member, this.flushModeDeclarationAdapter);
        this.cacheModeDeclarationAdapter = this.buildCacheModeAdapter(daa);
        this.cacheModeAdapter = new ShortCircuitAnnotationElementAdapter(member, this.cacheModeDeclarationAdapter);
        this.cacheableDeclarationAdapter = this.buildCacheableAdapter(daa);
        this.cacheableAdapter = new ShortCircuitAnnotationElementAdapter(member, this.cacheableDeclarationAdapter);
        this.cacheRegionDeclarationAdapter = this.buildCacheRegionAdapter(daa);
        this.cacheRegionAdapter = this.buildAdapter(this.cacheRegionDeclarationAdapter);
        this.fetchSizeDeclarationAdapter = this.buildFetchSizeAdapter(daa);
        this.fetchSizeAdapter = new ShortCircuitAnnotationElementAdapter(member, this.fetchSizeDeclarationAdapter);
        this.timeoutDeclarationAdapter = this.buildTimeoutAdapter(daa);
        this.timeoutAdapter = new ShortCircuitAnnotationElementAdapter(member, this.timeoutDeclarationAdapter);
        this.commentDeclarationAdapter = this.buildCommentAdapter(daa);
        this.commentAdapter = new ShortCircuitAnnotationElementAdapter(member, this.commentDeclarationAdapter);
        this.readOnlyDeclarationAdapter = this.buildReadOnlyAdapter(daa);
        this.readOnlyAdapter = new ShortCircuitAnnotationElementAdapter(member, this.readOnlyDeclarationAdapter);
        this.callableDeclarationAdapter = this.buildReadOnlyAdapter(daa);
        this.callableAdapter = new ShortCircuitAnnotationElementAdapter(member, this.callableDeclarationAdapter);
        this.resultClassDeclarationAdapter = this.buildResultClassAdapter(daa);
        this.resultClassAdapter = this.buildAdapter(this.resultClassDeclarationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter(daa);
        this.resultSetMappingAdapter = this.buildAdapter(this.resultSetMappingDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.query = this.buildQuery(astRoot);
        this.flushMode = this.buildFlushMode(astRoot);
        this.cacheMode = this.buildCacheMode(astRoot);
        this.cacheable = this.buildCacheable(astRoot);
        this.cacheRegion = this.buildCacheRegion(astRoot);
        this.fetchSize = this.buildFetchSize(astRoot);
        this.timeout = this.buildTimeout(astRoot);
        this.comment = this.buildComment(astRoot);
        this.readOnly = this.buildReadOnly(astRoot);
        this.callable = this.buildCallable(astRoot);
        this.resultClass = this.buildResultClass(astRoot);
        this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName(astRoot);
        this.resultSetMapping = this.buildResultSetMapping(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setQuery(this.buildQuery(astRoot));
        this.setFlushMode(this.buildFlushMode(astRoot));
        this.setCacheMode(this.buildCacheMode(astRoot));
        this.setCacheable(this.buildCacheable(astRoot));
        this.setCacheRegion(this.buildCacheRegion(astRoot));
        this.setFetchSize(this.buildFetchSize(astRoot));
        this.setTimeout(this.buildTimeout(astRoot));
        this.setComment(this.buildComment(astRoot));
        this.setReadOnly(this.buildReadOnly(astRoot));
        this.setCallable(this.buildCallable(astRoot));
        this.setResultClass(this.buildResultClass(astRoot));
        this.setFullyQualifiedResultClassName(this.buildFullyQualifiedResultClassName(astRoot));
        this.setResultSetMapping(this.buildResultSetMapping(astRoot));
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.NamedNativeQuery";
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue((Object)name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        if (this.attributeValueHasNotChanged(this.query, query)) {
            return;
        }
        String old = this.query;
        this.query = query;
        this.queryAdapter.setValue((Object)query);
        this.firePropertyChanged("query", old, query);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return (String)this.queryAdapter.getValue(astRoot);
    }

    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    String getQueryElementName() {
        return "query";
    }

    public ListIterator<QueryHintAnnotation> hints() {
        return EmptyListIterator.instance();
    }

    ListIterator<NestableQueryHintAnnotation> nestableHints() {
        return EmptyListIterator.instance();
    }

    public int hintsSize() {
        return 0;
    }

    public NestableQueryHintAnnotation hintAt(int index) {
        throw new UnsupportedOperationException();
    }

    public int indexOfHint(QueryHintAnnotation queryHint) {
        return -1;
    }

    public NestableQueryHintAnnotation addHint(int index) {
        return null;
    }

    public void moveHint(int targetIndex, int sourceIndex) {
    }

    public void removeHint(int index) {
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        if (this.attributeValueHasNotChanged((Object)this.flushMode, (Object)flushMode)) {
            return;
        }
        FlushModeType old = this.flushMode;
        this.flushMode = flushMode;
        this.flushModeAdapter.setValue((Object)FlushModeType.toJavaAnnotationValue(flushMode));
        this.firePropertyChanged("flushMode", (Object)old, (Object)flushMode);
    }

    private FlushModeType buildFlushMode(CompilationUnit astRoot) {
        return FlushModeType.fromJavaAnnotationValue(this.flushModeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFlushModeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.flushModeDeclarationAdapter, astRoot);
    }

    @Override
    public CacheModeType getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheModeType cacheMode) {
        if (this.attributeValueHasNotChanged((Object)this.cacheMode, (Object)cacheMode)) {
            return;
        }
        CacheModeType old = this.cacheMode;
        this.cacheMode = cacheMode;
        this.cacheModeAdapter.setValue((Object)CacheModeType.toJavaAnnotationValue(cacheMode));
        this.firePropertyChanged("cacheMode", (Object)old, (Object)cacheMode);
    }

    private CacheModeType buildCacheMode(CompilationUnit astRoot) {
        return CacheModeType.fromJavaAnnotationValue(this.cacheModeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getCacheModeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.cacheModeDeclarationAdapter, astRoot);
    }

    @Override
    public Boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public void setCacheable(Boolean cacheable) {
        if (this.attributeValueHasNotChanged(this.cacheable, cacheable)) {
            return;
        }
        Boolean old = this.cacheable;
        this.cacheable = cacheable;
        this.cacheableAdapter.setValue((Object)cacheable);
        this.firePropertyChanged("cacheable", old, cacheable);
    }

    private Boolean buildCacheable(CompilationUnit astRoot) {
        return (Boolean)this.cacheableAdapter.getValue(astRoot);
    }

    @Override
    public String getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public void setCacheRegion(String cacheRegion) {
        if (this.attributeValueHasNotChanged(this.cacheRegion, cacheRegion)) {
            return;
        }
        String old = this.cacheRegion;
        this.cacheRegion = cacheRegion;
        this.cacheRegionAdapter.setValue((Object)cacheRegion);
        this.firePropertyChanged("cacheRegion", old, cacheRegion);
    }

    private String buildCacheRegion(CompilationUnit astRoot) {
        return (String)this.cacheRegionAdapter.getValue(astRoot);
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(Integer fetchSize) {
        if (this.attributeValueHasNotChanged(this.fetchSize, fetchSize)) {
            return;
        }
        Integer old = this.fetchSize;
        this.fetchSize = fetchSize;
        this.fetchSizeAdapter.setValue((Object)fetchSize);
        this.firePropertyChanged("fetchSize", old, fetchSize);
    }

    private Integer buildFetchSize(CompilationUnit astRoot) {
        return (Integer)this.fetchSizeAdapter.getValue(astRoot);
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer timeout) {
        if (this.attributeValueHasNotChanged(this.timeout, timeout)) {
            return;
        }
        Integer old = this.timeout;
        this.timeout = timeout;
        this.timeoutAdapter.setValue((Object)timeout);
        this.firePropertyChanged("timeout", old, timeout);
    }

    private Integer buildTimeout(CompilationUnit astRoot) {
        return (Integer)this.timeoutAdapter.getValue(astRoot);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        if (this.attributeValueHasNotChanged(this.comment, comment)) {
            return;
        }
        String old = this.comment;
        this.comment = comment;
        this.commentAdapter.setValue((Object)comment);
        this.firePropertyChanged("comment", old, comment);
    }

    private String buildComment(CompilationUnit astRoot) {
        return (String)this.commentAdapter.getValue(astRoot);
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        if (this.attributeValueHasNotChanged(this.readOnly, readOnly)) {
            return;
        }
        Boolean old = this.readOnly;
        this.readOnly = readOnly;
        this.readOnlyAdapter.setValue((Object)readOnly);
        this.firePropertyChanged("readOnly", old, readOnly);
    }

    private Boolean buildReadOnly(CompilationUnit astRoot) {
        return (Boolean)this.readOnlyAdapter.getValue(astRoot);
    }

    @Override
    public Boolean isCallable() {
        return this.callable;
    }

    @Override
    public void setCallable(Boolean callable) {
        if (this.attributeValueHasNotChanged(this.callable, callable)) {
            return;
        }
        Boolean old = this.callable;
        this.callable = callable;
        this.callableAdapter.setValue((Object)callable);
        this.firePropertyChanged("callable", old, callable);
    }

    private Boolean buildCallable(CompilationUnit astRoot) {
        return (Boolean)this.callableAdapter.getValue(astRoot);
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(String resultClass) {
        if (this.attributeValueHasNotChanged(this.resultClass, resultClass)) {
            return;
        }
        String old = this.resultClass;
        this.resultClass = resultClass;
        this.resultClassAdapter.setValue((Object)resultClass);
        this.firePropertyChanged("resultClass", old, resultClass);
    }

    private String buildResultClass(CompilationUnit astRoot) {
        return (String)this.resultClassAdapter.getValue(astRoot);
    }

    public TextRange getResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astRoot);
    }

    public String getFullyQualifiedResultClassName() {
        return this.fullyQualifiedResultClassName;
    }

    private void setFullyQualifiedResultClassName(String name) {
        String old = this.fullyQualifiedResultClassName;
        this.fullyQualifiedResultClassName = name;
        this.firePropertyChanged("fullyQualifiedResultClassName", old, name);
    }

    private String buildFullyQualifiedResultClassName(CompilationUnit astRoot) {
        return this.resultClass == null ? null : JDTTools.resolveFullyQualifiedName((Expression)this.resultClassAdapter.getExpression(astRoot));
    }

    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    public void setResultSetMapping(String resultSetMapping) {
        if (this.attributeValueHasNotChanged(this.resultSetMapping, resultSetMapping)) {
            return;
        }
        String old = this.resultSetMapping;
        this.resultSetMapping = resultSetMapping;
        this.resultSetMappingAdapter.setValue((Object)resultSetMapping);
        this.firePropertyChanged("resultSetMapping", old, resultSetMapping);
    }

    private String buildResultSetMapping(CompilationUnit astRoot) {
        return (String)this.resultSetMappingAdapter.getValue(astRoot);
    }

    public TextRange getResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        HibernateSourceNamedNativeQueryAnnotation oldQuery = (HibernateSourceNamedNativeQueryAnnotation)oldAnnotation;
        this.setName(oldQuery.getName());
        this.setQuery(oldQuery.getQuery());
        this.setFlushMode(oldQuery.getFlushMode());
        this.setCacheMode(oldQuery.getCacheMode());
        this.setCacheable(oldQuery.isCacheable());
        this.setComment(oldQuery.getComment());
        this.setFetchSize(oldQuery.getFetchSize());
        this.setTimeout(oldQuery.getTimeout());
        this.setCacheRegion(oldQuery.getCacheRegion());
        this.setReadOnly(oldQuery.isReadOnly());
        this.setCallable(oldQuery.isCallable());
        this.setResultClass(oldQuery.getResultClass());
        this.setResultSetMapping(oldQuery.getResultSetMapping());
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public static HibernateNamedNativeQueryAnnotation createNamedNativeQuery(JavaResourceNode parent, Member member) {
        return new HibernateSourceNamedNativeQueryAnnotation(parent, member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER));
    }

    protected DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"name");
    }

    protected DeclarationAnnotationElementAdapter<String> buildQueryAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"query");
    }

    protected DeclarationAnnotationElementAdapter<String> buildFlushModeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new EnumDeclarationAnnotationElementAdapter(daAdapter, "flushMode");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCacheModeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new EnumDeclarationAnnotationElementAdapter(daAdapter, "cacheMode");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildCacheableAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"cacheable");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCacheRegionAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"cacheRegion");
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildFetchSizeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daAdapter, (String)"fetchSize");
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildTimeoutAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daAdapter, (String)"timeout");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCommentAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"comment");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildReadOnlyAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"readOnly");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildCallableAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"callable");
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter(daAdapter, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"resultSetMapping");
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    public static HibernateSourceNamedNativeQueryAnnotation createHibernateNamedNativeQuery(JavaResourceNode parent, Member member) {
        return new HibernateSourceNamedNativeQueryAnnotation(parent, member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER));
    }

    public static HibernateSourceNamedNativeQueryAnnotation createNestedHibernateNamedNativeQuery(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = HibernateSourceNamedNativeQueryAnnotation.buildNestedHibernateDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new HibernateSourceNamedNativeQueryAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedHibernateDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter hibernateNamedNativeQueriesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(hibernateNamedNativeQueriesAdapter, index, "org.hibernate.annotations.NamedNativeQuery");
    }
}

