/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.NestableParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceParameterAnnotation
extends SourceAnnotation<Member>
implements NestableParameterAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    public SourceParameterAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
        this.nameDeclarationAdapter = this.buildNameAdapter((DeclarationAnnotationAdapter)idaa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.valueAdapter = this.buildAdapter(this.valueDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Parameter";
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"value");
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.value = this.buildValue(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setValue(this.buildValue(astRoot));
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue((Object)name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasNotChanged(this.value, value)) {
            return;
        }
        String old = this.value;
        this.value = value;
        this.valueAdapter.setValue((Object)value);
        this.firePropertyChanged("value", old, value);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        ParameterAnnotation oldParameter = (ParameterAnnotation)oldAnnotation;
        this.setName(oldParameter.getName());
        this.setValue(oldParameter.getValue());
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    public static SourceParameterAnnotation createGenericGeneratorParameter(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter genericGeneratorAdapter, int index) {
        return new SourceParameterAnnotation(parent, member, SourceParameterAnnotation.buildGenericGeneratorParameterAnnotationAdapter(genericGeneratorAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildGenericGeneratorParameterAnnotationAdapter(DeclarationAnnotationAdapter genericGeneratorAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(genericGeneratorAdapter, "parameters", index, "org.hibernate.annotations.Parameter");
    }
}

