/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewHibernateMappingPreviewPage
extends PreviewWizardPage {
    public static final String HIBERNATE_NEW_HBM_XML_FOLDER_NAME = "hibernateNewHbmXml";
    protected IPath rootPlace2GenBase = null;
    protected IPath rootPlace2Gen = null;
    protected Map<IJavaProject, IPath> places2Gen;
    protected Set<IPath> paths2Disconnect = new HashSet<IPath>();

    public NewHibernateMappingPreviewPage() {
        super(true);
    }

    public void dispose() {
        this.performDisconnect();
        IPath place2Gen = this.getRootPlace2Gen();
        if (place2Gen != null) {
            File folder2Gen = new File(place2Gen.toOSString());
            FileUtils.delete((File)folder2Gen);
        }
        super.dispose();
    }

    public void setPlaces2Gen(Map<IJavaProject, IPath> places2Gen) {
        this.places2Gen = places2Gen;
        this.updateChanges();
    }

    public Set<IJavaProject> getJavaProjects() {
        if (this.places2Gen == null) {
            return new HashSet<IJavaProject>();
        }
        return this.places2Gen.keySet();
    }

    protected void performDisconnect() {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        for (IPath filePathTo_Show : this.paths2Disconnect) {
            try {
                bufferManager.disconnect(filePathTo_Show, LocationKind.IFILE, null);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
            }
        }
        this.paths2Disconnect.clear();
    }

    protected void performCommit() {
        CompositeChange cc = (CompositeChange)this.getChange();
        if (cc == null) {
            return;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        Change[] changes = cc.getChildren();
        int i = 0;
        while (i < changes.length) {
            TextFileChange tfc;
            Change change = changes[i];
            if (change instanceof TextFileChange && (tfc = (TextFileChange)change).isEnabled() && tfc.getEdit() != null) {
                Path path = new Path(tfc.getName());
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer((IPath)path, LocationKind.IFILE);
                IDocument document = textFileBuffer.getDocument();
                try {
                    tfc.getEdit().apply(document);
                }
                catch (MalformedTreeException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("MalformedTreeException: ", (Throwable)e);
                }
                catch (BadLocationException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("BadLocationException: ", (Throwable)e);
                }
                try {
                    textFileBuffer.commit(null, true);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected String readInto(File fileSrc) {
        StringBuilder str;
        block27: {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            str = new StringBuilder();
            try {
                try {
                    fis = new FileInputStream(fileSrc);
                    bis = new BufferedInputStream(fis);
                    byte[] buff = new byte[16384];
                    while (true) {
                        int n = -1;
                        try {
                            n = bis.read(buff);
                        }
                        catch (IOException e) {
                            HibernateConsolePlugin.getDefault().log((Throwable)e);
                        }
                        if (n != -1) {
                            str.append(new String(buff, 0, n));
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    HibernateConsolePlugin.getDefault().log((Throwable)e);
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return str.toString();
    }

    public IPath getRootPlace2GenBase() {
        if (this.rootPlace2GenBase != null) {
            return this.rootPlace2GenBase;
        }
        String systemTmpDir = System.getProperty("java.io.tmpdir");
        this.rootPlace2GenBase = new Path(systemTmpDir);
        this.rootPlace2GenBase = this.rootPlace2GenBase.append(HIBERNATE_NEW_HBM_XML_FOLDER_NAME);
        return this.rootPlace2GenBase;
    }

    public IPath getRootPlace2Gen() {
        if (this.rootPlace2Gen != null) {
            return this.rootPlace2Gen;
        }
        this.rootPlace2Gen = this.getRootPlace2GenBase();
        String uuidName = UUID.randomUUID().toString();
        this.rootPlace2Gen = this.rootPlace2Gen.append(uuidName);
        return this.rootPlace2Gen;
    }

    protected boolean updateOneChange(CompositeChange cc, IJavaProject proj, File fileSrc) {
        if (!fileSrc.exists()) {
            return false;
        }
        if (fileSrc.isDirectory()) {
            return false;
        }
        IPath basePath = proj.getResource().getParent().getLocation();
        IPath projPath = proj.getResource().getLocation();
        IPath place2Gen = this.getRootPlace2Gen().append(proj.getElementName());
        Path filePathFrom = new Path(fileSrc.getPath());
        IPath filePathTo = filePathFrom.makeRelativeTo(place2Gen);
        filePathTo = projPath.append(filePathTo);
        IPath filePathTo_Show = filePathTo.makeRelativeTo(basePath);
        File fileOrig = filePathTo.toFile();
        if (fileOrig.exists()) {
            final IPath filePathTo_Proj = filePathTo.makeRelativeTo(projPath);
            class ResHolder {
                public IResource res2Update = null;

                ResHolder() {
                }
            }
            final ResHolder res2UpdateHolder = new ResHolder();
            IResourceVisitor visitor = new IResourceVisitor(){
                {
                }

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getProjectRelativePath().equals((Object)filePathTo_Proj)) {
                        res2UpdateHolder.res2Update = resource;
                        return false;
                    }
                    return resource.getProjectRelativePath().isPrefixOf(filePathTo_Proj);
                }
            };
            try {
                proj.getResource().accept(visitor);
            }
            catch (CoreException coreException) {}
            if (res2UpdateHolder.res2Update != null) {
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(filePathTo_Show, LocationKind.IFILE);
                if (textFileBuffer == null) {
                    try {
                        bufferManager.connect(filePathTo_Show, LocationKind.IFILE, null);
                        this.paths2Disconnect.add(filePathTo_Show);
                    }
                    catch (CoreException e) {
                        HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
                    }
                    textFileBuffer = bufferManager.getTextFileBuffer(filePathTo_Show, LocationKind.IFILE);
                }
                if (textFileBuffer != null) {
                    IDocument documentChange = textFileBuffer.getDocument();
                    String str = this.readInto(fileSrc);
                    ReplaceEdit textEdit = new ReplaceEdit(0, documentChange.getLength(), str.toString());
                    TextFileChange change = new TextFileChange(filePathTo_Show.toString(), (IFile)res2UpdateHolder.res2Update);
                    change.setSaveMode(4);
                    change.setEdit((TextEdit)textEdit);
                    cc.add((Change)change);
                }
            }
        } else {
            String str = this.readInto(fileSrc);
            CreateTextFileChange change = new CreateTextFileChange(filePathTo_Show, str.toString(), null, "hbm.xml");
            cc.add((Change)change);
        }
        return true;
    }

    protected void updateChanges(CompositeChange cc, IJavaProject proj, File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            this.updateOneChange(cc, proj, dir);
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.updateChanges(cc, proj, files[i]);
            } else {
                this.updateOneChange(cc, proj, files[i]);
            }
            ++i;
        }
    }

    protected void updateChanges() {
        this.performDisconnect();
        CompositeChange cc = new CompositeChange("");
        for (Map.Entry<IJavaProject, IPath> entry : this.places2Gen.entrySet()) {
            this.updateChanges(cc, entry.getKey(), entry.getValue().toFile());
        }
        cc.markAsSynthetic();
        this.setChange((Change)cc);
    }

    public boolean performFinish() {
        if (this.getChange() == null) {
            return false;
        }
        this.performCommit();
        try {
            this.getChange().perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
        }
        this.performDisconnect();
        return true;
    }
}

