/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;

public class BuildSessionFactoryAction
extends ConsoleConfigurationBasedAction {
    private final StructuredViewer viewer;

    public BuildSessionFactoryAction(StructuredViewer viewer) {
        super(HibernateConsoleMessages.BuildSessionFactoryAction_build_session_factory);
        this.viewer = viewer;
        this.setEnabledWhenNoSessionFactory(true);
    }

    protected void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                ConsoleConfiguration config = (ConsoleConfiguration)node;
                if (config.isSessionFactoryCreated()) {
                    config.reset();
                } else {
                    config.build();
                    config.buildSessionFactory();
                }
                this.updateState(config);
            }
            catch (HibernateConsoleRuntimeException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.BuildSessionFactoryAction_exception_while_start_hibernate, he);
            }
            catch (UnsupportedClassVersionError ucve) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.BuildSessionFactoryAction_start_hibernate_resulted, ucve);
            }
        }
    }

    protected boolean updateState(ConsoleConfiguration config) {
        this.setEnabledWhenNoSessionFactory(!config.isSessionFactoryCreated());
        if (this.enabledWhenNoSessionFactory) {
            this.setText(HibernateConsoleMessages.BuildSessionFactoryAction_create_sessionfactory);
        } else {
            this.setText(HibernateConsoleMessages.BuildSessionFactoryAction_close_sessionfactory);
        }
        return super.updateState(config);
    }
}

