/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class SchemaExportAction
extends ConsoleConfigurationBasedAction {
    public static final String SCHEMAEXPORT_ACTIONID = "actionid.schemaexport";
    private StructuredViewer viewer;

    protected SchemaExportAction(String text) {
        super(text);
        this.setId(SCHEMAEXPORT_ACTIONID);
    }

    public SchemaExportAction(StructuredViewer selectionProvider) {
        super(HibernateConsoleMessages.SchemaExportAction_run_schemaexport);
        this.viewer = selectionProvider;
        this.setId(SCHEMAEXPORT_ACTIONID);
    }

    public void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                final ConsoleConfiguration config = (ConsoleConfiguration)node;
                config.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        String out = NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_sure_run_schemaexport, (Object)config.getName());
                        if (config.getConfiguration() != null && MessageDialog.openConfirm((Shell)SchemaExportAction.this.viewer.getControl().getShell(), (String)HibernateConsoleMessages.SchemaExportAction_run_schemaexport, (String)out)) {
                            SchemaExport export = new SchemaExport(config.getConfiguration());
                            export.create(false, true);
                            if (!export.getExceptions().isEmpty()) {
                                Iterator iterator = export.getExceptions().iterator();
                                int cnt = 1;
                                while (iterator.hasNext()) {
                                    Throwable element = (Throwable)iterator.next();
                                    String outStr = NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_errornum_while_performing_schemaexport, (Object)cnt++);
                                    HibernateConsolePlugin.getDefault().logErrorMessage(outStr, element);
                                }
                                HibernateConsolePlugin.getDefault().showError(SchemaExportAction.this.viewer.getControl().getShell(), NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_error_while_performing_schemaexport, (Object)(cnt - 1)), (Throwable)null);
                            }
                        }
                        return null;
                    }
                });
                this.viewer.refresh(node);
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.SchemaExportAction_exception_running_schemaexport, he);
            }
        }
    }

    protected boolean updateState(ConsoleConfiguration consoleConfiguration) {
        return consoleConfiguration.hasConfiguration();
    }
}

