/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class TreeToTableComposite
extends Composite {
    private Group dbgroup = null;
    private Composite manipulationGroup = null;
    protected Tree tree = null;
    private Group tableFiltersGroup = null;
    protected Table rightTable = null;
    private Button upButton = null;
    private Button downButton = null;
    private Button removeButton = null;
    private Button removeAllButton = null;
    private Label fillLabel = null;
    private Composite composite = null;
    private Label label = null;
    private Button refreshButton = null;
    private Label emptyLabel = null;
    private Button[] addButtons;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget button = e.widget;
            int i = 0;
            while (i < TreeToTableComposite.this.addButtons.length) {
                Button but = TreeToTableComposite.this.addButtons[i];
                if (button == but) {
                    TreeToTableComposite.this.handleAddButtonPressed(i);
                }
                ++i;
            }
        }
    };

    public TreeToTableComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    protected void handleAddButtonPressed(int i) {
    }

    protected void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.createDbgroup();
        this.setLayout((Layout)gridLayout);
        this.createIncludeExcludeGroup();
        this.createTableFiltersGroup();
        this.createComposite();
        this.setSize(new Point(913, 358));
        this.label = new Label((Composite)this, 0);
    }

    private void createDbgroup() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalIndent = 0;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        this.dbgroup = new Group((Composite)this, 0);
        this.dbgroup.setText(this.getTreeTitle());
        this.dbgroup.setLayout((Layout)new FillLayout());
        this.createTree();
        this.dbgroup.setLayoutData((Object)gridData);
    }

    protected String getTreeTitle() {
        return HibernateConsoleMessages.TreeToTableComposite_database_schema;
    }

    private void createIncludeExcludeGroup() {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.verticalSpan = 1;
        gridData6.horizontalSpan = 1;
        gridData6.grabExcessVerticalSpace = false;
        gridData6.heightHint = 24;
        gridData6.verticalAlignment = 4;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.marginWidth = 5;
        gridLayout1.marginHeight = 5;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 1;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.verticalAlignment = 2;
        this.manipulationGroup = new Composite((Composite)this, 0);
        this.manipulationGroup.setLayoutData((Object)gridData1);
        this.manipulationGroup.setLayout((Layout)gridLayout1);
        this.createAddButtons(this.manipulationGroup);
        this.fillLabel = new Label(this.manipulationGroup, 0);
        this.fillLabel.setText("");
        this.fillLabel.setLayoutData((Object)gridData6);
        this.upButton = new Button(this.manipulationGroup, 0);
        this.upButton.setText(HibernateConsoleMessages.TreeToTableComposite_up);
        this.upButton.setLayoutData((Object)gridData5);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToTableComposite.this.doMoveUp();
            }
        });
        this.downButton = new Button(this.manipulationGroup, 0);
        this.downButton.setText(HibernateConsoleMessages.TreeToTableComposite_down);
        this.downButton.setLayoutData((Object)gridData4);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToTableComposite.this.doMoveDown();
            }
        });
        this.removeButton = new Button(this.manipulationGroup, 0);
        this.removeButton.setText(HibernateConsoleMessages.TreeToTableComposite_remove);
        this.removeButton.setLayoutData((Object)gridData3);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToTableComposite.this.doRemove();
            }
        });
        this.removeAllButton = new Button(this.manipulationGroup, 0);
        this.removeAllButton.setText(HibernateConsoleMessages.TreeToTableComposite_remove_all);
        this.removeAllButton.setLayoutData((Object)gridData3);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToTableComposite.this.doRemoveAll();
            }
        });
    }

    private void createAddButtons(Composite parent) {
        String[] addButtonLabels = this.getAddButtonLabels();
        this.addButtons = new Button[addButtonLabels.length];
        int i = 0;
        while (i < addButtonLabels.length) {
            String label = addButtonLabels[i];
            this.addButtons[i] = this.createButton(parent, label);
            this.addButtons[i].setEnabled(true);
            ++i;
        }
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    protected String[] getAddButtonLabels() {
        return new String[]{HibernateConsoleMessages.TreeToTableComposite_include, HibernateConsoleMessages.TreeToTableComposite_exclude};
    }

    protected void doRemove() {
    }

    protected void doRemoveAll() {
    }

    protected void doMoveDown() {
    }

    protected void doMoveUp() {
    }

    private void createTree() {
        this.tree = new Tree((Composite)this.dbgroup, 2);
    }

    private void createTableFiltersGroup() {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalSpan = 1;
        gridData2.verticalAlignment = 4;
        this.tableFiltersGroup = new Group((Composite)this, 0);
        this.tableFiltersGroup.setText(this.getTableTitle());
        this.tableFiltersGroup.setLayout((Layout)new FillLayout());
        this.createTableFilters();
        this.tableFiltersGroup.setLayoutData((Object)gridData2);
    }

    protected String getTableTitle() {
        return HibernateConsoleMessages.TreeToTableComposite_table_filters;
    }

    private void createTableFilters() {
        this.rightTable = new Table((Composite)this.tableFiltersGroup, 68356);
        this.rightTable.setHeaderVisible(true);
        this.rightTable.setLinesVisible(true);
        this.createTableColumns(this.rightTable);
    }

    protected void createTableColumns(Table table) {
    }

    private void createComposite() {
        GridData gridData9 = new GridData();
        gridData9.horizontalAlignment = 4;
        gridData9.grabExcessHorizontalSpace = true;
        gridData9.verticalAlignment = 2;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 4;
        gridData8.grabExcessHorizontalSpace = false;
        gridData8.verticalAlignment = 4;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData8);
        this.composite.setLayout((Layout)gridLayout2);
        this.emptyLabel = new Label(this.composite, 0);
        this.emptyLabel.setText("");
        this.emptyLabel.setLayoutData((Object)gridData9);
        this.refreshButton = new Button(this.composite, 0);
        this.refreshButton.setText(HibernateConsoleMessages.TreeToTableComposite_refresh);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeToTableComposite.this.doRefreshTree();
            }
        });
    }

    protected void doRefreshTree() {
    }

    public void setEnabled(boolean enabled) {
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.refreshButton.setEnabled(enabled);
        int i = 0;
        while (i < this.addButtons.length) {
            this.addButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    protected static final class IntegerCellEditor
    extends NullableTextCellEditor {
        public IntegerCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value != null && value instanceof Integer) {
                value = ((Integer)value).toString();
            }
            super.doSetValue(value);
        }

        public Object doGetValue() {
            String str = (String)super.doGetValue();
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            try {
                return Integer.parseInt((String)super.doGetValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public static class MultiStateCellEditor
    extends CellEditor {
        private int value;
        private final int maxStates;

        public MultiStateCellEditor(Composite parent, int stateCount, int initialValue) {
            super(parent);
            if (stateCount < 1) {
                throw new IllegalArgumentException(HibernateConsoleMessages.TreeToTableComposite_incorrect_state_count);
            }
            this.maxStates = stateCount;
            if (initialValue < 0 || initialValue >= stateCount) {
                throw new IllegalArgumentException(HibernateConsoleMessages.TreeToTableComposite_incorrect_initial_value);
            }
            this.value = initialValue;
            this.setValueValid(true);
        }

        public void activate() {
            this.value = MultiStateCellEditor.getNextValue(this.maxStates, this.value);
            this.fireApplyEditorValue();
        }

        public static int getNextValue(int stateCount, int currentValue) {
            if (stateCount <= 1) {
                throw new IllegalStateException(HibernateConsoleMessages.TreeToTableComposite_incorrect_state_count);
            }
            if (currentValue < 0 || currentValue >= stateCount) {
                throw new IllegalStateException(HibernateConsoleMessages.TreeToTableComposite_incorrect_initial_value);
            }
            return (currentValue + 1) % stateCount;
        }

        protected Control createControl(Composite parent) {
            return null;
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
        }

        protected void doSetValue(Object value) {
            this.value = (Integer)value;
            if (this.value < 0 || this.value >= this.maxStates) {
                throw new IllegalStateException(HibernateConsoleMessages.TreeToTableComposite_invalid_value);
            }
        }
    }

    protected static class NullableTextCellEditor
    extends TextCellEditor {
        public NullableTextCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value == null) {
                value = "";
            }
            super.doSetValue(value);
        }

        public Object doGetValue() {
            String str = (String)super.doGetValue();
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            return super.doGetValue();
        }
    }
}

