/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service.lease;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.service.lease.DenyResponseHeader;
import org.jgroups.service.lease.Lease;
import org.jgroups.service.lease.LeaseDeniedException;
import org.jgroups.service.lease.LeaseFactory;
import org.jgroups.service.lease.LeaseRequestHeader;
import org.jgroups.service.lease.LeaseResponseHeader;
import org.jgroups.service.lease.RecursiveLeaseRequestException;
import org.jgroups.service.lease.UnknownLeaseException;

public class LeaseFactoryClient
implements LeaseFactory {
    private static final String LEASE_CLIENT_RECEIVE_METHOD = "LeaseFactoryClient.ClientMessageListener.receive()";
    private static final String NEW_LEASE_METHOD = "LeaseFactoryClient.newLease()";
    private static final String RENEW_LEASE_METHOD = "LeaseFactoryClient.renewLease()";
    private static final String CANCEL_LEASE_METHOD = "LeaseFactoryClient.cancelLease()";
    public static final int DEFAULT_LEASE_TIMEOUT = 10000;
    public static final int DEFAULT_CANCEL_TIMEOUT = 1000;
    protected final Channel clientChannel;
    protected final PullPushAdapter clientAdapter;
    protected final int leaseTimeout = 10000;
    protected final int cancelTimeout = 1000;
    protected final HashMap pendingLeases = new HashMap();
    protected final HashMap pendingRenewals = new HashMap();
    protected final HashMap pendingCancels = new HashMap();
    protected final Log log = LogFactory.getLog(this.getClass());

    public LeaseFactoryClient(Channel clientChannel) {
        this(clientChannel, 10000, 1000);
    }

    public LeaseFactoryClient(Channel clientChannel, int leaseTimeout, int cancelTimeout) {
        this.clientChannel = clientChannel;
        this.clientAdapter = new PullPushAdapter((Transport)clientChannel, new ClientMessageListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLease(Lease existingLease) throws UnknownLeaseException {
        if (existingLease == null) {
            throw new UnknownLeaseException("Existing lease cannot be null.", existingLease);
        }
        if (existingLease.isExpired()) {
            throw new UnknownLeaseException("You existing lease has expired. You cannot use this method to obtain new lease.", existingLease);
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(existingLease.getLeaseTarget(), existingLease.getTenant());
        if (this.pendingCancels.keySet().contains(leaseInfo)) {
            throw new UnknownLeaseException("There's pending cancel request for specified lease target and tenant.", existingLease);
        }
        try {
            Object leaseMutex = new Object();
            this.pendingCancels.put(leaseInfo, leaseMutex);
            try {
                Object object = leaseMutex;
                synchronized (object) {
                    LeaseRequestHeader requestHeader = new LeaseRequestHeader(3, 0L, false, existingLease.getTenant());
                    Message msg = new Message();
                    msg.putHeader("leaseRequestHeader", requestHeader);
                    msg.setObject((Serializable)existingLease.getLeaseTarget());
                    this.clientChannel.send(msg);
                    leaseMutex.wait(10000L);
                }
            }
            catch (InterruptedException ex) {
                throw new UnknownLeaseException("Did not get any reply before the thread was interrupted.", null);
            }
            catch (ChannelNotConnectedException ex) {
                throw new UnknownLeaseException("Unable to send request, channel is not connected " + ex.getMessage(), null);
            }
            catch (ChannelClosedException ex) {
                throw new UnknownLeaseException("Unable to send request, channel is closed " + ex.getMessage(), null);
            }
            if (!(this.pendingCancels.get(leaseInfo) instanceof Message)) {
                return;
            }
            Message reply = (Message)this.pendingCancels.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                throw new UnknownLeaseException(denyHeader.getDenialReason(), existingLease);
            }
        }
        finally {
            this.pendingCancels.remove(leaseInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease newLease(Object leaseTarget, Object tenant, long requestedDuration, boolean isAbsolute) throws LeaseDeniedException {
        LocalLease localLease;
        if (leaseTarget == null || tenant == null) {
            throw new LeaseDeniedException("Lease target and tenant should be not null.", leaseTarget);
        }
        if (!(leaseTarget instanceof Serializable)) {
            throw new LeaseDeniedException("This lease factory can process only serializable lease targets", leaseTarget);
        }
        if (!(tenant instanceof Serializable)) {
            throw new LeaseDeniedException("This lease factory can process only serializable tenants", leaseTarget);
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(leaseTarget, tenant);
        if (this.pendingLeases.keySet().contains(leaseInfo)) {
            throw new RecursiveLeaseRequestException("There's pending lease request for specified lease target and tenant.", leaseTarget, tenant);
        }
        try {
            block18: {
                Object leaseMutex = new Object();
                this.pendingLeases.put(leaseInfo, leaseMutex);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Added lease info for leaseTarget=" + leaseTarget + ", tenant=" + tenant));
                }
                try {
                    if (leaseMutex == null) break block18;
                    Object object = leaseMutex;
                    synchronized (object) {
                        LeaseRequestHeader requestHeader = new LeaseRequestHeader(1, requestedDuration, isAbsolute, tenant);
                        Message msg = new Message();
                        msg.putHeader("leaseRequestHeader", requestHeader);
                        msg.setObject((Serializable)leaseTarget);
                        this.clientChannel.send(msg);
                        leaseMutex.wait(10000L);
                    }
                }
                catch (InterruptedException ex) {
                    throw new LeaseDeniedException((Object)"Did not get any reply before the thread was interrupted.");
                }
                catch (ChannelNotConnectedException ex) {
                    throw new LeaseDeniedException("Unable to send request, channel is not connected " + ex.getMessage(), (Object)null);
                }
                catch (ChannelClosedException ex) {
                    throw new LeaseDeniedException("Unable to send request, channel is closed " + ex.getMessage(), (Object)null);
                }
            }
            if (!(this.pendingLeases.get(leaseInfo) instanceof Message)) {
                throw new LeaseDeniedException("Did not get reply from leasing service within specified timeframe.", leaseTarget);
            }
            Message reply = (Message)this.pendingLeases.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                Object tmp = reply.getObject();
                throw new LeaseDeniedException(denyHeader.getDenialReason(), tmp);
            }
            LeaseResponseHeader responseHeader = (LeaseResponseHeader)reply.getHeader("leaseResponseHeader");
            localLease = new LocalLease(leaseTarget, tenant, responseHeader.getDuration());
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing lease info for leaseTarget=" + leaseTarget + ", tenant=" + tenant));
            }
            this.pendingLeases.remove(leaseInfo);
            throw throwable;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing lease info for leaseTarget=" + leaseTarget + ", tenant=" + tenant));
        }
        this.pendingLeases.remove(leaseInfo);
        return localLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease renewLease(Lease existingLease, long requestedDuration, boolean isAbsolute) throws LeaseDeniedException {
        LocalLease localLease;
        if (existingLease == null) {
            throw new LeaseDeniedException("Existing lease cannot be null.", (Object)null);
        }
        if (existingLease.isExpired()) {
            throw new LeaseDeniedException("You existing lease has expired. You cannot use this method to obtain new lease.", existingLease.getLeaseTarget());
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(existingLease.getLeaseTarget(), existingLease.getTenant());
        if (this.pendingLeases.keySet().contains(leaseInfo)) {
            throw new RecursiveLeaseRequestException("There's pending lease request for specified lease target and tenant.", existingLease.getLeaseTarget(), existingLease.getTenant());
        }
        try {
            Object leaseMutex = new Object();
            this.pendingLeases.put(leaseInfo, leaseMutex);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added lease info for leaseTarget=" + existingLease.getLeaseTarget() + ", tenant=" + existingLease.getTenant()));
            }
            try {
                Object object = leaseMutex;
                synchronized (object) {
                    LeaseRequestHeader requestHeader = new LeaseRequestHeader(2, requestedDuration, isAbsolute, existingLease.getTenant());
                    Message msg = new Message();
                    msg.putHeader("leaseRequestHeader", requestHeader);
                    msg.setObject((Serializable)existingLease.getLeaseTarget());
                    this.clientChannel.send(msg);
                    leaseMutex.wait(10000L);
                }
            }
            catch (InterruptedException ex) {
                throw new LeaseDeniedException((Object)"Did not get any reply before the thread was interrupted.");
            }
            catch (ChannelNotConnectedException ex) {
                throw new LeaseDeniedException("Unable to send request, channel is not connected " + ex.getMessage(), (Object)null);
            }
            catch (ChannelClosedException ex) {
                throw new LeaseDeniedException("Unable to send request, channel is closed " + ex.getMessage(), (Object)null);
            }
            if (!(this.pendingLeases.get(leaseInfo) instanceof Message)) {
                throw new LeaseDeniedException("Did not get reply from leasing service within specified timeframe.", (Object)null);
            }
            Message reply = (Message)this.pendingLeases.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                throw new LeaseDeniedException(denyHeader.getDenialReason(), (Object)null);
            }
            LeaseResponseHeader responseHeader = (LeaseResponseHeader)reply.getHeader("leaseResponseHeader");
            localLease = new LocalLease(existingLease.getLeaseTarget(), existingLease.getTenant(), responseHeader.getDuration());
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing lease info for leaseTarget=" + existingLease.getLeaseTarget() + ", tenant=" + existingLease.getTenant()));
            }
            this.pendingLeases.remove(leaseInfo);
            throw throwable;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing lease info for leaseTarget=" + existingLease.getLeaseTarget() + ", tenant=" + existingLease.getTenant()));
        }
        this.pendingLeases.remove(leaseInfo);
        return localLease;
    }

    public Address getAddress() {
        return this.clientChannel.getLocalAddress();
    }

    private class LocalLease
    implements Lease {
        private final long expiresAt;
        private final long creationTime;
        private final Object leaseTarget;
        private final Object tenant;

        public LocalLease(Object leaseTarget, Object tenant, long expiresAt) {
            this.leaseTarget = leaseTarget;
            this.tenant = tenant;
            this.expiresAt = expiresAt;
            this.creationTime = System.currentTimeMillis();
        }

        public long getExpiration() {
            return this.expiresAt;
        }

        public long getDuration() {
            return this.expiresAt > System.currentTimeMillis() ? this.expiresAt - System.currentTimeMillis() : -1L;
        }

        public LeaseFactory getFactory() {
            return LeaseFactoryClient.this;
        }

        public Object getLeaseTarget() {
            return this.leaseTarget;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expiresAt;
        }

        public Object getTenant() {
            return this.tenant;
        }
    }

    private static class ClientLeaseInfo {
        private final Object leaseTarget;
        private final Object tenant;

        public ClientLeaseInfo(Object leaseTarget, Object tenant) {
            this.leaseTarget = leaseTarget;
            this.tenant = tenant;
        }

        public Object getLeaseTarget() {
            return this.leaseTarget;
        }

        public Object getTenant() {
            return this.tenant;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClientLeaseInfo)) {
                return false;
            }
            ClientLeaseInfo that = (ClientLeaseInfo)obj;
            return that.getLeaseTarget().equals(this.leaseTarget) && that.getTenant().equals(this.tenant);
        }

        public int hashCode() {
            return this.leaseTarget.hashCode() ^ this.tenant.hashCode();
        }
    }

    private class ClientMessageListener
    implements MessageListener {
        private ClientMessageListener() {
        }

        public byte[] getState() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            ClientLeaseInfo leaseInfo;
            HashMap workingMap;
            Object leaseMutex;
            boolean cancelReply;
            DenyResponseHeader denyHeader = (DenyResponseHeader)msg.getHeader("denyResponseHeader");
            LeaseResponseHeader leaseHeader = (LeaseResponseHeader)msg.getHeader("leaseResponseHeader");
            if (denyHeader == null && leaseHeader == null) {
                return;
            }
            Object leaseTarget = msg.getObject();
            Object tenant = denyHeader != null ? denyHeader.getTenant() : leaseHeader.getTenant();
            boolean bl = cancelReply = denyHeader != null && denyHeader.getType() == 3 || leaseHeader != null && leaseHeader.getType() == 3;
            if (LeaseFactoryClient.this.log.isDebugEnabled()) {
                LeaseFactoryClient.this.log.debug((Object)("Received response: type=" + (denyHeader != null ? "deny" : "grant") + ", leaseTarget=" + leaseTarget + ", tenant=" + tenant + ", cancelReply=" + cancelReply));
            }
            if ((leaseMutex = (workingMap = cancelReply ? LeaseFactoryClient.this.pendingCancels : LeaseFactoryClient.this.pendingLeases).get(leaseInfo = new ClientLeaseInfo(leaseTarget, tenant))) != null) {
                Object v = leaseMutex;
                synchronized (v) {
                    workingMap.put(leaseInfo, msg);
                    leaseMutex.notifyAll();
                    if (LeaseFactoryClient.this.log.isDebugEnabled()) {
                        LeaseFactoryClient.this.log.debug((Object)("Notified mutex for leaseTarget=" + leaseTarget + ", tenant=" + tenant));
                    }
                }
            } else {
                if (LeaseFactoryClient.this.log.isDebugEnabled()) {
                    LeaseFactoryClient.this.log.debug((Object)("Could not find mutex for leaseTarget=" + leaseTarget + ", tenant=" + tenant));
                }
                workingMap.remove(leaseInfo);
            }
        }

        public void setState(byte[] state) {
        }
    }
}

