/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.DuplicateMappingException;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.MappingsDatabaseCollector;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class JDBCBinder {
    private Settings settings;
    private ConnectionProvider connectionProvider;
    private static final Log log = LogFactory.getLog((Class)JDBCBinder.class);
    private final Mappings mappings;
    private final JDBCMetaDataConfiguration cfg;
    private ReverseEngineeringStrategy revengStrategy;

    public JDBCBinder(JDBCMetaDataConfiguration cfg, Settings settings, Mappings mappings, ReverseEngineeringStrategy revengStrategy) {
        this.cfg = cfg;
        this.settings = settings;
        this.mappings = mappings;
        this.revengStrategy = revengStrategy;
    }

    public void readFromDatabase(String catalog, String schema, Mapping mapping) {
        this.connectionProvider = this.settings.getConnectionProvider();
        try {
            DatabaseCollector collector = this.readDatabaseSchema(catalog, schema);
            this.createPersistentClasses(collector, mapping);
        }
        catch (SQLException e) {
            throw this.settings.getSQLExceptionConverter().convert(e, "Reading from database", null);
        }
        finally {
            if (this.connectionProvider != null) {
                this.connectionProvider.close();
            }
        }
    }

    public DatabaseCollector readDatabaseSchema(String catalog, String schema) throws SQLException {
        catalog = catalog != null ? catalog : this.settings.getDefaultCatalogName();
        schema = schema != null ? schema : this.settings.getDefaultSchemaName();
        JDBCReader reader = JDBCReaderFactory.newJDBCReader(this.cfg.getProperties(), this.settings, this.revengStrategy);
        MappingsDatabaseCollector dbs = new MappingsDatabaseCollector(this.mappings);
        reader.readDatabaseSchema(dbs, catalog, schema);
        return dbs;
    }

    private void createPersistentClasses(DatabaseCollector collector, Mapping mapping) {
        Map manyToOneCandidates = collector.getOneToManyCandidates();
        Iterator iter = this.mappings.iterateTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.getColumnSpan() == 0) {
                log.warn((Object)("Cannot create persistent class for " + table + " as no columns were found."));
                continue;
            }
            if (this.revengStrategy.isManyToManyTable(table)) {
                log.debug((Object)("Ignoring " + table + " as class since rev.eng. says it is a many-to-many"));
                continue;
            }
            RootClass rc = new RootClass();
            TableIdentifier tableIdentifier = TableIdentifier.create(table);
            String className = this.revengStrategy.tableToClassName(tableIdentifier);
            log.debug((Object)("Building entity " + className + " based on " + tableIdentifier));
            rc.setEntityName(className);
            rc.setClassName(className);
            rc.setProxyInterfaceName(rc.getEntityName());
            rc.setLazy(true);
            rc.setMetaAttributes(this.safeMeta(this.revengStrategy.tableToMetaAttributes(tableIdentifier)));
            rc.setDiscriminatorValue(rc.getEntityName());
            rc.setTable(table);
            try {
                this.mappings.addClass((PersistentClass)rc);
            }
            catch (DuplicateMappingException dme) {
                PersistentClass class1 = this.mappings.getClass(dme.getName());
                Table table2 = class1.getTable();
                throw new JDBCBinderException("Duplicate class name '" + rc.getEntityName() + "' generated for '" + table + "'. Same name where generated for '" + table2 + "'");
            }
            this.mappings.addImport(rc.getEntityName(), rc.getEntityName());
            HashSet processed = new HashSet();
            PrimaryKeyInfo pki = this.bindPrimaryKeyToProperties(table, rc, processed, mapping, collector);
            this.bindColumnsToVersioning(table, rc, processed, mapping);
            this.bindOutgoingForeignKeys(table, rc, processed);
            this.bindColumnsToProperties(table, rc, processed, mapping);
            List incomingForeignKeys = (List)manyToOneCandidates.get(rc.getEntityName());
            this.bindIncomingForeignKeys((PersistentClass)rc, processed, incomingForeignKeys, mapping);
            this.updatePrimaryKey(rc, pki);
        }
    }

    private void updatePrimaryKey(RootClass rc, PrimaryKeyInfo pki) {
        SimpleValue idValue = (SimpleValue)rc.getIdentifierProperty().getValue();
        Properties defaultStrategyProperties = new Properties();
        Property constrainedOneToOne = this.getConstrainedOneToOne(rc);
        if (constrainedOneToOne != null) {
            if (pki.suggestedStrategy == null) {
                idValue.setIdentifierGeneratorStrategy("foreign");
            }
            if (pki.suggestedProperties == null) {
                defaultStrategyProperties.setProperty("property", constrainedOneToOne.getName());
                idValue.setIdentifierGeneratorProperties(defaultStrategyProperties);
            }
        }
    }

    private Property getConstrainedOneToOne(RootClass rc) {
        Iterator propertyClosureIterator = rc.getPropertyClosureIterator();
        while (propertyClosureIterator.hasNext()) {
            OneToOne oto;
            Property property = (Property)propertyClosureIterator.next();
            if (!(property.getValue() instanceof OneToOne) || !(oto = (OneToOne)property.getValue()).isConstrained()) continue;
            return property;
        }
        return null;
    }

    private Map safeMeta(Map map) {
        if (map == null) {
            return new HashMap();
        }
        return map;
    }

    private void bindIncomingForeignKeys(PersistentClass rc, java.util.Set processed, List foreignKeys, Mapping mapping) {
        if (foreignKeys != null) {
            Iterator iter = foreignKeys.iterator();
            while (iter.hasNext()) {
                Property property;
                ForeignKey foreignKey = (ForeignKey)iter.next();
                if (this.revengStrategy.excludeForeignKeyAsCollection(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns())) {
                    log.debug((Object)("Rev.eng excluded one-to-many or one-to-one for foreignkey " + foreignKey.getName()));
                    continue;
                }
                if (this.revengStrategy.isOneToOne(foreignKey)) {
                    property = this.bindOneToOne(rc, foreignKey.getTable(), foreignKey, processed, false, true);
                    rc.addProperty(property);
                    continue;
                }
                property = this.bindOneToMany(rc, foreignKey, processed, mapping);
                rc.addProperty(property);
            }
        }
    }

    private Property bindOneToOne(PersistentClass rc, Table targetTable, ForeignKey fk, java.util.Set processedColumns, boolean constrained, boolean inverseProperty) {
        OneToOne value = new OneToOne(targetTable, rc);
        value.setReferencedEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(targetTable)));
        boolean isUnique = this.isUniqueReference(fk);
        String propertyName = null;
        propertyName = inverseProperty ? this.revengStrategy.foreignKeyToInverseEntityName(fk.getName(), TableIdentifier.create(fk.getReferencedTable()), fk.getReferencedColumns(), TableIdentifier.create(targetTable), fk.getColumns(), isUnique) : this.revengStrategy.foreignKeyToEntityName(fk.getName(), TableIdentifier.create(fk.getReferencedTable()), fk.getReferencedColumns(), TableIdentifier.create(targetTable), fk.getColumns(), isUnique);
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        value.setFetchMode(FetchMode.SELECT);
        value.setConstrained(constrained);
        value.setForeignKeyType(constrained ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        return this.makeEntityProperty(propertyName, true, targetTable, fk, (ToOne)value, inverseProperty);
    }

    private Property bindManyToOne(String propertyName, boolean mutable, Table table, ForeignKey fk, java.util.Set processedColumns) {
        ManyToOne value = new ManyToOne(table);
        value.setReferencedEntityName(fk.getReferencedEntityName());
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        value.setFetchMode(FetchMode.SELECT);
        return this.makeEntityProperty(propertyName, mutable, table, fk, (ToOne)value, false);
    }

    private Property makeCollectionProperty(String propertyName, boolean mutable, Table table, ForeignKey fk, Collection value, boolean inverseProperty) {
        AssociationInfo fkei = inverseProperty ? this.revengStrategy.foreignKeyToInverseAssociationInfo(fk) : this.revengStrategy.foreignKeyToAssociationInfo(fk);
        String fetchMode = null;
        String cascade = null;
        boolean update = mutable;
        boolean insert = mutable;
        if (fkei != null) {
            cascade = fkei.getCascade();
            if (cascade == null) {
                cascade = "all";
            }
            if (fkei.getUpdate() != null) {
                update = fkei.getUpdate();
            }
            if (fkei.getInsert() != null) {
                insert = fkei.getInsert();
            }
            fetchMode = fkei.getFetch();
        }
        if (FetchMode.JOIN.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.JOIN);
        } else if (FetchMode.SELECT.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.SELECT);
        } else {
            value.setFetchMode(FetchMode.SELECT);
        }
        return this.makeProperty(TableIdentifier.create(table), propertyName, (Value)value, insert, update, value.getFetchMode() != FetchMode.JOIN, cascade, null);
    }

    private Property makeEntityProperty(String propertyName, boolean mutable, Table table, ForeignKey fk, ToOne value, boolean inverseProperty) {
        AssociationInfo fkei = inverseProperty ? this.revengStrategy.foreignKeyToInverseAssociationInfo(fk) : this.revengStrategy.foreignKeyToAssociationInfo(fk);
        String fetchMode = null;
        String cascade = null;
        boolean update = mutable;
        boolean insert = mutable;
        if (fkei != null) {
            cascade = fkei.getCascade();
            if (fkei.getUpdate() != null) {
                update = fkei.getUpdate();
            }
            if (fkei.getInsert() != null) {
                insert = fkei.getInsert();
            }
            fetchMode = fkei.getFetch();
        }
        if (FetchMode.JOIN.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.JOIN);
        } else if (FetchMode.SELECT.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.SELECT);
        } else {
            value.setFetchMode(FetchMode.SELECT);
        }
        return this.makeProperty(TableIdentifier.create(table), propertyName, (Value)value, insert, update, value.getFetchMode() != FetchMode.JOIN, cascade, null);
    }

    private Property bindOneToMany(PersistentClass rc, ForeignKey foreignKey, java.util.Set processed, Mapping mapping) {
        Table collectionTable = foreignKey.getTable();
        Set collection = new Set(rc);
        collection.setCollectionTable(collectionTable);
        boolean manyToMany = this.revengStrategy.isManyToManyTable(collectionTable);
        if (manyToMany) {
            // empty if block
        }
        if (manyToMany) {
            ManyToOne element = new ManyToOne(collection.getCollectionTable());
            Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
            ArrayList keys = new ArrayList();
            while (foreignKeyIterator.hasNext()) {
                Object next = foreignKeyIterator.next();
                if (next == foreignKey) continue;
                keys.add(next);
            }
            if (keys.size() > 1) {
                throw new JDBCBinderException("more than one other foreign key to choose from!");
            }
            ForeignKey fk = (ForeignKey)keys.get(0);
            String tableToClassName = this.bindCollection(rc, foreignKey, fk, (Collection)collection);
            element.setReferencedEntityName(tableToClassName);
            element.addColumn(fk.getColumn(0));
            collection.setElement((Value)element);
        } else {
            String tableToClassName = this.bindCollection(rc, foreignKey, null, (Collection)collection);
            OneToMany oneToMany = new OneToMany(collection.getOwner());
            oneToMany.setReferencedEntityName(tableToClassName);
            this.mappings.addSecondPass((SecondPass)new JDBCCollectionSecondPass(this.mappings, (Collection)collection));
            collection.setElement((Value)oneToMany);
        }
        String propRef = collection.getReferencedPropertyName();
        KeyValue referencedKeyValue = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propRef).getValue();
        DependantValue keyValue = new DependantValue(collectionTable, referencedKeyValue);
        Iterator columnIterator = foreignKey.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column fkcolumn = (Column)columnIterator.next();
            if (fkcolumn.getSqlTypeCode() != null) {
                this.guessAndAlignType(collectionTable, fkcolumn, mapping, false);
            }
            keyValue.addColumn(fkcolumn);
        }
        collection.setKey((KeyValue)keyValue);
        this.mappings.addCollection((Collection)collection);
        return this.makeCollectionProperty(StringHelper.unqualify((String)collection.getRole()), true, rc.getTable(), foreignKey, (Collection)collection, true);
    }

    private String bindCollection(PersistentClass rc, ForeignKey fromForeignKey, ForeignKey toForeignKey, Collection collection) {
        String tableToClassName;
        ForeignKey targetKey = fromForeignKey;
        String collectionRole = null;
        boolean collectionLazy = false;
        boolean collectionInverse = false;
        TableIdentifier foreignKeyTable = null;
        if (toForeignKey != null) {
            targetKey = toForeignKey;
        }
        boolean uniqueReference = this.isUniqueReference(targetKey);
        foreignKeyTable = TableIdentifier.create(targetKey.getTable());
        TableIdentifier foreignKeyReferencedTable = TableIdentifier.create(targetKey.getReferencedTable());
        if (toForeignKey == null) {
            collectionRole = this.revengStrategy.foreignKeyToCollectionName(fromForeignKey.getName(), foreignKeyTable, fromForeignKey.getColumns(), foreignKeyReferencedTable, fromForeignKey.getReferencedColumns(), uniqueReference);
            tableToClassName = this.revengStrategy.tableToClassName(foreignKeyTable);
        } else {
            collectionRole = this.revengStrategy.foreignKeyToManyToManyName(fromForeignKey, TableIdentifier.create(fromForeignKey.getTable()), toForeignKey, uniqueReference);
            tableToClassName = this.revengStrategy.tableToClassName(foreignKeyReferencedTable);
        }
        collectionInverse = this.revengStrategy.isForeignKeyCollectionInverse(targetKey.getName(), foreignKeyTable, targetKey.getColumns(), foreignKeyReferencedTable, targetKey.getReferencedColumns());
        collectionLazy = this.revengStrategy.isForeignKeyCollectionLazy(targetKey.getName(), foreignKeyTable, targetKey.getColumns(), foreignKeyReferencedTable, targetKey.getReferencedColumns());
        collectionRole = this.makeUnique(rc, collectionRole);
        String fullRolePath = StringHelper.qualify((String)rc.getEntityName(), (String)collectionRole);
        if (this.mappings.getCollection(fullRolePath) != null) {
            log.debug((Object)(fullRolePath + " found twice!"));
        }
        collection.setRole(fullRolePath);
        collection.setInverse(collectionInverse);
        collection.setLazy(collectionLazy);
        collection.setFetchMode(FetchMode.SELECT);
        return tableToClassName;
    }

    private boolean isUniqueReference(ForeignKey foreignKey) {
        Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
        while (foreignKeyIterator.hasNext()) {
            ForeignKey element = (ForeignKey)foreignKeyIterator.next();
            if (element == foreignKey || !element.getReferencedTable().equals(foreignKey.getReferencedTable())) continue;
            return false;
        }
        return true;
    }

    private PrimaryKeyInfo bindPrimaryKeyToProperties(Table table, RootClass rc, java.util.Set processed, Mapping mapping, DatabaseCollector collector) {
        boolean naturalId;
        SimpleValue id = null;
        String idPropertyname = null;
        PrimaryKeyInfo pki = new PrimaryKeyInfo();
        ArrayList<Column> keyColumns = null;
        if (table.getPrimaryKey() != null) {
            keyColumns = table.getPrimaryKey().getColumns();
        } else {
            log.debug((Object)("No primary key found for " + table + ", using all properties as the identifier."));
            keyColumns = new ArrayList<Column>();
            Iterator iter = table.getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyColumns.add(col);
            }
        }
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        String tableIdentifierStrategyName = "assigned";
        if (keyColumns.size() > 1) {
            log.debug((Object)("id strategy for " + rc.getEntityName() + " since it has a multiple column primary key"));
            naturalId = true;
            id = this.handleCompositeKey(rc, processed, keyColumns, mapping);
            idPropertyname = this.revengStrategy.tableToIdentifierPropertyName(tableIdentifier);
            if (idPropertyname == null) {
                idPropertyname = "id";
            }
        } else {
            pki.suggestedStrategy = this.revengStrategy.getTableIdentifierStrategyName(tableIdentifier);
            String suggestedStrategy = pki.suggestedStrategy;
            if (suggestedStrategy == null) {
                suggestedStrategy = collector.getSuggestedIdentifierStrategy(tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getName());
                if (suggestedStrategy == null) {
                    suggestedStrategy = "assigned";
                }
                tableIdentifierStrategyName = suggestedStrategy;
            } else {
                tableIdentifierStrategyName = suggestedStrategy;
            }
            naturalId = "assigned".equals(tableIdentifierStrategyName);
            Column pkc = (Column)keyColumns.get(0);
            this.checkColumn(pkc);
            id = this.bindColumnToSimpleValue(table, pkc, mapping, !naturalId);
            idPropertyname = this.revengStrategy.tableToIdentifierPropertyName(tableIdentifier);
            if (idPropertyname == null) {
                idPropertyname = this.revengStrategy.columnToPropertyName(tableIdentifier, pkc.getName());
            }
            processed.add(pkc);
        }
        id.setIdentifierGeneratorStrategy(tableIdentifierStrategyName);
        pki.suggestedProperties = this.revengStrategy.getTableIdentifierProperties(tableIdentifier);
        id.setIdentifierGeneratorProperties(pki.suggestedProperties);
        if (naturalId) {
            id.setNullValue("undefined");
        }
        Property property = this.makeProperty(tableIdentifier, this.makeUnique((PersistentClass)rc, idPropertyname), (Value)id, true, true, false, null, null);
        rc.setIdentifierProperty(property);
        rc.setIdentifier((KeyValue)id);
        return pki;
    }

    private void bindOutgoingForeignKeys(Table table, RootClass rc, java.util.Set processedColumns) {
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            boolean mutable = true;
            if (this.contains(foreignKey.getColumnIterator(), processedColumns)) {
                if (!this.cfg.preferBasicCompositeIds()) continue;
                mutable = false;
            }
            if (this.revengStrategy.excludeForeignKeyAsManytoOne(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns())) {
                log.debug((Object)("Rev.eng excluded *-to-one for foreignkey " + foreignKey.getName()));
                continue;
            }
            if (this.revengStrategy.isOneToOne(foreignKey)) {
                Property property = this.bindOneToOne((PersistentClass)rc, foreignKey.getReferencedTable(), foreignKey, processedColumns, true, false);
                rc.addProperty(property);
                continue;
            }
            boolean isUnique = this.isUniqueReference(foreignKey);
            String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), isUnique);
            Property property = this.bindManyToOne(this.makeUnique((PersistentClass)rc, propertyName), mutable, table, foreignKey, processedColumns);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToProperties(Table table, RootClass rc, java.util.Set processedColumns, Mapping mapping) {
        Iterator iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (processedColumns.contains(column)) continue;
            this.checkColumn(column);
            String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
            Property property = this.bindBasicProperty(this.makeUnique((PersistentClass)rc, propertyName), table, column, processedColumns, mapping);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToVersioning(Table table, RootClass rc, java.util.Set processed, Mapping mapping) {
        TableIdentifier identifier = TableIdentifier.create(table);
        String optimisticLockColumnName = this.revengStrategy.getOptimisticLockColumnName(identifier);
        if (optimisticLockColumnName != null) {
            Column column = table.getColumn(new Column(optimisticLockColumnName));
            if (column == null) {
                log.warn((Object)("Column " + column + " wanted for <version>/<timestamp> not found in " + identifier));
            } else {
                this.bindVersionProperty(table, identifier, column, rc, processed, mapping);
            }
        } else {
            log.debug((Object)("Scanning " + identifier + " for <version>/<timestamp> columns."));
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                boolean useIt = this.revengStrategy.useColumnForOptimisticLock(identifier, column.getName());
                if (!useIt || processed.contains(column)) continue;
                this.bindVersionProperty(table, identifier, column, rc, processed, mapping);
                return;
            }
            log.debug((Object)("No columns reported while scanning for <version>/<timestamp> columns in " + identifier));
        }
    }

    private void bindVersionProperty(Table table, TableIdentifier identifier, Column column, RootClass rc, java.util.Set processed, Mapping mapping) {
        processed.add(column);
        String propertyName = this.revengStrategy.columnToPropertyName(identifier, column.getName());
        Property property = this.bindBasicProperty(this.makeUnique((PersistentClass)rc, propertyName), table, column, processed, mapping);
        rc.addProperty(property);
        rc.setVersion(property);
        rc.setOptimisticLockMode(0);
        log.debug((Object)("Column " + column.getName() + " will be used for <version>/<timestamp> columns in " + identifier));
    }

    private Property bindBasicProperty(String propertyName, Table table, Column column, java.util.Set processedColumns, Mapping mapping) {
        SimpleValue value = this.bindColumnToSimpleValue(table, column, mapping, false);
        return this.makeProperty(TableIdentifier.create(table), propertyName, (Value)value, true, true, false, null, null);
    }

    private SimpleValue bindColumnToSimpleValue(Table table, Column column, Mapping mapping, boolean generatedIdentifier) {
        SimpleValue value = new SimpleValue(table);
        value.addColumn(column);
        value.setTypeName(this.guessAndAlignType(table, column, mapping, generatedIdentifier));
        return value;
    }

    private boolean contains(Iterator columnIterator, java.util.Set processedColumns) {
        while (columnIterator.hasNext()) {
            Column element = (Column)columnIterator.next();
            if (!processedColumns.contains(element)) continue;
            return true;
        }
        return false;
    }

    private void checkColumn(Column column) {
        if (column.getValue() != null) {
            // empty if block
        }
    }

    private String guessAndAlignType(Table table, Column column, Mapping mapping, boolean generatedIdentifier) {
        Integer sqlTypeCode = column.getSqlTypeCode();
        String location = "Table: " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getQuotedName()) + " column: " + column.getQuotedName();
        if (sqlTypeCode == null) {
            throw new JDBCBinderException("sqltype is null for " + location);
        }
        String preferredHibernateType = this.revengStrategy.columnToHibernateTypeName(TableIdentifier.create(table), column.getName(), sqlTypeCode, column.getLength(), column.getPrecision(), column.getScale(), column.isNullable(), generatedIdentifier);
        Type wantedType = TypeFactory.heuristicType((String)preferredHibernateType);
        if (wantedType != null) {
            int[] wantedSqlTypes = wantedType.sqlTypes(mapping);
            if (wantedSqlTypes.length > 1) {
                throw new JDBCBinderException("The type " + preferredHibernateType + " found on " + location + " spans multiple columns. Only single column types allowed.");
            }
            int wantedSqlType = wantedSqlTypes[0];
            if (wantedSqlType != sqlTypeCode) {
                log.debug((Object)("Sql type mismatch for " + location + " between DB and wanted hibernate type. Sql type set to " + this.typeCodeName(sqlTypeCode) + " instead of " + this.typeCodeName(wantedSqlType)));
                column.setSqlTypeCode(new Integer(wantedSqlType));
            }
        } else {
            log.debug((Object)("No Hibernate type found for " + preferredHibernateType + ". Most likely cause is a missing UserType class."));
        }
        if (preferredHibernateType == null) {
            throw new JDBCBinderException("Could not find javatype for " + this.typeCodeName(sqlTypeCode));
        }
        return preferredHibernateType;
    }

    private String typeCodeName(int sqlTypeCode) {
        return sqlTypeCode + "(" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlTypeCode) + ")";
    }

    private SimpleValue handleCompositeKey(RootClass rc, java.util.Set processedColumns, List keyColumns, Mapping mapping) {
        Component pkc = new Component((PersistentClass)rc);
        pkc.setMetaAttributes(Collections.EMPTY_MAP);
        pkc.setEmbedded(false);
        String compositeIdName = this.revengStrategy.tableToCompositeIdName(TableIdentifier.create(rc.getTable()));
        if (compositeIdName == null) {
            compositeIdName = this.revengStrategy.classNameToCompositeIdName(rc.getClassName());
        }
        pkc.setComponentClassName(compositeIdName);
        Table table = rc.getTable();
        List list = null;
        list = this.cfg.preferBasicCompositeIds() ? new ArrayList(keyColumns) : this.findForeignKeys(table.getForeignKeyIterator(), keyColumns);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Property property;
            Object element = iter.next();
            if (element instanceof Column) {
                Column column = (Column)element;
                if (processedColumns.contains(column)) {
                    throw new JDBCBinderException("Binding column twice for primary key should not happen: " + column);
                }
                this.checkColumn(column);
                String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
                property = this.bindBasicProperty(this.makeUnique(pkc, propertyName), table, column, processedColumns, mapping);
                processedColumns.add(column);
            } else if (element instanceof ForeignKeyForColumns) {
                ForeignKeyForColumns fkfc = (ForeignKeyForColumns)element;
                ForeignKey foreignKey = fkfc.key;
                String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), true);
                property = this.bindManyToOne(this.makeUnique(pkc, propertyName), true, table, foreignKey, processedColumns);
                processedColumns.addAll(fkfc.columns);
            } else {
                throw new JDBCBinderException("unknown thing");
            }
            this.markAsUseInEquals(property);
            pkc.addProperty(property);
        }
        return pkc;
    }

    private void markAsUseInEquals(Property property) {
        HashMap<String, MetaAttribute> m = new HashMap<String, MetaAttribute>();
        MetaAttribute ma = new MetaAttribute("use-in-equals");
        ma.addValue("true");
        m.put(ma.getName(), ma);
        property.setMetaAttributes(m);
    }

    private List findForeignKeys(Iterator foreignKeyIterator, List pkColumns) {
        ArrayList tempList = new ArrayList();
        while (foreignKeyIterator.hasNext()) {
            tempList.add(foreignKeyIterator.next());
        }
        ArrayList<ForeignKeyForColumns> result = new ArrayList<ForeignKeyForColumns>();
        Column[] myPkColumns = pkColumns.toArray(new Column[pkColumns.size()]);
        for (int i = 0; i < myPkColumns.length; ++i) {
            boolean foundKey = false;
            foreignKeyIterator = tempList.iterator();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey key = (ForeignKey)foreignKeyIterator.next();
                List matchingColumns = this.columnMatches(myPkColumns, i, key);
                if (matchingColumns == null) continue;
                result.add(new ForeignKeyForColumns(key, matchingColumns));
                i += matchingColumns.size() - 1;
                foreignKeyIterator.remove();
                foundKey = true;
                break;
            }
            if (foundKey) continue;
            result.add((ForeignKeyForColumns)myPkColumns[i]);
        }
        return result;
    }

    private List columnMatches(Column[] myPkColumns, int offset, ForeignKey key) {
        if (key.getColumnSpan() > myPkColumns.length - offset) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int j = 0; j < key.getColumnSpan(); ++j) {
            Column column = myPkColumns[j + offset];
            if (!column.equals(key.getColumn(j))) {
                return null;
            }
            columns.add(column);
        }
        return columns.isEmpty() ? null : columns;
    }

    private Property makeProperty(TableIdentifier table, String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade, String propertyAccessorName) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade == null ? "none" : cascade);
        prop.setPropertyAccessorName(propertyAccessorName == null ? "property" : propertyAccessorName);
        this.bindMeta(prop, table);
        return prop;
    }

    private Property bindMeta(Property property, TableIdentifier identifier) {
        Iterator columnIterator = property.getValue().getColumnIterator();
        while (columnIterator.hasNext()) {
            Column col = (Column)columnIterator.next();
            Map map = this.revengStrategy.columnToMetaAttributes(identifier, col.getName());
            if (map == null) continue;
            property.setMetaAttributes(map);
        }
        return property;
    }

    private String makeUnique(Component clazz, String propertyName) {
        return JDBCBinder.makeUnique(clazz.getPropertyIterator(), propertyName);
    }

    private String makeUnique(PersistentClass clazz, String propertyName) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (clazz.hasIdentifierProperty()) {
            list.add(clazz.getIdentifierProperty());
        }
        if (clazz.isVersioned()) {
            list.add(clazz.getVersion());
        }
        JoinedIterator iterator = new JoinedIterator(list.iterator(), clazz.getPropertyClosureIterator());
        return JDBCBinder.makeUnique((Iterator)iterator, propertyName);
    }

    private static String makeUnique(Iterator props, String originalPropertyName) {
        int cnt = 0;
        String propertyName = originalPropertyName;
        HashSet<String> uniqueNames = new HashSet<String>();
        while (props.hasNext()) {
            Property element = (Property)props.next();
            uniqueNames.add(element.getName());
        }
        while (uniqueNames.contains(propertyName)) {
            propertyName = originalPropertyName + "_" + ++cnt;
        }
        return propertyName;
    }

    public static void bindCollectionSecondPass(Collection collection, Map persistentClasses, Mappings mappings, Map inheritedMetas) throws MappingException {
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            PersistentClass persistentClass = mappings.getClass(oneToMany.getReferencedEntityName());
            if (persistentClass == null) {
                throw new MappingException("Association " + collection.getRole() + " references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(persistentClass);
        }
    }

    static class JDBCCollectionSecondPass
    extends CollectionSecondPass {
        JDBCCollectionSecondPass(Mappings mappings, Collection coll) {
            super(mappings, coll);
        }

        public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
            JDBCBinder.bindCollectionSecondPass(this.collection, persistentClasses, this.mappings, inheritedMetas);
        }

        public void doSecondPass(Map persistentClasses) throws MappingException {
            Value element = this.collection.getElement();
            DependantValue dep = null;
            String oldFkName = null;
            if (element instanceof DependantValue) {
                dep = (DependantValue)element;
                oldFkName = dep.getForeignKeyName();
                dep.setForeignKeyName("none");
            }
            super.doSecondPass(persistentClasses);
            if (dep != null) {
                dep.setForeignKeyName(oldFkName);
            }
        }
    }

    static class ForeignKeyForColumns {
        protected final List columns;
        protected final ForeignKey key;

        public ForeignKeyForColumns(ForeignKey key, List columns) {
            this.key = key;
            this.columns = columns;
        }
    }

    private static class PrimaryKeyInfo {
        String suggestedStrategy = null;
        Properties suggestedProperties = null;

        private PrimaryKeyInfo() {
        }
    }
}

