/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.MBeanElement;
import org.jboss.mx.loading.MLetParser;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.MBeanInstaller;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.util.NestedRuntimeException;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final Logger log = Logger.getLogger((Class)(class$javax$management$loading$MLet == null ? (class$javax$management$loading$MLet = MLet.class$("javax.management.loading.MLet")) : class$javax$management$loading$MLet));
    private MBeanServer server = null;
    private ObjectName objectName = null;
    private MBeanInstaller installer = null;
    private RepositoryClassLoader rcl = null;
    private boolean delegateToCLR = true;
    private String libraryDir = null;
    static /* synthetic */ Class class$javax$management$loading$MLet;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public MLet() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public MLet(URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
    }

    public MLet(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public MLet(URL[] urls, boolean delegateToCLR) {
        super(urls, Thread.currentThread().getContextClassLoader());
        this.delegateToCLR = delegateToCLR;
    }

    public MLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) {
        super(urls, parent);
        this.delegateToCLR = delegateToCLR;
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory, boolean delegateToCLR) {
        super(urls, parent, factory);
        this.delegateToCLR = delegateToCLR;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            String defaultDomain = server.getDefaultDomain();
            name = new ObjectName(defaultDomain + ":type=MLet");
        }
        this.objectName = name;
        this.server = server;
        this.installer = new MBeanInstaller(server, this, name);
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.server = null;
        this.rcl = null;
        this.objectName = null;
        this.installer = null;
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        try {
            return this.getMBeansFromURL(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException("Malformed URL:" + url);
        }
    }

    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException("Loader must be registered to the server before loading the MBeans.");
        }
        HashSet<Serializable> mbeans = new HashSet<Serializable>();
        MBeanElement element = null;
        try {
            MLetParser parser = new MLetParser();
            Set mlets = parser.parseMBeanFile(url);
            if (mlets.size() == 0) {
                throw new ServiceNotFoundException("The specified URL '" + url + "' does not contain MLET tags.");
            }
            Iterator it = mlets.iterator();
            while (it.hasNext()) {
                element = (MBeanElement)it.next();
                element.setProperty("delegateToCLR", new Boolean(this.delegateToCLR));
                String codebase = element.getCodebase();
                if (codebase == null) {
                    codebase = url.toString().substring(0, url.toString().lastIndexOf(47));
                }
                Iterator archives = element.getArchives().iterator();
                String codebaseURL = null;
                while (archives.hasNext()) {
                    try {
                        codebaseURL = codebase + (codebase.endsWith("/") ? "" : "/") + archives.next();
                        this.addURL(new URL(url, codebaseURL));
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)("MLET ERROR: malformed codebase URL: '" + codebaseURL + "'"));
                    }
                }
                try {
                    mbeans.add(this.installer.installMBean(element));
                }
                catch (Throwable t) {
                    mbeans.add(t);
                    log.error((Object)"MLET ERROR: can't create MBean: ", t);
                }
            }
        }
        catch (ParseException e) {
            throw new ServiceNotFoundException(e.getMessage());
        }
        return mbeans;
    }

    public void addURL(URL url) {
        super.addURL(url);
        if (this.rcl == null && this.server != null) {
            this.getRepositoryClassLoader();
        }
        this.rcl.addURL(url);
    }

    public void addURL(String url) throws ServiceNotFoundException {
        try {
            this.addURL(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException("Malformed URL: " + url);
        }
    }

    public URL[] getURLs() {
        return super.getURLs();
    }

    public String getLibraryDirectory() {
        return this.libraryDir;
    }

    public void setLibraryDirectory(String libdir) {
        this.libraryDir = libdir;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet serialization not supported.");
    }

    public void writeExternal(ObjectOutput out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet serialization not supported.");
    }

    public Class loadClass(String name, ClassLoaderRepository clr) throws ClassNotFoundException {
        Class c = null;
        try {
            c = this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (clr != null) {
                c = clr.loadClass(name);
            }
            throw e;
        }
        return c;
    }

    protected URL check(String version, URL codebase, String jarfile, MLetContent mlet) throws Exception {
        return codebase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block5: {
            block6: {
                boolean trace = log.isTraceEnabled();
                if (trace) {
                    log.trace((Object)("loadClass " + this + " name=" + name));
                }
                Class<?> clazz2 = null;
                try {
                    clazz = clazz2 = super.loadClass(name, resolve);
                    Object var7_6 = null;
                    if (!trace) break block5;
                    if (clazz2 == null) break block6;
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var7_7 = null;
                        if (!trace) break block7;
                        if (clazz2 != null) {
                            log.trace((Object)("loadClass " + this + " name=" + name + " class=" + clazz2 + " cl=" + clazz2.getClassLoader()));
                        } else {
                            log.trace((Object)("loadClass " + this + " name=" + name + " not found"));
                        }
                    }
                    throw throwable;
                }
                log.trace((Object)("loadClass " + this + " name=" + name + " class=" + clazz2 + " cl=" + clazz2.getClassLoader()));
                break block5;
            }
            log.trace((Object)("loadClass " + this + " name=" + name + " not found"));
        }
        return clazz;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.delegateToCLR) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return MLet.this.server.getClassLoaderRepository().loadClassBefore(MLet.this, name);
                        }
                    });
                }
                catch (PrivilegedActionException pe) {
                    throw (ClassNotFoundException)pe.getException();
                }
            }
            throw e;
        }
    }

    protected String findLibrary(String libname) {
        return super.findLibrary(libname);
    }

    private void getRepositoryClassLoader() {
        try {
            ObjectName loader = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
            this.rcl = (RepositoryClassLoader)this.server.invoke(loader, "getWrappingClassLoader", new Object[]{this}, new String[]{(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MLet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName()});
            log.debug((Object)("MLet " + this + " using wrapper " + this.rcl));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

