/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Converter;
import org.eclipse.jpt.core.context.EnumeratedConverter;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.EnumTypeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.FetchTypeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.OptionalComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TemporalTypeComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.Generated;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.IndexHolder;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.GeneratedComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateColumnComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.IndexHolderComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBasicMappingComposite
extends FormPane<BasicMapping>
implements JpaComposite {
    public HibernateBasicMappingComposite(PropertyValueModel<? extends BasicMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.initializeGeneralPane(container);
        this.initializeTypePane(container);
        this.initializeIndexPane(container);
    }

    private void initializeGeneralPane(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        new HibernateColumnComposite(this, this.buildColumnHolder(), container);
        container = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        if (this.getSubject() instanceof Generated) {
            new GeneratedComposite(this, container);
        }
        new FetchTypeComposite((FormPane)this, container);
        new OptionalComposite((FormPane)this, this.addSubPane(container, 4));
    }

    private void initializeTypePane(Composite container) {
        container = this.addCollapsableSection(container, JptUiMappingsMessages.TypeSection_type);
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiMappingsMessages.TypeSection_default, this.buildNoConverterHolder(), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        Button lobButton = this.addRadioButton(container, JptUiMappingsMessages.TypeSection_lob, this.buildLobConverterHolder(), null);
        ((GridData)lobButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> specifiedConverterHolder = this.buildSpecifiedConverterHolder();
        this.addRadioButton(container, JptUiMappingsMessages.TypeSection_temporal, this.buildTemporalBooleanHolder(), null);
        this.registerSubPane((Pane)new TemporalTypeComposite(this.buildTemporalConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
        this.addRadioButton(container, JptUiMappingsMessages.TypeSection_enumerated, this.buildEnumeratedBooleanHolder(), null);
        this.registerSubPane((Pane)new EnumTypeComposite(this.buildEnumeratedConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
    }

    private void initializeIndexPane(Composite container) {
        if (this.getSubject() instanceof IndexHolder) {
            container = this.addCollapsableSection(container, HibernateUIMappingMessages.Index_section_index);
            ((GridLayout)container.getLayout()).numColumns = 2;
            new IndexHolderComposite(this, container);
        }
    }

    private PropertyValueModel<HibernateColumn> buildColumnHolder() {
        return new TransformationPropertyValueModel<BasicMapping, HibernateColumn>(this.getSubjectHolder()){

            protected HibernateColumn transform_(BasicMapping value) {
                return (HibernateColumn)value.getColumn();
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNoConverterHolder() {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                return ((BasicMapping)this.subject).getSpecifiedConverter() == null;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter("noConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildLobConverterHolder() {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == "lobConverter";
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter("lobConverter");
                }
            }
        };
    }

    private PropertyValueModel<Converter> buildSpecifiedConverterHolder() {
        return new PropertyAspectAdapter<BasicMapping, Converter>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Converter buildValue_() {
                return ((BasicMapping)this.subject).getSpecifiedConverter();
            }
        };
    }

    private PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "temporalConverter" ? (TemporalConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<EnumeratedConverter> buildEnumeratedConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, EnumeratedConverter>(converterHolder){

            protected EnumeratedConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "enumeratedConverter" ? (EnumeratedConverter)converter : null;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildTemporalBooleanHolder() {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == "temporalConverter";
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter("temporalConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildEnumeratedBooleanHolder() {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == "enumeratedConverter";
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter("enumeratedConverter");
                }
            }
        };
    }
}

