/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.CatalogCombo;
import org.eclipse.jpt.ui.internal.mappings.db.SchemaCombo;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateEntity;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.TableCombo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTableComposite
extends FormPane<HibernateEntity> {
    public HibernateTableComposite(FormPane<? extends HibernateEntity> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    protected void initializeLayout(Composite container) {
        Group tableGroupPane = this.addTitledGroup(container, JptUiMappingsMessages.TableComposite_tableSection);
        WritablePropertyValueModel<HibernateTable> subjectHolder = this.buildTableHolder();
        TableCombo<HibernateTable> tc = this.addTableCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane);
        this.addLabeledComposite((Composite)tableGroupPane, JptUiMappingsMessages.TableChooser_label, tc, "org.eclipse.jpt.ui.entity_table");
        this.addLabeledComposite((Composite)tableGroupPane, JptUiMappingsMessages.CatalogChooser_label, (Pane)this.addCatalogCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane), "org.eclipse.jpt.ui.entity_catalog");
        this.addLabeledComposite((Composite)tableGroupPane, JptUiMappingsMessages.SchemaChooser_label, (Pane)this.addSchemaCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane), "org.eclipse.jpt.ui.entity_schema");
        new PaneEnabler(this.buildTableEnabledHolder(), (Pane)this);
    }

    protected WritablePropertyValueModel<HibernateTable> buildTableHolder() {
        return new PropertyAspectAdapter<HibernateEntity, HibernateTable>(this.getSubjectHolder(), new String[]{"tableIsUndefined"}){

            protected HibernateTable buildValue_() {
                return ((HibernateEntity)this.subject).tableIsUndefined() ? null : ((HibernateEntity)this.subject).getTable();
            }
        };
    }

    protected WritablePropertyValueModel<Boolean> buildTableEnabledHolder() {
        return new PropertyAspectAdapter<HibernateEntity, Boolean>(this.getSubjectHolder(), new String[]{"specifiedTableIsAllowed"}){

            protected Boolean buildValue_() {
                return ((HibernateEntity)this.subject).specifiedTableIsAllowed();
            }
        };
    }

    private CatalogCombo<HibernateTable> addCatalogCombo(PropertyValueModel<HibernateTable> tableHolder, Composite container) {
        return new CatalogCombo<HibernateTable>((Pane)this, tableHolder, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultCatalog();
            }

            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((HibernateTable)this.getSubject()).getSpecifiedCatalog();
            }
        };
    }

    private SchemaCombo<HibernateTable> addSchemaCombo(PropertyValueModel<HibernateTable> subjectHolder, Composite container) {
        return new SchemaCombo<HibernateTable>((Pane)this, subjectHolder, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
            }

            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultSchema();
            }

            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((HibernateTable)this.getSubject()).getSpecifiedSchema();
            }

            protected SchemaContainer getDbSchemaContainer_() {
                return ((HibernateTable)this.getSubject()).getDbSchemaContainer();
            }
        };
    }

    private TableCombo<HibernateTable> addTableCombo(PropertyValueModel<HibernateTable> subjectHolder, Composite container) {
        return new TableCombo<HibernateTable>((Pane)this, subjectHolder, container){

            @Override
            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateTable)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchema" || propertyName == "specifiedSchema" || propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultDBTableName();
            }

            @Override
            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            public String getValue() {
                String specifiedName = ((HibernateTable)this.getSubject()).getSpecifiedName();
                if (specifiedName == null) {
                    return null;
                }
                String dbTableName = ((HibernateTable)this.getSubject()).getDBTableName();
                if (specifiedName.equals(dbTableName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbTableName + ")";
            }

            @Override
            protected Schema getDbSchema_() {
                return ((HibernateTable)this.getSubject()).getDbSchema();
            }
        };
    }
}

