/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.widgets;

import java.util.Collection;
import java.util.List;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.node.AbstractNode;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.jpt.utility.internal.node.Problem;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameStateObject
extends AbstractNode {
    private String name;
    private Collection<String> names;
    private Node.Validator validator;
    static final String NAME_PROPERTY = "nameProperty";

    NameStateObject(String name, Collection<String> names) {
        super(null);
        this.name = name;
        this.names = names;
    }

    private void addNameProblemsTo(List<Problem> currentProblems) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            currentProblems.add(this.buildProblem(HibernateUIMappingMessages.NameStateObject_nameMustBeSpecified));
        } else if (this.names != null && this.names.contains(this.name.trim())) {
            currentProblems.add(this.buildProblem(HibernateUIMappingMessages.NameStateObject_nameAlreadyExists));
        }
    }

    protected void addProblemsTo(List<Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addNameProblemsTo(currentProblems);
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

