/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.ui.HibernateJptUIPlugin;
import org.jboss.tools.hibernate.jpt.ui.internal.platform.HibernateJpaPlatformUi;
import org.jboss.tools.hibernate.jpt.ui.wizard.GenerateDdlWizardPage;

public class GenerateDdlWizard
extends Wizard {
    private HibernateJpaProject jpaProject;
    private GenerateDdlWizardPage initPage;

    public GenerateDdlWizard(HibernateJpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.setWindowTitle(JptUiMessages.GenericPlatformUiDialog_notSupportedMessageTitle);
    }

    public void addPages() {
        super.addPages();
        this.initPage = new GenerateDdlWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.initPage);
    }

    public boolean performFinish() {
        String projectName = this.jpaProject.getName();
        ILaunchConfigurationWorkingCopy wc = HibernateJpaPlatformUi.createDefaultLaunchConfig(projectName);
        if (wc != null) {
            String concoleConfigurationName = this.initPage.getConfigurationName();
            wc.setAttribute("org.hibernate.tools.configurationname", concoleConfigurationName);
            wc.setAttribute("org.hibernate.tools.outputdir", this.initPage.getOutputDir());
            HashMap<String, String> prop = new HashMap<String, String>();
            prop.put("outputFileName", this.initPage.getFilename());
            prop.put("format", "true");
            prop.put("scriptToConsole", "false");
            prop.put("exportToDatabase", Boolean.toString(this.initPage.isExportToDB()));
            wc.setAttribute("org.hibernate.tools.exporters.hbmexporter.properties", prop);
            wc.setAttribute("org.hibernate.tools.exporters.hbmexporter.extension_id", "org.hibernate.tools.hbm2ddl");
            try {
                try {
                    wc.launch("run", null);
                }
                catch (CoreException e) {
                    HibernateJptUIPlugin.logException(e);
                    if (this.initPage.isTemporaryConfiguration()) {
                        KnownConfigurations.getInstance().removeConfiguration(KnownConfigurations.getInstance().find(concoleConfigurationName), false);
                    }
                }
            }
            finally {
                if (this.initPage.isTemporaryConfiguration()) {
                    KnownConfigurations.getInstance().removeConfiguration(KnownConfigurations.getInstance().find(concoleConfigurationName), false);
                }
            }
        }
        return true;
    }
}

