/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.jboss.tools.portlet.core.IJBossWebUtil;
import org.jboss.tools.portlet.core.PortletCoreActivator;

public class JBossWebUtil
implements IJBossWebUtil {
    public void configureContextParam(IProject project, IProgressMonitor monitor, String name, String value, String description) {
        ContextParam param;
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        IOverwriteQuery query = PortletCoreActivator.OVERWRITE_ALL_QUERY;
        EList list = null;
        list = webApp.getVersionID() == 23 ? webApp.getContexts() : webApp.getContextParams();
        int index = this.getContextParamIndexByName((List)list, name);
        if (index >= 0) {
            String ret = query.queryOverwrite("Context-param '" + name + "'");
            if ("NO".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            if ("CANCEL".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            list.remove(index);
        }
        if (webApp.getVersionID() == 23) {
            param = WebapplicationFactory.eINSTANCE.createContextParam();
            param.setParamName(name);
            param.setParamValue(value);
            if (description != null) {
                param.setDescription(description);
            }
            param.setWebApp(webApp);
        } else {
            param = CommonFactory.eINSTANCE.createParamValue();
            param.setName(name);
            param.setValue(value);
            if (description != null) {
                Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(description);
                param.getDescriptions().add((Object)descriptionObj);
                param.setDescription(description);
            }
            webApp.getContextParams().add((Object)param);
        }
    }

    private int getContextParamIndexByName(List list, String name) {
        if (list == null || name == null) {
            return -1;
        }
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            ContextParam param;
            Object paramObj = it.next();
            if (paramObj instanceof ContextParam && name.equals((param = (ContextParam)paramObj).getParamName())) {
                return index;
            }
            if (paramObj instanceof ParamValue && name.equals((param = (ParamValue)paramObj).getName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void configureFilter(IProject project, IProgressMonitor monitor, String name, String className, String displayName, String description) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        IOverwriteQuery query = PortletCoreActivator.OVERWRITE_ALL_QUERY;
        Filter obj = webApp.getFilterNamed(name);
        if (obj != null) {
            String ret = query.queryOverwrite("Filter '" + name + "'");
            if ("NO".equalsIgnoreCase(ret) || "CANCEL".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            webApp.getFilters().remove((Object)obj);
        }
        Filter filter = WebapplicationFactory.eINSTANCE.createFilter();
        filter.setName(name);
        filter.setFilterClassName(className);
        filter.setDescription(description);
        filter.setDisplayName(displayName);
        webApp.getFilters().add((Object)filter);
    }

    public void configureFilterMapping(IProject project, IProgressMonitor monitor, String name, String servletName) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        FilterMapping mapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
        Filter filter = webApp.getFilterNamed(name);
        if (filter != null) {
            mapping.setFilter(filter);
            mapping.setServletName(servletName);
            EList dispatcherTypes = mapping.getDispatcherType();
            dispatcherTypes.add((Object)DispatcherType.REQUEST_LITERAL);
            dispatcherTypes.add((Object)DispatcherType.FORWARD_LITERAL);
            dispatcherTypes.add((Object)DispatcherType.INCLUDE_LITERAL);
            Servlet servlet = webApp.getServletNamed(servletName);
            mapping.setServlet(servlet);
            webApp.getFilterMappings().add((Object)mapping);
        }
    }

    private Object getFilterMappingByKey(List list, String key) {
        if (list == null || key == null) {
            return null;
        }
        for (FilterMapping filterMapping : list) {
            String uri;
            String servletName;
            String name;
            String curKey;
            if (filterMapping == null || !key.equals(curKey = this.getFilterMappingString(name = filterMapping.getFilter().getName(), servletName = filterMapping.getServletName(), uri = filterMapping.getUrlPattern()))) continue;
            return filterMapping;
        }
        return null;
    }

    private String getFilterMappingString(String name, String servletName, String uri) {
        return String.valueOf(name != null ? name : "") + (servletName != null ? servletName : "") + (uri != null ? uri : "");
    }

    private WebApp getWebApp(IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (project == null) {
            return null;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return null;
        }
        return (WebApp)modelObject;
    }

    public String findJsfServlet(Object modelObject) {
        WebApp webApp = (WebApp)modelObject;
        for (Servlet servlet : webApp.getServlets()) {
            JavaClass servletClass = servlet.getServletClass();
            if (servletClass == null || !servletClass.getInstanceClassName().trim().equals(JSF_SERVLET_CLASS)) continue;
            return servlet.getServletName();
        }
        return null;
    }

    public String getFacesConfig(IProject project, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(project, monitor);
        EList contextParams = webApp.getContextParams();
        for (Object paramObj : contextParams) {
            ContextParam param;
            if (!(paramObj instanceof ContextParam) || !"javax.faces.CONFIG_FILES".equals((param = (ContextParam)paramObj).getParamName())) continue;
            return param.getParamValue();
        }
        return "/WEB-INF/faces-config.xml";
    }
}

