/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;

public class PortletFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.PortletFacetInstallDelegate_Missing_configuration));
            }
            config = (IDataModel)cfg;
            IModelProvider provider = PortletCoreActivator.getModelProvider(project);
            if (provider == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.PortletFacetInstallDelegate_Cannot_configure_web_module_for_JBoss_Portlet_Facet));
            }
            if (!provider.validateEdit(null, null).isOK() && !provider.validateEdit(null, null).isOK()) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.PortletFacetInstallDelegate_The_web_xml_file_is_not_updateable));
            }
            ((LibraryInstallDelegate)config.getProperty("PORTLET_LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
            this.createPortletXml(project, fv, config, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void setClasspath(IProgressMonitor monitor, IJavaProject javaProject, IDataModel config) throws CoreException {
        boolean deployPortletJars = config.getBooleanProperty("DEPLOY_PORTLET_JARS");
        if (deployPortletJars) {
            this.copyLibraries(monitor, javaProject, config);
        } else {
            String implementationLibrary = config.getStringProperty("implementationLibrary");
            if (IPortletConstants.LIBRARIES_PROVIDED_BY_SERVER_RUNTIME.equals(implementationLibrary)) {
                Path containerPath = new Path("org.jboss.tools.portlet.core.internal.portletlibrarycontainer.runtime");
                this.setContainerPath(monitor, javaProject, (IPath)containerPath);
            } else {
                String libraryName = config.getStringProperty("userLibraryName");
                if (libraryName != null && libraryName.trim().length() > 0) {
                    Path containerPath = new Path("org.eclipse.jdt.USER_LIBRARY/" + libraryName);
                    this.setContainerPath(monitor, javaProject, (IPath)containerPath);
                } else {
                    PortletCoreActivator.log(null, Messages.PortletFacetInstallDelegate_User_library_name_is_invalid);
                }
            }
        }
    }

    private void copyLibraries(IProgressMonitor monitor, IJavaProject javaProject, IDataModel config) {
    }

    private void setContainerPath(IProgressMonitor monitor, IJavaProject javaProject, IPath containerPath) throws CoreException {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)containerPath, (boolean)true);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[entries.length] = entry;
        javaProject.setRawClasspath(newEntries, monitor);
    }

    private void createPortletXml(final IProject project, final IProjectFacetVersion fv, IDataModel config, final IProgressMonitor monitor) {
        try {
            IWorkspaceRunnable op = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor_inner) throws CoreException {
                    PortletCoreActivator.createPortletXml(fv.getVersionString(), project, monitor);
                    project.refreshLocal(2, monitor_inner);
                }
            };
            op.run(monitor);
        }
        catch (CoreException e) {
            PortletCoreActivator.log((Exception)((Object)e), Messages.PortletFacetInstallDelegate_Exception_occured_while_creating_portlet_xml);
        }
    }
}

