/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.project.facet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.libprov.AbstractLibraryProviderInstallOperationConfig;
import org.jboss.tools.portlet.core.libprov.JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPostInstallListener
implements IFacetedProjectListener {
    private static final IProjectFacet seamFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
    private static final IOverwriteQuery OVERWRITE_NONE_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "NOALL";
        }
    };
    private String portletbridgeRuntime;
    private boolean richfacesCapabilities = false;
    private String richfacesType;
    private String richfacesRuntime;

    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent actionEvent;
        IProjectFacet projectFacet;
        if (event instanceof IProjectFacetActionEvent && !"jboss.jsfportlet".equals((projectFacet = (actionEvent = (IProjectFacetActionEvent)event).getProjectFacet()).getId())) {
            return;
        }
        IFacetedProject facetedProject = event.getProject();
        Set projectFacets = facetedProject.getProjectFacets();
        boolean isJSFPortlet = false;
        boolean richfacesFromServerRuntime = false;
        for (IProjectFacetVersion projectFacetVersion : projectFacets) {
            IProjectFacet projectFacet2 = projectFacetVersion.getProjectFacet();
            if (!"jboss.jsfportlet".equals(projectFacet2.getId())) continue;
            isJSFPortlet = true;
        }
        if (!isJSFPortlet) {
            return;
        }
        if (isJSFPortlet) {
            IProjectFacetActionEvent actionEvent2 = (IProjectFacetActionEvent)event;
            IDataModel dataModel = (IDataModel)actionEvent2.getActionConfig();
            try {
                LibraryInstallDelegate libraryDelegate = (LibraryInstallDelegate)dataModel.getProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE");
                if (libraryDelegate != null) {
                    AbstractLibraryProviderInstallOperationConfig libraryConfig;
                    ILibraryProvider libraryProvider = libraryDelegate.getLibraryProvider();
                    String providerId = libraryProvider.getId();
                    if ("jsfportletbridge-library-provider".equals(providerId)) {
                        libraryConfig = (JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig)libraryDelegate.getLibraryProviderOperationConfig(libraryProvider);
                        this.portletbridgeRuntime = ((JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig)libraryConfig).getPortletbridgeHome();
                    } else {
                        this.portletbridgeRuntime = null;
                    }
                    richfacesFromServerRuntime = "jsfportlet-library-provider".equals(providerId);
                    if ("jsfportletbridge-library-provider".equals(providerId) || "jsfportlet-library-provider".equals(providerId)) {
                        libraryConfig = (AbstractLibraryProviderInstallOperationConfig)libraryDelegate.getLibraryProviderOperationConfig(libraryProvider);
                        this.richfacesCapabilities = libraryConfig.isAddRichfacesCapabilities();
                        this.richfacesRuntime = libraryConfig.getRichfacesRuntime();
                        this.richfacesType = libraryConfig.getRichfacesType();
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (isJSFPortlet) {
            if (this.portletbridgeRuntime != null) {
                this.addLibrariesFromPortletBridgeRuntime(facetedProject, this.portletbridgeRuntime);
            } else if (richfacesFromServerRuntime) {
                this.addLibrariesFromServerRuntime(facetedProject);
            }
        }
    }

    private void addLibrariesFromServerRuntime(IFacetedProject facetedProject) {
        boolean addRichfacesFromRichfacesRuntime;
        final boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
        boolean bl = addRichfacesFromRichfacesRuntime = this.richfacesCapabilities && IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richfacesType);
        if (addRichfacesFromRichfacesRuntime) {
            this.addRichfacesFromRichfacesRuntime(facetedProject);
        }
        if (isSeamProject) {
            return;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetedProject.getPrimaryRuntime();
        if (facetRuntime == null) {
            return;
        }
        IRuntime runtime = PortletCoreActivator.getRuntime(facetRuntime);
        if (runtime == null) {
            return;
        }
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            File richfacesLib;
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            IPath portletLib = configPath.append("deploy/jboss-portal.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
            File libFile = portletLib.toFile();
            if (!libFile.exists()) {
                portletLib = configPath.append("deploy/jboss-portal-ha.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
                libFile = portletLib.toFile();
            }
            if (!(richfacesLib = libFile).exists()) {
                PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_Richfaces_ibraries);
                return;
            }
            if (!richfacesLib.isDirectory()) {
                PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_Richfaces_ibraries);
                return;
            }
            try {
                IProject project = facetedProject.getProject();
                final IProject earProject = this.getEarProject(project, isSeamProject);
                String[] fileList = richfacesLib.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (!addRichfacesFromRichfacesRuntime) {
                            if (name.startsWith("richfaces-ui") && name.endsWith(".jar")) {
                                return true;
                            }
                            if (name.startsWith("richfaces-impl") && name.endsWith(".jar")) {
                                return true;
                            }
                            if (earProject == null && name.startsWith("richfaces-api") && name.endsWith(".jar")) {
                                return true;
                            }
                        }
                        if (!isSeamProject) {
                            if (name.startsWith("portal")) {
                                return false;
                            }
                            return !name.startsWith("portletbridge");
                        }
                        return false;
                    }
                });
                ArrayList<File> filesToImport = new ArrayList<File>();
                int i = 0;
                while (i < fileList.length) {
                    filesToImport.add(new File(richfacesLib, fileList[i]));
                    ++i;
                }
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFolder rootFolder = component.getRootFolder();
                IContainer folder = rootFolder.getUnderlyingFolder();
                IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
                this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
                ImportOperation importOperation = new ImportOperation(webinf.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                importOperation.setCreateContainerStructure(false);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                if (earProject != null) {
                    fileList = richfacesLib.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith("richfaces-api") && name.endsWith(".jar");
                        }
                    });
                    filesToImport = new ArrayList();
                    int i2 = 0;
                    while (i2 < fileList.length) {
                        filesToImport.add(new File(richfacesLib, fileList[i2]));
                        ++i2;
                    }
                    component = ComponentCore.createComponent((IProject)earProject);
                    rootFolder = component.getRootFolder();
                    folder = rootFolder.getUnderlyingFolder();
                    this.deleteOldRichFacesApi(folder);
                    importOperation = new ImportOperation(folder.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                    importOperation.setCreateContainerStructure(false);
                    importOperation.run((IProgressMonitor)new NullProgressMonitor());
                    this.updateEARLibraries(project, isSeamProject);
                }
            }
            catch (Exception e) {
                PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
            }
        }
    }

    private void addRichfacesFromRichfacesRuntime(IFacetedProject facetedProject) {
        boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
        if (!isSeamProject && !this.richfacesCapabilities) {
            return;
        }
        File richfacesRuntimeHome = new File(this.richfacesRuntime);
        File richfacesLib = new File(richfacesRuntimeHome, "lib");
        if (!richfacesLib.exists()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_Richfaces_Runtime);
            return;
        }
        if (!richfacesLib.isDirectory()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Invalid_Richfaces_Runtime);
            return;
        }
        try {
            IProject project = facetedProject.getProject();
            final IProject earProject = this.getEarProject(project, isSeamProject);
            String[] fileList = richfacesLib.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.startsWith("richfaces-ui") && name.endsWith(".jar")) {
                        return true;
                    }
                    if (name.startsWith("richfaces-impl") && name.endsWith(".jar")) {
                        return true;
                    }
                    return earProject == null && name.startsWith("richfaces-api") && name.endsWith(".jar");
                }
            });
            ArrayList<File> filesToImport = new ArrayList<File>();
            int i = 0;
            while (i < fileList.length) {
                filesToImport.add(new File(richfacesLib, fileList[i]));
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
            ImportOperation importOperation = new ImportOperation(webinf.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            importOperation.run((IProgressMonitor)new NullProgressMonitor());
            if (earProject != null) {
                fileList = richfacesLib.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("richfaces-api") && name.endsWith(".jar");
                    }
                });
                filesToImport = new ArrayList();
                int i2 = 0;
                while (i2 < fileList.length) {
                    filesToImport.add(new File(richfacesLib, fileList[i2]));
                    ++i2;
                }
                component = ComponentCore.createComponent((IProject)earProject);
                rootFolder = component.getRootFolder();
                folder = rootFolder.getUnderlyingFolder();
                this.deleteOldRichFacesApi(folder);
                importOperation = new ImportOperation(folder.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                importOperation.setCreateContainerStructure(false);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                this.updateEARLibraries(project, isSeamProject);
            }
        }
        catch (Exception e) {
            PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
        }
    }

    private void updateEARLibraries(IProject project, boolean isSeamProject) {
        IProject ejbProj = this.getEjbProject(project, isSeamProject);
        IProject earProject = this.getEarProject(project, isSeamProject);
        IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer folder = rootFolder.getUnderlyingFolder();
        File earContentFolder = folder.getLocation().toFile();
        File[] earJars = earContentFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.lastIndexOf(".jar") > 0;
            }
        });
        String clientURI = "";
        File[] fileArray = earJars;
        int n = earJars.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            clientURI = String.valueOf(clientURI) + " " + file.getName();
            ++n2;
        }
        try {
            new UpdateManifestOperation(ejbProj, clientURI, true).run();
            new UpdateManifestOperation(project, clientURI, true).run();
        }
        catch (Exception e) {
            PortletCoreActivator.log(e);
        }
    }

    private void addLibrariesFromPortletBridgeRuntime(IFacetedProject facetedProject, String portletbridgeRuntime) {
        File portletbridgeHome = new File(portletbridgeRuntime);
        if (!portletbridgeHome.exists()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_Portletbridge_Runtime);
            return;
        }
        if (!portletbridgeHome.isDirectory()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Invalid_Portletbridge_Runtime);
            return;
        }
        File examplesHome = new File(portletbridgeHome, "examples");
        if (!examplesHome.exists() || !examplesHome.isDirectory()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_the_examples_directory);
            return;
        }
        File richFacesPortletZip = this.getRichFacesExamples(examplesHome);
        if (!richFacesPortletZip.exists() || !richFacesPortletZip.isFile()) {
            PortletCoreActivator.log(null, Messages.PortletPostInstallListener_Cannot_find_the_RichFacesPortlet_war_file);
            return;
        }
        try {
            boolean addRichfacesFromRichfacesRuntime;
            ZipFile zipFile = new ZipFile(richFacesPortletZip);
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
            boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
            boolean bl = addRichfacesFromRichfacesRuntime = this.richfacesCapabilities && IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richfacesType);
            if (addRichfacesFromRichfacesRuntime) {
                this.addRichfacesFromRichfacesRuntime(facetedProject);
            }
            List<ZipEntry> list = this.prepareList(zipFile, facetedProject, isSeamProject, addRichfacesFromRichfacesRuntime);
            IProject project = facetedProject.getProject();
            IProject earProject = this.getEarProject(project, isSeamProject);
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            if (!addRichfacesFromRichfacesRuntime) {
                this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
            }
            IPath destPath = folder.getFullPath();
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, OVERWRITE_NONE_QUERY, list);
            op.run((IProgressMonitor)new NullProgressMonitor());
            if (earProject != null) {
                list = this.prepareEarList(zipFile);
                component = ComponentCore.createComponent((IProject)earProject);
                rootFolder = component.getRootFolder();
                folder = rootFolder.getUnderlyingFolder();
                this.deleteOldRichFacesApi(folder);
                destPath = folder.getFullPath();
                ZipEntry root = zipFile.getEntry("WEB-INF/lib");
                op = new ImportOperation(destPath, (Object)root, (IImportStructureProvider)structureProvider, OVERWRITE_NONE_QUERY, list);
                op.setCreateContainerStructure(false);
                op.run((IProgressMonitor)new NullProgressMonitor());
                this.updateEARLibraries(project, isSeamProject);
            }
        }
        catch (Exception e) {
            PortletCoreActivator.log(e);
        }
    }

    private File getRichFacesExamples(File examplesHome) {
        File file = new File(examplesHome, "RichFacesPortlet.war");
        if (file.exists() && file.isFile()) {
            return file;
        }
        File[] listFiles = examplesHome.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("seamPortlet") && name.endsWith(".war");
            }
        });
        if (listFiles.length > 0) {
            return listFiles[0];
        }
        return null;
    }

    private void deleteOldRichFacesApi(IContainer folder) throws CoreException {
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource != null && resource.exists() && resource.getName().startsWith("richfaces-api") && resource.getName().endsWith("jar")) {
                resource.delete(true, null);
                break;
            }
            ++i;
        }
    }

    private void deleteOldRichfacesLibs(IProject earProject, IContainer webinf) throws CoreException {
        if (webinf != null && webinf.exists()) {
            IResource[] members = webinf.members();
            int i = 0;
            while (i < members.length) {
                IResource resource = members[i];
                if (resource != null && resource.exists()) {
                    if (resource.getName().startsWith("richfaces-ui") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (resource.getName().startsWith("richfaces-impl") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (earProject == null && resource.getName().startsWith("richfaces-api") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                }
                ++i;
            }
        }
    }

    private IProject getEarProject(IProject project, boolean isSeamProject) {
        if (isSeamProject && project != null) {
            IEclipsePreferences preferences = PortletPostInstallListener.getSeamPreferences(project);
            String earProjectName = preferences.get("seam.ear.project", null);
            if (earProjectName == null) {
                return null;
            }
            IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName);
            if (earProject != null && earProject.isOpen()) {
                return earProject;
            }
        }
        return null;
    }

    private IProject getEjbProject(IProject project, boolean isSeamProject) {
        if (isSeamProject && project != null) {
            IEclipsePreferences preferences = PortletPostInstallListener.getSeamPreferences(project);
            String ejbProjectName = preferences.get("seam.ejb.project", null);
            if (ejbProjectName == null) {
                return null;
            }
            IProject ejbProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ejbProjectName);
            if (ejbProject != null && ejbProject.isOpen()) {
                return ejbProject;
            }
        }
        return null;
    }

    public static IEclipsePreferences getSeamPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode("org.jboss.tools.seam.core");
    }

    private List<ZipEntry> prepareList(ZipFile rootEntry, IFacetedProject facetedProject, boolean isSeamProject, boolean addRichfacesFromRichfacesRuntime) {
        if (rootEntry == null) {
            return null;
        }
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
        if (!isSeamProject && !this.richfacesCapabilities) {
            return list;
        }
        Enumeration<? extends ZipEntry> entries = rootEntry.entries();
        IProject earProject = this.getEarProject(facetedProject.getProject(), isSeamProject);
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".jar")) continue;
            if (!addRichfacesFromRichfacesRuntime) {
                if (entry.getName().startsWith("WEB-INF/lib/richfaces-ui")) {
                    list.add(entry);
                }
                if (entry.getName().startsWith("WEB-INF/lib/richfaces-impl")) {
                    list.add(entry);
                }
                if (earProject == null && entry.getName().startsWith("WEB-INF/lib/richfaces-api")) {
                    list.add(entry);
                }
            }
            if (isSeamProject || !entry.getName().startsWith("WEB-INF/lib/commons-beanutils") && !entry.getName().startsWith("WEB-INF/lib/commons-digester") && !entry.getName().startsWith("WEB-INF/lib/jsf-facelets")) continue;
            list.add(entry);
        }
        return list;
    }

    private List<ZipEntry> prepareEarList(ZipFile zipFile) {
        if (zipFile == null) {
            return null;
        }
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".jar") || !entry.getName().startsWith("WEB-INF/lib/richfaces-api")) continue;
            list.add(entry);
        }
        return list;
    }

    private class UpdateManifestOperation
    implements Runnable {
        protected IProject project;
        protected String classPathValue;
        protected boolean replace;

        public UpdateManifestOperation(IProject project, String aSpaceDelimitedPath, boolean replaceInsteadOfMerge) {
            this.project = project;
            this.classPathValue = aSpaceDelimitedPath;
            this.replace = replaceInsteadOfMerge;
        }

        public void run() {
            ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)this.project);
            if (mf == null) {
                mf = new ArchiveManifestImpl();
            }
            mf.addVersionIfNecessary();
            if (this.replace) {
                mf.setClassPath(this.classPathValue);
            } else {
                mf.mergeClassPath(ArchiveUtil.getTokens((String)this.classPathValue));
            }
            try {
                J2EEProjectUtilities.writeManifest((IProject)this.project, (ArchiveManifest)mf);
            }
            catch (IOException e) {
                PortletCoreActivator.log(e);
            }
        }
    }
}

