/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.libprov;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderInstallOperationConfig;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractLibraryProviderInstallOperationConfig
extends LibraryProviderInstallOperationConfig {
    private boolean addRichfacesCapabilities;
    private String richfacesType;
    private String richfacesRuntime;

    public synchronized IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (!this.addRichfacesCapabilities) {
            return status;
        }
        if (!IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richfacesType)) {
            return status;
        }
        if (this.richfacesRuntime == null) {
            return this.getInvalidRichfacesRuntime();
        }
        this.richfacesRuntime = this.richfacesRuntime.trim();
        if (this.richfacesRuntime.length() <= 0) {
            return this.getInvalidRichfacesRuntime();
        }
        File folder = new File(this.richfacesRuntime);
        if (!folder.exists() || !folder.isDirectory()) {
            return this.getInvalidRichfacesRuntime();
        }
        if (!(folder = new File(folder, "lib")).exists() || !folder.isDirectory()) {
            return this.getInvalidRichfacesRuntime();
        }
        String[] fileList = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("richfaces") || name.endsWith(".jar");
            }
        });
        if (fileList.length < 3) {
            return this.getInvalidRichfacesRuntime();
        }
        return Status.OK_STATUS;
    }

    private IStatus getInvalidRichfacesRuntime() {
        Status status = new Status(4, "org.jboss.tools.portlet.core", Messages.PortletPostInstallListener_Invalid_Richfaces_Runtime);
        return status;
    }

    private void updatePreferences() {
        IProjectFacet f = this.getProjectFacet();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)f);
            prefs = prefs.node("portletBridgeHome");
            prefs.putBoolean("RICHFACES_CAPABILITIES", this.addRichfacesCapabilities);
            prefs.put("RICHFACES_LIBRARIES_TYPE", this.richfacesType);
            prefs.put("RICHFACES_RUNTIME", this.richfacesRuntime);
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }

    public boolean isAddRichfacesCapabilities() {
        return this.addRichfacesCapabilities;
    }

    public void init(IFacetedProjectBase fpj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fpj, fv, provider);
        this.reset();
    }

    public void reset() {
        super.reset();
        IProjectFacet f = this.getProjectFacet();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)f);
            prefs = prefs.node("portletBridgeHome");
            if (prefs.nodeExists("jsfportlet.library.provider/portletbridge_home")) {
                this.addRichfacesCapabilities = prefs.getBoolean("RICHFACES_CAPABILITIES", false);
                this.richfacesType = prefs.get("RICHFACES_LIBRARIES_TYPE", null);
                this.richfacesRuntime = prefs.get("RICHFACES_RUNTIME", null);
            }
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }

    public void setAddRichfacesCapabilities(boolean addRichfacesCapabilities) {
        boolean oldValue = this.addRichfacesCapabilities;
        this.addRichfacesCapabilities = addRichfacesCapabilities;
        this.notifyListeners("RICHFACES_CAPABILITIES", oldValue, addRichfacesCapabilities);
        this.updatePreferences();
    }

    public String getRichfacesType() {
        return this.richfacesType;
    }

    public void setRichfacesType(String richfacesType) {
        String oldValue = this.richfacesType;
        this.richfacesType = richfacesType;
        this.notifyListeners("RICHFACES_LIBRARIES_TYPE", oldValue, richfacesType);
        this.updatePreferences();
    }

    public String getRichfacesRuntime() {
        return this.richfacesRuntime;
    }

    public void setRichfacesRuntime(String richfacesRuntime) {
        String oldValue = this.richfacesRuntime;
        this.richfacesRuntime = richfacesRuntime;
        this.notifyListeners("RICHFACES_RUNTIME", oldValue, richfacesRuntime);
        this.updatePreferences();
    }
}

