/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.libprov;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.libprov.JSFPortletServerRuntimeLibraryProviderInstallOperationConfig;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSFPortletServerRuntimeLibraryProviderInstallOperation
extends LibraryProviderOperation {
    public void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        IFacetedProjectBase facetedProject = config.getFacetedProject();
        IProjectFacet seamFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
        boolean hasSeamFacet = facetedProject.hasProjectFacet(seamFacet);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetedProject.getPrimaryRuntime();
        IProject project = facetedProject.getProject();
        IRuntime runtime = PortletCoreActivator.getRuntime(facetRuntime);
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            IPath portletLib = configPath.append("deploy/jboss-portal.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
            File portletLibFile = portletLib.toFile();
            String[] files = this.getPortletbridgeLibraries(portletLibFile, hasSeamFacet);
            if (files == null) {
                portletLib = configPath.append("deploy/jboss-portal-ha.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
                portletLibFile = portletLib.toFile();
                files = this.getPortletbridgeLibraries(portletLibFile, hasSeamFacet);
            }
            if (files != null) {
                try {
                    ArrayList<File> filesToImport = new ArrayList<File>();
                    int i = 0;
                    while (i < files.length) {
                        filesToImport.add(new File(portletLibFile, files[i]));
                        ++i;
                    }
                    IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                    IVirtualFile libVirtualFile = component.getRootFolder().getFile("WEB-INF/lib");
                    IFile folder = libVirtualFile.getUnderlyingFile();
                    File sourceFolder = new File(portletLib.toOSString());
                    ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)sourceFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                    importOperation.setCreateContainerStructure(false);
                    importOperation.run(monitor);
                }
                catch (Exception e) {
                    PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
                }
            }
        }
        JSFPortletServerRuntimeLibraryProviderInstallOperationConfig serverConfig = (JSFPortletServerRuntimeLibraryProviderInstallOperationConfig)config;
        boolean addRichfacesCapabilities = serverConfig.isAddRichfacesCapabilities();
        String richfacesType = serverConfig.getRichfacesType();
        String richfacesRuntime = serverConfig.getRichfacesRuntime();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)config.getProjectFacet());
            prefs = prefs.node("portletBridgeHome");
            prefs.putBoolean("RICHFACES_CAPABILITIES", addRichfacesCapabilities);
            prefs.put("RICHFACES_LIBRARIES_TYPE", richfacesType);
            prefs.put("RICHFACES_RUNTIME", richfacesRuntime);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }

    private String[] getPortletbridgeLibraries(File file, final boolean hasSeamFacet) {
        if (file != null && file.isDirectory()) {
            String[] list = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if ("portletbridge-api.jar".equals(name) || "portletbridge-impl.jar".equals(name)) {
                        return true;
                    }
                    if (!hasSeamFacet) {
                        return !name.startsWith("portal");
                    }
                    return false;
                }
            });
            return list;
        }
        return null;
    }
}

